/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.recovery.framework.checker;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.constant.PolicyTemplateType;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.replica.sdk.model.RemoteStorageReplica;
import com.huawei.ism.drm.recovery.framework.checker.HyperMetroRecoveryProcessChecker;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.recovery.task.RecoveryTask;
import com.huawei.ism.drm.util.CastUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class ReplicationRecoveryProcessChecker
extends HyperMetroRecoveryProcessChecker {
    private static final String SYNC_ASYNC_RING_STRATEGY = "2";
    private static final List<Integer> ARRAY_SYNC_TEMPLATE = Arrays.asList(PolicyTemplateType.PolicyTemplateE.ARRAY_CONCURRENT_SYNC_ASYNC.getValue(), PolicyTemplateType.PolicyTemplateE.ARRAY_CASCADE_SYNC_ASYNC.getValue());

    @Override
    public void check(RecoveryProcessorContext context, DrmEnumDefine.RecoveryPlanExecuteTypeE procType) {
        VerifyUtil.checkObject((Object)context);
        RecoveryPlan recoveryPlan = context.getRecoveryPlan();
        VerifyUtil.checkObject((Object)recoveryPlan);
        ProtectGroup protectGroup = recoveryPlan.getProtectGroup();
        int policyType = protectGroup.getTemplate().getType();
        if (ARRAY_SYNC_TEMPLATE.contains(policyType) && DrmEnumDefine.RecoveryPlanExecuteTypeE.DRILLING.getValue() == procType.getValue()) {
            this.handleDRRingDrilling(context);
        }
    }

    @Override
    public void handleDRRingDrilling(RecoveryProcessorContext context) {
        Collection recoveryTasks = (Collection)context.getAttribute("recoveryTasks");
        List tasks = recoveryTasks.stream().filter(this::hasRingId).collect(Collectors.toList());
        if (tasks.isEmpty()) {
            return;
        }
        RecoveryProcessorContext tmpContext = new RecoveryProcessorContext();
        tmpContext.setAttribute("recoveryTasks", tasks);
        super.handleDRRingDrilling(tmpContext);
    }

    private boolean hasRingId(RecoveryTask recoveryTask) {
        Map params = recoveryTask.getParams();
        if (VerifyUtil.isEmpty((Map)params)) {
            return false;
        }
        Object replicaObj = params.get("replica");
        if (!(replicaObj instanceof RemoteStorageReplica)) {
            return false;
        }
        RemoteStorageReplica remoteStorageReplica = (RemoteStorageReplica)CastUtil.castTo(replicaObj, RemoteStorageReplica.class);
        String drRingId = remoteStorageReplica.getDrRingId();
        return !VerifyUtil.isEmpty((String)drRingId);
    }

    @Override
    protected String getDrStrategy() {
        return SYNC_ASYNC_RING_STRATEGY;
    }
}

