/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.recovery.framework.checker;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.constant.PolicyTemplateType;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObjectStorageInfo;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectObjectReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.RelicaStorageInfo;
import com.huawei.ism.drm.recovery.process.IRecoveryProcessChecker;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.storage.sdk.service.IStorageService;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;

public class RollbackProcessChecker
implements IRecoveryProcessChecker {
    private static Log logger = LogFactory.getInstance(RollbackProcessChecker.class);
    private static final List<Integer> AVAILABLE_EXECUTE_TYPE = new ArrayList<Integer>();

    public void check(RecoveryProcessorContext context, DrmEnumDefine.RecoveryPlanExecuteTypeE procType) {
        if (null == context || null == procType) {
            logger.error((Object)"Invalid parameters.");
            return;
        }
        RecoveryPlan recoveryPlan = context.getRecoveryPlan();
        if (null == recoveryPlan || VerifyUtil.isEmpty((Collection)recoveryPlan.getProtectGroups())) {
            logger.debug((Object)"Invalid parameters.");
            return;
        }
        Set protectGroups = recoveryPlan.getProtectGroups();
        ProtectGroupReplica replica = context.getProtectGroupReplica();
        if (null == replica) {
            logger.debug((Object)"Invalid parameters.");
            return;
        }
        for (ProtectGroup pg : protectGroups) {
            if (!AVAILABLE_EXECUTE_TYPE.contains(procType.getValue())) continue;
            this.checkReplicaStorageInfo(pg, replica);
            this.checkReplicaLocation(pg, replica);
            this.checkReplicaRole(pg, replica);
        }
    }

    private void checkReplicaStorageInfo(ProtectGroup protectGroup, ProtectGroupReplica replica) {
        Set set = protectGroup.getPolist();
        if (VerifyUtil.isEmpty((Collection)set)) {
            return;
        }
        if (10 != ((ProtectObject)CommonUtil.getFirstElement((Collection)set)).getPoType()) {
            return;
        }
        List storageInfos = protectGroup.distinctStorageInfo();
        if (VerifyUtil.isEmpty((Collection)storageInfos)) {
            return;
        }
        HashMap<String, Set<String>> wwnMap = new HashMap<String, Set<String>>();
        for (ProtectObjectStorageInfo storageInfo : storageInfos) {
            String mountPoint = storageInfo.getMountPoint();
            if (VerifyUtil.isEmpty((String)mountPoint) || VerifyUtil.isEmpty((String)storageInfo.getLunWWN())) continue;
            HashSet<String> wwnList = (HashSet<String>)wwnMap.get(mountPoint);
            if (null == wwnList) {
                wwnList = new HashSet<String>();
            }
            wwnList.add(storageInfo.getLunWWN());
            wwnMap.put(mountPoint, wwnList);
        }
        if (VerifyUtil.isEmpty((Collection)replica.getReplicas())) {
            return;
        }
        HashSet<String> replicaWwns = new HashSet<String>();
        for (ProtectObjectReplica repilica : replica.getReplicas()) {
            for (RelicaStorageInfo info : repilica.getStorageInfos()) {
                replicaWwns.add(info.getProtectObjectStorageWwn());
            }
        }
        this.checkWwn(wwnMap, replicaWwns);
    }

    private void checkWwn(Map<String, Set<String>> wwnMap, Set<String> replicaWwns) {
        for (Map.Entry<String, Set<String>> entry : wwnMap.entrySet()) {
            Set<String> wwnList = entry.getValue();
            boolean isExists = false;
            boolean isNotAllExists = false;
            for (String wwn : wwnList) {
                if (replicaWwns.contains(wwn)) {
                    isExists = true;
                    continue;
                }
                isNotAllExists = true;
            }
            if (!isExists || !isNotAllExists) continue;
            throw new LegoCheckedException(1073948255L);
        }
    }

    private void checkReplicaLocation(ProtectGroup pg, ProtectGroupReplica replica) {
        if (32 == pg.getTemplate().getType() && replica.getProtectLocation() == DrmEnumDefine.ProtectLocation.B_B.getValue()) {
            throw new LegoCheckedException(1073948754L);
        }
    }

    private void checkReplicaRole(ProtectGroup pg, ProtectGroupReplica replica) {
        int templateType = pg.getTemplate().getType();
        if (!PolicyTemplateType.AIR_GAP_NETWORKING.contains(templateType)) {
            return;
        }
        ArrayList<String> resourceIds = new ArrayList<String>();
        Set replicas = replica.getReplicas();
        for (ProtectObjectReplica poReplica : replicas) {
            for (RelicaStorageInfo storageInfo : poReplica.getStorageInfos()) {
                resourceIds.add(storageInfo.getSrcStorageId());
            }
        }
        logger.info((Object)"Get resourceIds: %s", new Object[]{resourceIds});
        IStorageService storageService = (IStorageService)ServiceLocator.getInstance().getService(IStorageService.class);
        String providerDevSn = pg.getPoProviderSN();
        int resourceType = pg.getPoType() == 11 ? DrmEnumDefine.ResourceTypeE.LUN.getValue() : DrmEnumDefine.ResourceTypeE.NAS.getValue();
        List pairs = storageService.getReplicationPairsByResourceIds(providerDevSn, resourceIds, false, Integer.valueOf(resourceType));
        if (CollectionUtils.isEmpty((Collection)pairs)) {
            logger.error((Object)"Air Gap not allowed rollback when pair role is primary. pgName: %s", new Object[]{pg.getName()});
            throw new LegoCheckedException(1073948764L);
        }
    }

    public String getName() {
        return this.getClass().getName();
    }

    static {
        AVAILABLE_EXECUTE_TYPE.add(DrmEnumDefine.RecoveryPlanExecuteTypeE.SNAPSHOT_ROLLBACK.getValue());
    }
}

