/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.recovery.framework.process;

import com.huawei.ism.cbb.base.sdk.bo.QueryCondition;
import com.huawei.ism.cbb.proxy.xve.XveMOType;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.constant.ReplicationConstantDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryPlanService;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryProcessService;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryResourceService;
import com.huawei.ism.drm.protection.framework.service.replica.retention.util.CheckReplicaTools;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObjectStorageInfo;
import com.huawei.ism.drm.protection.replica.sdk.model.LocalStorageReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectObjectReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.RelicaStorageInfo;
import com.huawei.ism.drm.protection.template.sdk.model.PolicyTemplate;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.framework.process.RecoveryProcessorMgr;
import com.huawei.ism.drm.recovery.framework.util.RecoveryProcessUtil;
import com.huawei.ism.drm.recovery.process.IProcessorInfoService;
import com.huawei.ism.drm.recovery.process.ProcessorInfoServiceManagerProxy;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.storage.manager.proxy.StorageHyperCDPManagerProxy;
import com.huawei.ism.drm.storage.manager.proxy.StorageSnapshotManagerProxy;
import com.huawei.ism.drm.storage.manager.sdk.service.IStorageHyperCDPManager;
import com.huawei.ism.drm.storage.manager.sdk.service.IStorageSnapshotManager;
import com.huawei.ism.drm.storage.sdk.model.Snapshot;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.exception.LegoUnsupportedOperationException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class BeginLocalRecoveryProcessor
extends BaseRecoveryProcessor {
    private static final long serialVersionUID = 6543915804736380219L;
    private static final Log logger = LogFactory.getInstance(BeginLocalRecoveryProcessor.class);

    public BeginLocalRecoveryProcessor() {
        this.setProcName(this.getName());
    }

    public String getName() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public void updateProcessName() {
        this.setProcName(this.calcProcessName());
    }

    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    public int hashCode() {
        return super.hashCode();
    }

    protected boolean execute(RecoveryProcessorContext context) {
        RecoveryPlan recoveryPlan = context.getRecoveryPlan();
        if (null == recoveryPlan) {
            logger.error((Object)"recoveryPlan is null.");
            throw new LegoCheckedException(1073947393L);
        }
        ((IRecoveryPlanService)ServiceLocator.getInstance().getService(IRecoveryPlanService.class)).setPoRepToRecoveryPlan(recoveryPlan);
        RecoveryProcessUtil.presetCheck(context, DrmEnumDefine.RecoveryPlanExecuteTypeE.getType((int)this.getProcType()));
        this.saveInfoToContextParams(context);
        if (DrmEnumDefine.RecoveryPlanExecuteTypeE.CLEAN_DRILLING.getValue() != this.getProcType()) {
            Collection recoveryTasks = RecoveryProcessorMgr.getInstance().getRecoveryProcessHandler().getLocalRecoveryTasks(context);
            if (VerifyUtil.isEmpty((Collection)recoveryTasks)) {
                this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
                this.updateProcessDetail("ism.drm.drp.localprepare.err", null);
                return false;
            }
            context.setAttribute("recoveryTasks", (Object)recoveryTasks);
        } else {
            if (VerifyUtil.isEmpty((Collection)recoveryPlan.getProtectGroups())) {
                logger.error((Object)"ProtectGroups is empty.");
                throw new LegoCheckedException(1073947393L);
            }
            Iterator iterator = recoveryPlan.getProtectGroups().iterator();
            if (!iterator.hasNext()) {
                throw new LegoCheckedException(1073947393L);
            }
            int templateType = ((ProtectGroup)iterator.next()).getTemplate().getType();
            ArrayList<QueryCondition> conditions = new ArrayList<QueryCondition>();
            conditions.add(new QueryCondition("procType", (Object)DrmEnumDefine.RecoveryPlanExecuteTypeE.DRILLING.getValue()));
            conditions.add(new QueryCondition("protectionType", (Object)templateType));
            IRecoveryProcessService rpService = (IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class);
            List mountBeginProcess = rpService.getRecoveryProcessors(recoveryPlan.getPlanId(), conditions, BeginLocalRecoveryProcessor.class);
            if (!mountBeginProcess.isEmpty()) {
                recoveryPlan.getGlobalSettings().put("REPLICA_ID", ((RecoveryProcessor)mountBeginProcess.get(0)).getProps().get("REPLICA_ID"));
            }
        }
        String replicaId = (String)recoveryPlan.getGlobalSettings().get("REPLICA_ID");
        context.setAttribute("REPLICA_ID", (Object)replicaId);
        if (DrmEnumDefine.RecoveryPlanExecuteTypeE.CLEAN_DRILLING.getValue() != this.getProcType() && !CheckReplicaTools.checkSnapshotCorrect((String)replicaId)) {
            throw new LegoCheckedException(1073948459L);
        }
        ((IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class)).updateRecoveryProcessor((RecoveryProcessor)this);
        this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
        return true;
    }

    private void saveInfoToContextParams(RecoveryProcessorContext context) {
        ProcessorInfoServiceManagerProxy proxy;
        IProcessorInfoService service;
        RecoveryPlan recoveryPlan = context.getRecoveryPlan();
        if (null == recoveryPlan) {
            return;
        }
        ProtectGroup protectGroup = recoveryPlan.getProtectGroup();
        if (null == protectGroup) {
            return;
        }
        PolicyTemplate policyTemplate = protectGroup.getTemplate();
        if (null == policyTemplate) {
            return;
        }
        ProtectGroupReplica replica = context.getProtectGroupReplica();
        int poType = protectGroup.getPoType();
        int ptType = policyTemplate.getType();
        if (11 != poType || 2 != ptType) {
            return;
        }
        RecoveryProcessUtil.removeContextParamByKey(context, "SrcLunIds");
        RecoveryProcessUtil.removeContextParamByKey(context, "SrcLunWWNs");
        Set poList = protectGroup.getPolist();
        ArrayList<String> srcLunIdList = new ArrayList<String>();
        for (Object po : poList) {
            Set storageInfos = po.getUsedStorageResourceSet();
            if (!storageInfos.stream().findFirst().isPresent()) continue;
            ProtectObjectStorageInfo storageInfo = (ProtectObjectStorageInfo)storageInfos.stream().findFirst().get();
            srcLunIdList.add(storageInfo.getResourceId());
            RecoveryProcessUtil.addContextParam(context, "SrcLunIds", storageInfo.getResourceId());
            RecoveryProcessUtil.addContextParam(context, "SrcLunWWNs", storageInfo.getLunWWN());
        }
        if (replica != null && replica.isBackUpReplica()) {
            return;
        }
        if (DrmEnumDefine.RecoveryPlanExecuteTypeE.DRILLING.getValue() == this.getProcType() || DrmEnumDefine.RecoveryPlanExecuteTypeE.CLEAN_DRILLING.getValue() == this.getProcType() || DrmEnumDefine.RecoveryPlanExecuteTypeE.SNAPSHOT_ROLLBACK.getValue() == this.getProcType()) {
            RecoveryProcessUtil.removeContextParamByKey(context, "SnapshotIds");
            RecoveryProcessUtil.removeContextParamByKey(context, "SnapshotWWNs");
            List<Snapshot> snapshotList = this.querySnapshots(context, protectGroup);
            for (String lunId : srcLunIdList) {
                Optional<Snapshot> snapshotOptional = snapshotList.stream().filter(item -> lunId.equalsIgnoreCase(item.getSrcResourceId().toString())).findFirst();
                if (!snapshotOptional.isPresent()) continue;
                RecoveryProcessUtil.addContextParam(context, "SnapshotIds", snapshotOptional.get().getSnapshotId());
                RecoveryProcessUtil.addContextParam(context, "SnapshotWWNs", snapshotOptional.get().getWwn());
            }
        }
        if (null != (service = (proxy = ProcessorInfoServiceManagerProxy.getInstance()).getProcessInfoService(this.getProcType()))) {
            this.initSnapshotCopyIdAndWwnList(context, srcLunIdList, service);
        }
        RecoveryProcessUtil.removeContextParamByKey(context, "SrcProviderSN");
        RecoveryProcessUtil.addContextParam(context, "SrcProviderSN", protectGroup.getPoProviderSN());
    }

    private List<Snapshot> querySnapshots(RecoveryProcessorContext context, ProtectGroup protectGroup) {
        LocalStorageReplica localStorageReplica;
        IRecoveryResourceService recoveryService = (IRecoveryResourceService)ServiceLocator.getInstance().getService(IRecoveryResourceService.class);
        String deviceType = recoveryService.getStorageType(protectGroup.getPoProviderSN());
        StorageSnapshotManagerProxy storageManagerProxy = StorageSnapshotManagerProxy.getInstance();
        IStorageSnapshotManager snpManager = storageManagerProxy.getStorageSnapshotMgrByDevType(deviceType);
        String replicaId = (String)context.getRecoveryPlan().getGlobalSettings().get("REPLICA_ID");
        ArrayList snapshotIdList = new ArrayList();
        ProtectGroupReplica replica = RecoveryProcessUtil.getProtectGroupReplicaByReplicaId(protectGroup, replicaId);
        if (VerifyUtil.isEmpty((Object)replica)) {
            logger.error((Object)"replica is null: pgId=%s, replicaId=%s", new Object[]{protectGroup.getUuid(), replicaId});
            return Collections.emptyList();
        }
        replica.getReplicas().stream().flatMap(e -> e.getStorageInfos().stream()).map(RelicaStorageInfo::getStorageId).distinct().forEach(snapshotIdList::add);
        int protectType = ReplicationConstantDefine.LocalTaskType.SNAPSHOT.getValue();
        String consistentGroupId = null;
        RelicaStorageInfo relicaStorageInfo = (RelicaStorageInfo)((ProtectObjectReplica)replica.getReplicas().stream().findAny().get()).getStorageInfos().stream().findAny().get();
        if (replica.getType() == 4 || replica.getType() == 102) {
            protectType = ReplicationConstantDefine.LocalTaskType.HYPERCDP_GROUP.getValue();
            if (relicaStorageInfo instanceof LocalStorageReplica) {
                localStorageReplica = (LocalStorageReplica)relicaStorageInfo;
                consistentGroupId = localStorageReplica.getConsistentGroupId();
            }
        } else if (replica.getType() == 3 && relicaStorageInfo instanceof LocalStorageReplica) {
            localStorageReplica = (LocalStorageReplica)relicaStorageInfo;
            if (VerifyUtil.isEmpty((String)localStorageReplica.getConsistentGroupId())) {
                protectType = ReplicationConstantDefine.LocalTaskType.SNAPSHOT.getValue();
            } else {
                consistentGroupId = localStorageReplica.getConsistentGroupId();
                protectType = ReplicationConstantDefine.LocalTaskType.SNAPSHOT_GROUP.getValue();
            }
        }
        Snapshot snapshot = new Snapshot();
        ArrayList<Snapshot> snapshotList = new ArrayList<Snapshot>();
        for (String snapshotId : snapshotIdList) {
            snapshot.setSnapshotId(snapshotId);
            snapshot.setSnapshotName(snapshotId);
            if (protectType == ReplicationConstantDefine.LocalTaskType.SNAPSHOT.getValue()) {
                snapshotList.addAll(snpManager.getSnapshot(protectGroup.getPoProviderSN(), snapshot));
                continue;
            }
            if (protectType == ReplicationConstantDefine.LocalTaskType.SNAPSHOT_GROUP.getValue()) {
                IStorageSnapshotManager proxy = StorageSnapshotManagerProxy.getInstance().getStorageSnapshotMgrByDevId(protectGroup.getPoProviderSN());
                snapshotList.addAll(proxy.querySnapshots(protectGroup.getPoProviderSN(), XveMOType.SNAPSHOT_CONSISTENCY_GROUP, consistentGroupId));
                continue;
            }
            if (protectType != ReplicationConstantDefine.LocalTaskType.HYPERCDP_GROUP.getValue()) continue;
            IStorageHyperCDPManager storageHyperCDPManager = StorageHyperCDPManagerProxy.getInstance().getStorageSnapshotMgrByDevId(protectGroup.getPoProviderSN());
            snapshotList.addAll(storageHyperCDPManager.getHyperCDPByCGId(protectGroup.getPoProviderSN(), consistentGroupId));
        }
        return snapshotList;
    }

    private void initSnapshotCopyIdAndWwnList(RecoveryProcessorContext context, List<String> srcLunIdList, IProcessorInfoService service) {
        Map snapshotList = service.querySnapshotCopyInfos(context, this.getProcType());
        for (String lunId : srcLunIdList) {
            for (Map.Entry snapshot : snapshotList.entrySet()) {
                if (!lunId.equals(snapshot.getKey())) continue;
                String[] snpIdAndWWNs = ((String)snapshot.getValue()).split("-");
                RecoveryProcessUtil.addContextParam(context, "SnapshotCopyIds", snpIdAndWWNs[0]);
                RecoveryProcessUtil.addContextParam(context, "SnapshotCopyWWNs", snpIdAndWWNs[1]);
            }
        }
    }

    protected String generateResultKey() {
        throw new LegoUnsupportedOperationException("The operation is not supported.");
    }

    protected String calcProcessName() {
        String processName = null;
        processName = DrmEnumDefine.RecoveryPlanExecuteTypeE.SNAPSHOT_ROLLBACK.getValue() == this.getProcType() || DrmEnumDefine.RecoveryPlanExecuteTypeE.VM_ROLLBACK.getValue() == this.getProcType() ? "ism.drm.recovery.prepare.process.name" : (DrmEnumDefine.RecoveryPlanExecuteTypeE.DRILLING.getValue() == this.getProcType() ? "ism.drm.testing.prepare.process.name" : (DrmEnumDefine.RecoveryPlanExecuteTypeE.MOUNT_REPLICA.getValue() == this.getProcType() ? "ism.drm.mountReplica.prepare.process.name" : (DrmEnumDefine.RecoveryPlanExecuteTypeE.UMOUNT_REPLICA.getValue() == this.getProcType() ? "ism.drm.umountReplica.prepare.process.name" : "ism.drm.clean.prepare.process.name")));
        return processName;
    }

    public void updateDescription() {
        this.setDescription("ism.drm.recovery.prepare.process.des");
    }

    public String getStepPosition() {
        return "Prepare";
    }
}

