/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.recovery.framework.process.airgap;

import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.base.job.airgapjob.AirGapLinkProcessor;
import com.huawei.ism.drm.base.util.AirGapLinkPortUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.constant.PolicyTemplateType;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.storage.sdk.model.EnablePortTask;
import com.huawei.ism.drm.storage.sdk.model.EnablePortTaskList;
import com.huawei.ism.drm.storage.sdk.model.StorageLinkPort;
import com.huawei.ism.drm.storage.sdk.model.hypermetro.SanHyperMetroRingAirGapExecuteInfo;
import com.huawei.lego.core.base.thread.ExecutionService;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.exception.LegoUnsupportedOperationException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.UUIDGenerator;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;

public class EnableStorageMultiReplicationPortProcessor
extends BaseRecoveryProcessor {
    private static final long serialVersionUID = -4222080394297456794L;
    private static final Log LOGGER = LogFactory.getInstance(EnableStorageMultiReplicationPortProcessor.class);

    protected boolean execute(RecoveryProcessorContext context) {
        ProtectGroup pg = context.getProtectGroup();
        if (VerifyUtil.isEmpty((Object)pg)) {
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            this.updateProcessDetail("ism.drm.recovery.protectgroup.not.exist", null);
            return false;
        }
        LOGGER.info((Object)"EnableStorageReplicationPortProcessor begin to execute.");
        if (!PolicyTemplateType.AIR_GAP_NETWORKING.contains(pg.getTemplate().getType())) {
            LOGGER.info((Object)"Not air gap template, skip enable ports, pgName: %s", new Object[]{pg.getName()});
            return true;
        }
        Map portsMap = AirGapLinkPortUtil.getHyperMetroAirGapPortsMap((ProtectGroup)pg);
        Optional<List> anyListNotEmpty = portsMap.values().stream().filter(list -> !VerifyUtil.isEmpty((Collection)list)).findAny();
        if (!anyListNotEmpty.isPresent()) {
            LOGGER.error((Object)"Error: not find pg ports. PgName: %s.", new Object[]{pg.getName()});
            throw new LegoCheckedException(201L);
        }
        SanHyperMetroRingAirGapExecuteInfo recoveryInfo = this.getExecuteInfo(pg);
        HashSet<String> failedPortNames = new HashSet<String>();
        long startTime = System.currentTimeMillis();
        LOGGER.info((Object)"Start open port at: %s.", new Object[]{String.valueOf(startTime)});
        if (!this.checkAndEnablePorts(context, portsMap, pg, failedPortNames, recoveryInfo)) {
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            String name = AirGapLinkPortUtil.getPortNames(failedPortNames);
            String[] failedNames = new String[]{name};
            this.updateProcessDetail("ism.drm.recovery.airgap.enable.port.error", failedNames);
            AirGapLinkPortUtil portUtil = AirGapLinkPortUtil.getInstance();
            Optional opt = context.getProtectPortTask();
            opt.ifPresent(task -> portUtil.consumeFailedAirGapTask(task, DrmEnumDefine.ExecTypeEnum.MANUAL.getType()));
            return false;
        }
        AirGapLinkPortUtil.runAirGapSyncRateAtOnce((ProtectGroup)pg);
        String name = AirGapLinkPortUtil.getPortNames(this.checkAndGetEnablePortNames(portsMap, failedPortNames));
        String[] successNames = new String[]{name};
        long endTime = System.currentTimeMillis();
        if (endTime - startTime <= 30000L) {
            this.updateProcessDetail("ism.drm.recovery.airgap.enable.port.already", successNames);
        } else {
            this.updateProcessDetail("ism.drm.recovery.airgap.enable.port.success", successNames);
        }
        this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
        context.setAttribute("SAN_HYPER_METRO_RING_RECOVERY_INFO", (Object)recoveryInfo);
        return true;
    }

    private SanHyperMetroRingAirGapExecuteInfo getExecuteInfo(ProtectGroup pg) {
        List replicas = pg.listAllReplicatonRepica();
        Map<String, List<ProtectGroupReplica>> map = replicas.stream().collect(Collectors.groupingBy(ProtectGroupReplica::getProductArray));
        if (map.size() != 2) {
            LOGGER.error((Object)"Error: 3DC hyperMetro AirGap must have 2 chains, chain nums: %s, pg name: %s.", new Object[]{map.size(), pg.getName()});
            throw new LegoCheckedException(1677929520L);
        }
        Iterator<String> devSnIter = map.keySet().iterator();
        return new SanHyperMetroRingAirGapExecuteInfo(devSnIter.next(), devSnIter.next(), pg.getPoProviderSN());
    }

    private Set<String> checkAndGetEnablePortNames(Map<String, List<StorageLinkPort>> portsMap, Set<String> failedPortNames) {
        HashSet<String> enabledPortNames = new HashSet<String>();
        for (List<StorageLinkPort> linkPorts : portsMap.values()) {
            linkPorts.forEach(linkPort -> {
                if (CollectionUtils.isEmpty((Collection)failedPortNames) || !failedPortNames.contains(linkPort.getPortName())) {
                    enabledPortNames.add(linkPort.getPortName());
                }
            });
        }
        return enabledPortNames;
    }

    private boolean checkAndEnablePorts(RecoveryProcessorContext context, Map<String, List<StorageLinkPort>> portsMap, ProtectGroup pg, Set<String> failedPortNames, SanHyperMetroRingAirGapExecuteInfo recoveryInfo) {
        Iterator<Map.Entry<String, List<StorageLinkPort>>> iterator = portsMap.entrySet().iterator();
        EnablePortTaskList portTasks = new EnablePortTaskList();
        ArrayList<Callable<Map<String, Boolean>>> callables = new ArrayList<Callable<Map<String, Boolean>>>();
        while (iterator.hasNext()) {
            String taskId;
            List<String> portIds;
            Map.Entry<String, List<StorageLinkPort>> entry = iterator.next();
            List<StorageLinkPort> linkPorts = entry.getValue();
            List<StorageLinkPort> waitCheckPorts = this.getStorageLinkPorts(context, linkPorts, pg, portIds = this.getAndCheckPortIds(linkPorts, pg), taskId = UUIDGenerator.getUUID());
            if (CollectionUtils.isEmpty(waitCheckPorts)) {
                recoveryInfo.setPortOpenStatus(entry.getKey(), Boolean.valueOf(false));
                continue;
            }
            EnablePortTask task = this.buildEnablePorTask(pg, taskId, waitCheckPorts, entry.getKey());
            portTasks.addEnablePortTask(task);
            context.setAttribute("Recovery_PortTaskInfo", (Object)portTasks);
            AirGapLinkProcessor.getInstance().addEnablePortsToProcessor(task);
            HashSet<StorageLinkPort> waitPortsSet = new HashSet<StorageLinkPort>(waitCheckPorts);
            callables.add(this.getOpenPortResultTask(entry.getKey(), waitPortsSet, failedPortNames));
        }
        List result = ExecutionService.batchSubmit(callables, (ExecutionService.ExecuteType)ExecutionService.ExecuteType.FAILED_CONTINUE, (int)1000, (int)2);
        Map<String, Boolean> merged = result.stream().map(Map::entrySet).flatMap(Collection::stream).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        Iterator<Map.Entry<String, List<StorageLinkPort>>> iter = portsMap.entrySet().iterator();
        while (iter.hasNext()) {
            String devSn = iter.next().getKey();
            recoveryInfo.setPortOpenStatus(devSn, merged.get(devSn));
        }
        return recoveryInfo.isSiteAPortOpenSuccess() || recoveryInfo.isSiteBPortOpenSuccess();
    }

    private List<String> getAndCheckPortIds(List<StorageLinkPort> linkPorts, ProtectGroup pg) {
        List<String> portIds = linkPorts.stream().map(StorageLinkPort::getPortId).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(portIds)) {
            LOGGER.error((Object)"Error: not find pg portIds. PgName: %s.", new Object[]{pg.getName()});
            throw new LegoCheckedException(201L);
        }
        return portIds;
    }

    private List<StorageLinkPort> getStorageLinkPorts(RecoveryProcessorContext context, List<StorageLinkPort> linkPorts, ProtectGroup pg, List<String> portIds, String taskId) {
        ArrayList<StorageLinkPort> waitCheckPorts = new ArrayList<StorageLinkPort>();
        for (StorageLinkPort linkPort : linkPorts) {
            StorageLinkPort portInDb = this.getPortInDb(linkPort);
            if (VerifyUtil.isEmpty((Object)portInDb)) {
                LOGGER.error((Object)"Not get port in db by id: %s. please check.", new Object[]{linkPort.getPortId()});
                throw new LegoCheckedException(201L);
            }
            portInDb.setExecTypeEnum(DrmEnumDefine.ExecTypeEnum.MANUAL);
            portInDb.setScheduleModeType(DrmEnumDefine.ExecTypeEnum.MANUAL);
            portInDb.setTaskId(taskId);
            portInDb.setOperator(pg.getName());
            portInDb.setPgWorkPorts(portIds);
            portInDb.setOperateType(2);
            CommonDAOLocator.getBaseDao().getHibernateTemplate().saveOrUpdate((Object)portInDb);
            LOGGER.info((Object)"Need to enable portName: %s.", new Object[]{portInDb.getPortName()});
            waitCheckPorts.add(portInDb);
        }
        return waitCheckPorts;
    }

    private EnablePortTask buildEnablePorTask(ProtectGroup pg, String taskId, List<StorageLinkPort> waitCheckPorts, String remoteDevSn) {
        EnablePortTask task = new EnablePortTask();
        task.setPortList(waitCheckPorts);
        task.setDevSn(waitCheckPorts.get(0).getDevSn());
        task.setTaskId(taskId);
        task.setRemoteDevSn(remoteDevSn);
        task.setProtectGroup(pg);
        return task;
    }

    private StorageLinkPort getPortInDb(StorageLinkPort linkPort) {
        return (StorageLinkPort)CommonDAOLocator.getBaseDao().getHibernateTemplate().get(StorageLinkPort.class, (Serializable)((Object)linkPort.getPortId()));
    }

    private Callable<Map<String, Boolean>> getOpenPortResultTask(final String devSn, final Set<StorageLinkPort> waitPortsSet, final Set<String> failedPortNames) {
        return new Callable(){

            public Map<String, Boolean> call() {
                HashMap<String, Boolean> map = new HashMap<String, Boolean>();
                map.put(devSn, AirGapLinkPortUtil.getInstance().isHasPortEnable(waitPortsSet, failedPortNames));
                return map;
            }
        };
    }

    public String getName() {
        return ((Object)((Object)this)).getClass().getName();
    }

    protected String generateResultKey() {
        throw new LegoUnsupportedOperationException("The operation is not supported.");
    }

    public void updateDescription() {
        this.setDescription("com.huawei.ism.drm.recovery.framework.process.airgap.EnableStorageReplicationPortProcessor.des");
    }

    public String getStepPosition() {
        return "Enable the replication network port of the storage device.";
    }
}

