/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.recovery.framework.task;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessDefinition;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryPlanService;
import com.huawei.ism.drm.drp.util.RecoveryServiceUtil;
import com.huawei.ism.drm.recovery.framework.provider.RefactorConfigurationProviderMgr;
import com.huawei.ism.drm.recovery.process.IRecoveryProcessProvider;
import com.huawei.ism.drm.recovery.process.IRefactorConfigurationBaseProvider;
import com.huawei.ism.drm.recovery.process.IRefactorConfigurationProvider;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.recovery.task.ICallBackExcuteRecoveryTask;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.Collection;
import java.util.Set;

public class ReprotectCallBackExcuteRecoveryTask
implements ICallBackExcuteRecoveryTask {
    private static Log logger = LogFactory.getInstance(ReprotectCallBackExcuteRecoveryTask.class);

    public void afterExecuteRecoveryPlan(RecoveryProcessorContext context, RecoveryPlan recoveryPlan) {
        DrmEnumDefine.AppType appType;
        String isReversedInGlobalSetting = (String)context.getAttribute("isReserved");
        if ("true".equalsIgnoreCase(isReversedInGlobalSetting)) {
            logger.debug((Object)"the isReserved is true");
            return;
        }
        RefactorConfigurationProviderMgr refactorCfgProviderMgr = RefactorConfigurationProviderMgr.getInstance();
        IRefactorConfigurationBaseProvider refacotryprovider = refactorCfgProviderMgr.getRefactorConfigurationProvider((appType = RecoveryServiceUtil.getAppType((RecoveryPlan)recoveryPlan)).name());
        if (null == refacotryprovider) {
            logger.error((Object)("refacotryprovider is null: " + recoveryPlan.getPlanId()), 90160758784001L);
            return;
        }
        String extAttributes = (String)recoveryPlan.getGlobalSettings().get("RECOVERY_EXTEND_ATTRIBUTES");
        if (!String.valueOf(DrmEnumDefine.RecoveryExtendAttributes.REFACTOR_CONFIGURATION_SUCCESS.getValue()).equals(extAttributes)) {
            logger.info((Object)("refactor recoveryplan not success: " + recoveryPlan.getPlanId()));
            return;
        }
        IRecoveryPlanService planService = (IRecoveryPlanService)ServiceLocator.getInstance().getService(IRecoveryPlanService.class);
        RecoveryPlan planWithProcess = planService.getRecoveryPlan(recoveryPlan.getPlanId(), true, false);
        if (null == planWithProcess) {
            logger.error((Object)("The recovery plan does not exist. Name:" + recoveryPlan.getPlanId()), 90160758784001L);
            return;
        }
        Set definitions = planWithProcess.getRecoveryProcesses();
        if (VerifyUtil.isEmpty((Collection)definitions)) {
            return;
        }
        IRecoveryProcessProvider provider = (IRecoveryProcessProvider)RecoveryServiceUtil.getRecoveryProcessProvider((RecoveryPlan)recoveryPlan);
        if (null == provider) {
            logger.error((Object)("provicer is null: " + recoveryPlan.getPlanId()), 90160758784001L);
            return;
        }
        Class customProcessorCls = provider.getCustomRecoveryProcessorClass();
        for (RecoveryProcessDefinition definition : definitions) {
            ((IRefactorConfigurationProvider)refacotryprovider).deleteCustomRecoveryProcessors(definition, customProcessorCls, provider);
        }
    }

    public void beforeExecuteRecoveryPlan(RecoveryProcessorContext context, RecoveryPlan recoveryPlan) {
        String executeFlag = (String)recoveryPlan.getGlobalSettings().get("EXEC_LOCAL_SCRIPT_WHEN_LUN");
        if ("true".equals(executeFlag)) {
            context.setAttribute("EXEC_LOCAL_SCRIPT_WHEN_LUN", (Object)"true");
        }
    }
}

