/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.resource.jms;

import com.huawei.ism.array.sdk.model.StorageArray;
import com.huawei.ism.base.sdk.model.NetworkEntity;
import com.huawei.ism.base.sdk.model.StorageNE;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.mediation.jms.IMessageReceiverExtender;
import com.huawei.ism.drm.base.util.DBOperationUtil;
import com.huawei.ism.drm.site.resource.sdk.service.IResourceService;
import com.huawei.ism.drm.site.sdk.model.DrResource;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import org.hibernate.Session;
import org.hibernate.query.NativeQuery;
import org.springframework.dao.DataAccessException;

public class ResourceMessageReceiverExtender
implements IMessageReceiverExtender {
    private static final Log logger = LogFactory.getInstance(ResourceMessageReceiverExtender.class);

    public void postProcess(NetworkEntity ne) {
        if (null == ne || !(ne instanceof StorageNE)) {
            return;
        }
        this.deleteDrResource(ne);
        if (ne instanceof StorageArray) {
            this.deleteResourcePools(ne.getSn());
        }
    }

    private void deleteDrResource(NetworkEntity ne) {
        String sn = ne.getSn();
        logger.info((Object)("Enter delete DrResource, sn=" + sn), 90160758786816L);
        DrResource drResource = ((IResourceService)ServiceLocator.getInstance().getService(IResourceService.class)).getDrResourceBySn(sn);
        if (null == drResource) {
            logger.info((Object)"Exit delete DrResource", 90160758786816L);
            return;
        }
        this.deleteFromDb(drResource);
        logger.info((Object)"Exit delete DrResource", 90160758786816L);
    }

    private void deleteFromDb(DrResource resource) {
        try {
            CommonDAOLocator.getBaseDao().getHibernateTemplate().delete((Object)resource);
        }
        catch (DataAccessException e) {
            logger.error((Object)("fail to delete, site=" + resource.getSiteId() + ", resSn=" + resource.getDeviceSn()), (Throwable)e, 90160758786816L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteResourcePools(String deviceSn) {
        Session session = null;
        try {
            String deletePoolSQL = "delete from ti_storageresourcepool where resourceprovider=:deviceSn";
            String deletePoolResourceSQL = "delete from ti_storagepoolresource where exists (select a.* from ti_storagepoolresource a , ti_storageresourcepool b where a.pooluuid=b.pooluuid and b.resourceprovider=:deviceSn)";
            session = CommonDAOLocator.getBaseDao().getHibernateTemplate().getSessionFactory().openSession();
            session.beginTransaction();
            NativeQuery delPoolResQuery = session.createSQLQuery(deletePoolResourceSQL);
            delPoolResQuery.setString("deviceSn", deviceSn);
            NativeQuery delPoolQuery = session.createSQLQuery(deletePoolSQL);
            delPoolQuery.setString("deviceSn", deviceSn);
            delPoolResQuery.executeUpdate();
            delPoolQuery.executeUpdate();
            session.getTransaction().commit();
        }
        catch (Exception e) {
            try {
                DBOperationUtil.rollbackSession(session);
                logger.error((Object)("Deleting resource pools failed.DevSn:" + deviceSn + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784001L);
            }
            catch (Throwable throwable) {
                DBOperationUtil.closeSession(session);
                throw throwable;
            }
            DBOperationUtil.closeSession((Session)session);
        }
        DBOperationUtil.closeSession((Session)session);
    }
}

