/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.site.util;

import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.drm.base.util.DBOperationUtil;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import org.hibernate.Session;
import org.springframework.dao.DataAccessException;

public class CommonDAO {
    private static final Log LOGGER = LogFactory.getInstance(CommonDAO.class);
    private Runner runner;

    private CommonDAO() {
    }

    public static CommonDAO getInstance() {
        return SingletonHolder.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Runner runner, boolean isTransaction) {
        this.runner = runner;
        Session session = CommonDAOLocator.getBaseDao().getHibernateTemplate().getSessionFactory().openSession();
        try {
            if (isTransaction) {
                session.beginTransaction();
            }
            if (this.runner != null) {
                this.runner.run(session);
            }
            if (isTransaction) {
                session.getTransaction().commit();
            }
        }
        catch (DataAccessException e) {
            if (this.runner != null) {
                this.runner.error(e);
            }
            DBOperationUtil.rollbackSession((Session)session);
            LOGGER.error((Object)"Execute database error. %s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
        }
        finally {
            DBOperationUtil.closeSession((Session)session);
        }
    }

    private static class SingletonHolder {
        static final CommonDAO INSTANCE = new CommonDAO();

        private SingletonHolder() {
        }
    }

    public static interface Runner {
        public void run(Session var1);

        public void error(DataAccessException var1);
    }
}

