/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.service.impl;

import com.huawei.ism.array.sdk.model.Controller;
import com.huawei.ism.array.sdk.model.Lun;
import com.huawei.ism.array.sdk.model.XveLun;
import com.huawei.ism.base.sdk.model.StoragePool;
import com.huawei.ism.base.sdk.model.StorageResource;
import com.huawei.ism.cbb.base.sdk.bo.Page;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.proxy.xve.XveMOType;
import com.huawei.ism.cbb.proxy.xve.XveUUID;
import com.huawei.ism.cbb.util.StringUtil;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.base.service.IsmDrmBaseService;
import com.huawei.ism.drm.base.util.DBOperationUtil;
import com.huawei.ism.drm.base.util.ResourceUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.constant.coreenum.StorageEnumDefine;
import com.huawei.ism.drm.drp.synchronize.UpdateStoragePoolResourceJob;
import com.huawei.ism.drm.storage.sdk.model.StoragePoolResource;
import com.huawei.ism.drm.storage.sdk.model.StorageResourcePool;
import com.huawei.ism.drm.storage.sdk.service.IStorageResourcePoolService;
import com.huawei.ism.drm.storage.sdk.service.IStorageResourceService;
import com.huawei.lego.core.sdk.base.annotation.Service;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.UUIDGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.hibernate.Session;
import org.hibernate.query.NativeQuery;
import org.hibernate.query.Query;
import org.quartz.JobDetail;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.impl.JobDetailImpl;
import org.quartz.impl.StdSchedulerFactory;
import org.quartz.impl.triggers.SimpleTriggerImpl;

@Service(name="com.huawei.ism.drm.storage.sdk.service.IStorageResourcePoolService", desc="", interfaceClass=IStorageResourcePoolService.class)
public class StorageResourcePoolServiceImpl
extends IsmDrmBaseService
implements IStorageResourcePoolService {
    private static Log logger = LogFactory.getInstance(StorageResourcePoolServiceImpl.class);
    private static final String QUERY_USED_RESOURCE_SQL = "select b.* from t_managedobject b, ti_storageresource c,ti_lun c1, ti_hyperclonepair d where b.moid=c.moid and c.moid=c1.moid and c1.wwn=a.resourceuuid and c.devsn=d.devicesn and c.resourceid=d.tgtlunid";
    private static final int MAX_POOL_RESOURCE_COUNT = 512;
    private Scheduler quartzScheduler;
    private String storageResPoolSchedulerName = "StorageResourcePoolScheduler";

    public void initialize() {
        this.createCascadeDelPoolResourceTrigger();
        this.startQuartzScheduler();
        this.startUpdateStoragePoolResourceJob();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<StorageResourcePool> getStorageResourcePools(String deviceSn, StorageEnumDefine.ResourcePoolEnum type) {
        Session session;
        ArrayList<StorageResourcePool> resourcePools;
        block6: {
            if (VerifyUtil.isEmpty((String)deviceSn) || null == type) {
                throw new LegoCheckedException(1073947393L);
            }
            resourcePools = new ArrayList<StorageResourcePool>();
            session = null;
            try {
                session = this.getMoDao().getHibernateTemplate().getSessionFactory().openSession();
                String queryHQL = "from StorageResourcePool a where a.type=:type and a.resourceProvider like :deviceSn";
                Query query = session.createQuery(queryHQL);
                query.setInteger("type", type.getValue());
                query.setString("deviceSn", "%" + deviceSn + "%");
                List results = query.list();
                if (VerifyUtil.isEmpty((Collection)results)) break block6;
                for (Object object : results) {
                    resourcePools.add((StorageResourcePool)object);
                }
            }
            catch (Exception e) {
                try {
                    logger.error((Object)("Getting storage resource pool failed." + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784001L);
                }
                catch (Throwable throwable) {
                    DBOperationUtil.closeSession(session);
                    throw throwable;
                }
                DBOperationUtil.closeSession((Session)session);
            }
        }
        DBOperationUtil.closeSession((Session)session);
        return resourcePools;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StorageResourcePool getStorageReosurcePool(String uuid) {
        Session session;
        block4: {
            StorageResourcePool storageResourcePool;
            session = null;
            try {
                session = CommonDAOLocator.getMoDao().getHibernateTemplate().getSessionFactory().openSession();
                String queryHQL = "from StorageResourcePool a where a.uuid=:uuid";
                Query query = session.createQuery(queryHQL);
                query.setString("uuid", uuid);
                List results = query.list();
                if (VerifyUtil.isEmpty((Collection)results)) break block4;
                storageResourcePool = (StorageResourcePool)results.get(0);
            }
            catch (Exception e) {
                try {
                    logger.error((Object)("Getting storage resource pool failed." + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784001L);
                }
                catch (Throwable throwable) {
                    DBOperationUtil.closeSession(session);
                    throw throwable;
                }
                DBOperationUtil.closeSession((Session)session);
            }
            DBOperationUtil.closeSession((Session)session);
            return storageResourcePool;
        }
        DBOperationUtil.closeSession((Session)session);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Page storageResources(String uuid, String orderBy, String orderType, int pageSize, int startPage, DrmEnumDefine.ResourceTypeE resourceType) {
        Session session;
        List<Object> resources;
        block4: {
            resources = new ArrayList();
            session = null;
            try {
                String queryHQL = "select a from Lun a, StoragePoolResource b, StorageResourcePool c, StorageResource d where b.poolUuid =:poolUuid and b.poolUuid=c.uuid and a.wwn=b.resourceUuid and a.moId=d.moId and d.devSn=c.resourceProvider";
                session = CommonDAOLocator.getMoDao().getHibernateTemplate().getSessionFactory().openSession();
                Query query = session.createQuery(queryHQL);
                query.setString("poolUuid", uuid);
                List results = query.list();
                if (VerifyUtil.isEmpty((Collection)results)) break block4;
                resources = this.constructStoragePoolResources(uuid, results);
            }
            catch (Exception e) {
                try {
                    logger.error((Object)("getAvailableStorageResources failed. uuid:" + uuid + ",type:" + resourceType + ",orderBy:" + orderBy + ",orderType:" + orderType + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784001L);
                }
                catch (Throwable throwable) {
                    DBOperationUtil.closeSession(session);
                    throw throwable;
                }
                DBOperationUtil.closeSession((Session)session);
            }
        }
        DBOperationUtil.closeSession((Session)session);
        Page page = Page.createPage((int)startPage, (int)pageSize, resources);
        return page;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void createStorageResourcePool(String name, String description, StorageEnumDefine.ResourcePoolEnum type, List<String> resourceList) {
        if (VerifyUtil.isEmpty((String)name) || null == type) {
            throw new LegoCheckedException(1073947393L);
        }
        IStorageResourceService resourceService = (IStorageResourceService)ServiceLocator.getInstance().getService(IStorageResourceService.class);
        List storageResources = resourceService.getStorageResourcesByUuid(resourceList, StorageResource.class);
        if (VerifyUtil.isEmpty((Collection)storageResources)) {
            throw new LegoCheckedException(1073948219L);
        }
        StorageResourcePool resourcePool = this.constructStorageResourcePool(name, description, type, storageResources);
        if (this.isExistedStorageResourcePoolByName(name)) {
            throw new LegoCheckedException(1073947392L);
        }
        if (512 < storageResources.size()) {
            throw new LegoCheckedException(1073948229L);
        }
        Session session = null;
        try {
            String createSQL = "insert into ti_storagepoolresource(resourceuuid, resourceid, isused,pooluuid) select ?,?,?,? from dual where exists (select * from t_managedobject a, ti_storageresource b where a.moId=b.moId and b.healthStatus=? and b.runningStatus=?)";
            session = CommonDAOLocator.getMoDao().getHibernateTemplate().getSessionFactory().openSession();
            session.beginTransaction();
            session.save((Object)resourcePool);
            for (StorageResource storageResource : storageResources) {
                Lun lun = (Lun)storageResource;
                NativeQuery query = session.createSQLQuery(createSQL);
                query.setString(0, lun.getWwn());
                query.setString(1, storageResource.getResourceId());
                query.setBoolean(2, false);
                query.setString(3, resourcePool.getUuid());
                query.setString(4, "0");
                query.setString(5, "0");
                int result = query.executeUpdate();
                if (0 != result) continue;
                logger.error((Object)("Adding resource failed. Id:" + storageResource.getResourceId() + ",DevSn:" + storageResource.getDevSn()), 90160758784001L);
                throw new LegoCheckedException(1073948221L);
            }
            session.getTransaction().commit();
        }
        catch (LegoCheckedException e) {
            DBOperationUtil.rollbackSession(session);
            ExceptionUtil.rethrowException((Throwable)e, (String)"Creating storage res pool failed.", (long)e.getErrorCode(), (String[])e.getParameters(), (Log)logger);
            DBOperationUtil.closeSession((Session)session);
        }
        catch (Exception e2) {
            DBOperationUtil.rollbackSession(session);
            ExceptionUtil.rethrowException((Throwable)e2, (String)"Creating storage res pool failed.", (long)1073948221L, (String[])new String[0], (Log)logger);
            {
                catch (Throwable throwable) {
                    DBOperationUtil.closeSession(session);
                    throw throwable;
                }
            }
            DBOperationUtil.closeSession((Session)session);
        }
        DBOperationUtil.closeSession((Session)session);
    }

    /*
     * Exception decompiling
     */
    public void deleteStorageResourcePool(String uuid) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[CATCHBLOCK]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void modifyStorageResourcePool(String uuid, String name, String description) {
        StorageResourcePool resourcePool = this.getStorageReosurcePool(uuid);
        if (null == resourcePool) {
            throw new LegoCheckedException(201L);
        }
        if (this.isExistedStorageResourcePoolByName(uuid, name)) {
            throw new LegoCheckedException(1073947392L);
        }
        Session session = null;
        try {
            session = CommonDAOLocator.getMoDao().getHibernateTemplate().getSessionFactory().openSession();
            resourcePool.setName(name);
            resourcePool.setDescription(description);
            session.beginTransaction();
            session.update((Object)resourcePool);
            session.getTransaction().commit();
        }
        catch (Exception e) {
            try {
                DBOperationUtil.rollbackSession((Session)session);
                ExceptionUtil.rethrowException((Throwable)e, (String)"Modifying storage resource pool failed.", (long)-1L, (String[])new String[0], (Log)logger);
            }
            catch (Throwable throwable) {
                DBOperationUtil.closeSession(session);
                throw throwable;
            }
            DBOperationUtil.closeSession((Session)session);
        }
        DBOperationUtil.closeSession((Session)session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void addResources(String uuid, String[] resourceList) {
        if (VerifyUtil.isEmpty((String)uuid)) throw new LegoCheckedException(1073947393L);
        if (VerifyUtil.isEmpty((Object[])resourceList)) {
            throw new LegoCheckedException(1073947393L);
        }
        StorageResourcePool resourcePool = this.getStorageReosurcePool(uuid);
        if (null == resourcePool) {
            throw new LegoCheckedException(1073947394L);
        }
        if (this.isExceedMaxResourceCount(uuid, resourceList.length)) {
            throw new LegoCheckedException(1073948229L);
        }
        Session session = null;
        try {
            StringBuilder createSQL = new StringBuilder();
            createSQL.append("insert into ti_storagepoolresource(resourceuuid, resourceid, isused,pooluuid)");
            createSQL.append(" select d1.wwn, d.resourceid,?,? from dual, t_managedobject c, ti_storageresource d, ");
            createSQL.append("ti_lun d1 where c.moid=d.moid and d.moid=d1.moid and c.uuid=? and d.healthStatus=? ");
            createSQL.append("and d.runningStatus=? and not exists (select b.* from ti_storagepoolresource a, ");
            createSQL.append("t_managedobject b, ti_storageresource c, ti_hyperclonepair d ");
            createSQL.append("where a.resourceuuid=b.uuid ");
            createSQL.append("and b.moid=c.moid and b.uuid=? and c.devsn=d.devicesn and c.resourceid=d.tgtlunid)");
            session = CommonDAOLocator.getMoDao().getHibernateTemplate().getSessionFactory().openSession();
            session.beginTransaction();
            for (String resourceUuid : resourceList) {
                NativeQuery insert = session.createSQLQuery(createSQL.toString());
                insert.setBoolean(0, false);
                insert.setString(1, uuid);
                insert.setString(2, resourceUuid);
                insert.setString(3, "0");
                insert.setString(4, "0");
                insert.setString(5, resourceUuid);
                int result = insert.executeUpdate();
                if (0 != result) continue;
                logger.error((Object)("Adding resource failed. Uuid:" + resourceUuid), 90160758784001L);
                throw new LegoCheckedException(1073948225L);
            }
            this.updateResourceProviderOfPool(resourcePool, resourceList, session);
            session.getTransaction().commit();
            DBOperationUtil.closeSession((Session)session);
            return;
        }
        catch (LegoCheckedException e) {
            DBOperationUtil.rollbackSession(session);
            logger.error((Object)"Adding storage pool resource failed.", (Throwable)e, 90160758784001L);
            throw e;
            catch (Exception e2) {
                DBOperationUtil.rollbackSession(session);
                ExceptionUtil.rethrowException((Throwable)e2, (String)"Adding storage pool resource failed.", (long)1073948225L, (String[])new String[0], (Log)logger);
                return;
            }
        }
        finally {
            DBOperationUtil.closeSession(session);
        }
    }

    /*
     * Exception decompiling
     */
    public void removeResources(String uuid, String[] resourceList) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[CATCHBLOCK]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<StorageResource> getAvailableStorageResources(String deviceSn, DrmEnumDefine.ResourceTypeE resourceType) {
        Session session;
        ArrayList<StorageResource> resources;
        block5: {
            resources = new ArrayList<StorageResource>();
            session = null;
            try {
                String queryResourceHQL = "select a from Lun a where a.devSn=:deviceSn and a.healthStatus=:healthStatus and a.runningStatus=:runningStatus";
                session = CommonDAOLocator.getMoDao().getHibernateTemplate().getSessionFactory().openSession();
                Query query = session.createQuery(queryResourceHQL);
                query.setString("deviceSn", deviceSn);
                query.setString("runningStatus", "0");
                query.setString("healthStatus", "0");
                List storageResources = query.list();
                if (VerifyUtil.isEmpty((Collection)storageResources)) break block5;
                Set<String> poolResourceUuids = this.getPoolResourceUuidsByPool(null, session);
                Map<String, String> poolIdAndNameMap = this.getStoragePoolNames();
                Map<String, String> controllerLocations = this.getControllerLocations();
                for (Object object : storageResources) {
                    Lun resource = (Lun)object;
                    if (poolResourceUuids.contains(resource.getWwn())) continue;
                    resources.add((StorageResource)resource);
                    this.fillControllerNameOfLun((StorageResource)resource, controllerLocations);
                    if (!(resource instanceof XveLun)) continue;
                    XveLun xveLun = (XveLun)resource;
                    XveUUID poolUuid = new XveUUID(xveLun.getDevSn(), XveMOType.STORAGEPOOL, xveLun.getStoragePoolId());
                    xveLun.setStoragePoolName(poolIdAndNameMap.get(poolUuid.toString()));
                }
            }
            catch (Exception e) {
                try {
                    logger.error((Object)("getAvailableStorageResources failed. devSn:" + deviceSn + ",type:" + resourceType + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784001L);
                }
                catch (Throwable throwable) {
                    DBOperationUtil.closeSession(session);
                    throw throwable;
                }
                DBOperationUtil.closeSession((Session)session);
            }
        }
        DBOperationUtil.closeSession((Session)session);
        return resources;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<StorageResource> getMatchedStorageResources(String deviceSn, DrmEnumDefine.ResourceTypeE resourceType) {
        List<StorageResource> storageResources = this.getAvailableStorageResources(deviceSn, resourceType);
        if (VerifyUtil.isEmpty(storageResources)) {
            return new ArrayList<StorageResource>();
        }
        ArrayList<StorageResource> matchedResources = new ArrayList<StorageResource>();
        Session session = null;
        try {
            session = this.getMoDao().getHibernateTemplate().getSessionFactory().openSession();
            Set<String> usedResourceUuids = this.getAllUsedStorageResourcesByDevSn(deviceSn, session);
            for (StorageResource resource : storageResources) {
                if (!(resource instanceof Lun) || usedResourceUuids.contains(((Lun)resource).getWwn())) continue;
                matchedResources.add(resource);
            }
        }
        catch (Exception e) {
            try {
                logger.error((Object)("getMatchedStorageResources failed. devSn:" + deviceSn + ",type:" + resourceType + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784001L);
            }
            catch (Throwable throwable) {
                DBOperationUtil.closeSession(session);
                throw throwable;
            }
            DBOperationUtil.closeSession((Session)session);
        }
        DBOperationUtil.closeSession((Session)session);
        return matchedResources;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<StoragePoolResource> getUnusedStorageResources(String uuid, DrmEnumDefine.ResourceTypeE resourceType) {
        Session session;
        ArrayList<StoragePoolResource> resources;
        block5: {
            resources = new ArrayList<StoragePoolResource>();
            session = null;
            try {
                String queryHQL = "select a from Lun a, StoragePoolResource b, StorageResourcePool c, StorageResource d where b.poolUuid =:poolUuid and b.poolUuid=c.uuid and a.wwn=b.resourceUuid and a.moId=d.moId and d.devSn=c.resourceProvider";
                session = this.getMoDao().getHibernateTemplate().getSessionFactory().openSession();
                Query query = session.createQuery(queryHQL);
                query.setString("poolUuid", uuid);
                List results = query.list();
                if (VerifyUtil.isEmpty((Collection)results)) break block5;
                Set<String> allUsedResourceWwns = this.getAllUsedStorageResourcesByPool(uuid, session);
                Map<String, String> controllerLocations = this.getControllerLocations();
                for (Object object : results) {
                    Lun storageResource = (Lun)object;
                    if (allUsedResourceWwns.contains(storageResource.getWwn())) continue;
                    this.fillControllerNameOfLun((StorageResource)storageResource, controllerLocations);
                    StoragePoolResource poolResource = new StoragePoolResource();
                    poolResource.setIsUsed(Boolean.valueOf(false));
                    poolResource.setPoolUuid(uuid);
                    poolResource.setResourceId(storageResource.getResourceId());
                    poolResource.setResourceUuid(storageResource.getWwn());
                    poolResource.setStorageResource((StorageResource)storageResource);
                    resources.add(poolResource);
                }
            }
            catch (Exception e) {
                try {
                    logger.error((Object)("getAvailableStorageResources failed. uuid:" + uuid + ",type:" + resourceType + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784001L);
                }
                catch (Throwable throwable) {
                    DBOperationUtil.closeSession(session);
                    throw throwable;
                }
                DBOperationUtil.closeSession((Session)session);
            }
        }
        DBOperationUtil.closeSession((Session)session);
        return resources;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateStoragePoolResources(List<StoragePoolResource> storagePoolResources) {
        Session session = null;
        try {
            String updateHQL = "update ti_storagepoolresource set ISUSED=:isUsed where RESOURCEUUID=:resourceUuid";
            session = CommonDAOLocator.getMoDao().getHibernateTemplate().getSessionFactory().openSession();
            session.beginTransaction();
            for (StoragePoolResource poolResource : storagePoolResources) {
                NativeQuery query = session.createSQLQuery(updateHQL);
                query.setBoolean("isUsed", poolResource.getIsUsed().booleanValue());
                query.setString("resourceUuid", poolResource.getResourceUuid());
            }
            session.getTransaction().commit();
        }
        catch (Exception e) {
            try {
                DBOperationUtil.rollbackSession(session);
                ExceptionUtil.rethrowException((Throwable)e, (String)"updateStoragePoolResources failed.", (long)-1L, (String[])new String[0], (Log)logger);
            }
            catch (Throwable throwable) {
                DBOperationUtil.closeSession(session);
                throw throwable;
            }
            DBOperationUtil.closeSession((Session)session);
        }
        DBOperationUtil.closeSession((Session)session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateStoragePoolResources() {
        Session session = null;
        try {
            StringBuilder updateSQL1 = new StringBuilder();
            updateSQL1.append("update ti_storagepoolresource a set a.isused='t' where exists (");
            updateSQL1.append(QUERY_USED_RESOURCE_SQL);
            updateSQL1.append(")");
            StringBuilder updateSQL2 = new StringBuilder();
            updateSQL2.append("update ti_storagepoolresource a set a.isused='f' where not exists (");
            updateSQL2.append(QUERY_USED_RESOURCE_SQL);
            updateSQL2.append(")");
            session = CommonDAOLocator.getBaseDao().getHibernateTemplate().getSessionFactory().openSession();
            NativeQuery query1 = session.createSQLQuery(updateSQL1.toString());
            NativeQuery query2 = session.createSQLQuery(updateSQL2.toString());
            session.beginTransaction();
            query1.executeUpdate();
            query2.executeUpdate();
            session.getTransaction().commit();
            DBOperationUtil.closeSession((Session)session);
        }
        catch (Exception e) {
            DBOperationUtil.rollbackSession(session);
            logger.error((Object)("Updating pool resource failed." + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784001L);
        }
        finally {
            DBOperationUtil.closeSession(session);
        }
    }

    private Set<String> getAllUsedStorageResourcesByPool(String poolUuid, Session session) {
        HashSet<String> allUsedResources = new HashSet<String>();
        StringBuilder querySQL = new StringBuilder();
        querySQL.append("select a.resourceuuid from ti_storagepoolresource a, t_managedobject b, ");
        querySQL.append("ti_storageresource c, ti_lun c1, ti_hyperclonepair d ");
        querySQL.append("where a.pooluuid=:poolUuid and c1.wwn=a.resourceuuid ");
        querySQL.append("and b.moid=c.moid and c.moid=c1.moid and c.devsn=d.devicesn and c.resourceid=d.tgtlunid");
        NativeQuery query = session.createSQLQuery(querySQL.toString());
        query.setString("poolUuid", poolUuid);
        List results = query.list();
        if (!VerifyUtil.isEmpty((Collection)results)) {
            for (Object object : results) {
                if (!(object instanceof String)) continue;
                String resourceWwn = String.valueOf(object);
                allUsedResources.add(resourceWwn);
            }
        }
        return allUsedResources;
    }

    private Set<String> getAllUsedStorageResourcesByDevSn(String deviceSn, Session session) {
        HashSet<String> allUsedResources = new HashSet<String>();
        StringBuilder querySQL = new StringBuilder();
        querySQL.append("select c1.wwn from t_managedobject b, ti_storageresource c, ti_lun c1, ");
        querySQL.append("ti_hyperclonepair d where c.devsn=:deviceSn ");
        querySQL.append("and b.moid=c.moid and c.moid=c1.moid and c.devsn=d.devicesn and c.resourceid=d.tgtlunid");
        NativeQuery query = session.createSQLQuery(querySQL.toString());
        query.setString("deviceSn", deviceSn);
        List results = query.list();
        if (!VerifyUtil.isEmpty((Collection)results)) {
            for (Object object : results) {
                if (!(object instanceof String)) continue;
                String resourceWwn = String.valueOf(object);
                allUsedResources.add(resourceWwn);
            }
        }
        return allUsedResources;
    }

    private Map<String, String> getStoragePoolNames() {
        HashMap<String, String> poolIdAndNameMap = new HashMap<String, String>();
        List storagePools = CommonDAOLocator.getMoDao().find("from StoragePool", new Object[0]);
        if (!VerifyUtil.isEmpty((Collection)storagePools)) {
            for (Object object : storagePools) {
                StoragePool pool = (StoragePool)object;
                XveUUID poolUUID = new XveUUID(pool.getNeSN(), XveMOType.STORAGEPOOL, pool.getPoolId());
                poolIdAndNameMap.put(poolUUID.toString(), pool.getName());
            }
        }
        return poolIdAndNameMap;
    }

    private Map<String, String> getControllerLocations() {
        HashMap<String, String> controllerLocations = new HashMap<String, String>();
        List controllers = CommonDAOLocator.getMoDao().find("from Controller", new Object[0]);
        if (!VerifyUtil.isEmpty((Collection)controllers)) {
            for (Object object : controllers) {
                Controller controller = (Controller)object;
                String location = controller.getLocation();
                if (VerifyUtil.isEmpty((String)location) && !VerifyUtil.isEmpty((String)controller.getControllerType())) {
                    location = controller.getControllerType();
                }
                controllerLocations.put(controller.getUuid(), location);
            }
        }
        return controllerLocations;
    }

    private Set<String> getPoolResourceUuidsByPool(String poolUuid, Session session) {
        List results;
        HashSet<String> poolResourceUuids = new HashSet<String>();
        StringBuilder queryPoolResourceHQL = new StringBuilder();
        queryPoolResourceHQL.append("select a from StoragePoolResource a");
        if (!VerifyUtil.isEmpty((String)poolUuid)) {
            queryPoolResourceHQL.append(" where a.poolUuid=:poolUuid");
        }
        Query query = session.createQuery(queryPoolResourceHQL.toString());
        if (!VerifyUtil.isEmpty((String)poolUuid)) {
            query.setString("poolUuid", poolUuid);
        }
        if (!VerifyUtil.isEmpty((Collection)(results = query.list()))) {
            for (Object object : results) {
                StoragePoolResource poolResource = (StoragePoolResource)object;
                poolResourceUuids.add(poolResource.getResourceUuid());
            }
        }
        return poolResourceUuids;
    }

    private StorageResourcePool constructStorageResourcePool(String name, String description, StorageEnumDefine.ResourcePoolEnum type, List<StorageResource> storageResources) {
        StorageResourcePool resourcePool = new StorageResourcePool();
        resourcePool.setUuid(UUIDGenerator.getUUID());
        resourcePool.setName(name);
        resourcePool.setDescription(description);
        resourcePool.setType(type.getValue());
        HashSet<String> providerSNs = new HashSet<String>();
        for (StorageResource resource : storageResources) {
            providerSNs.add(resource.getDevSn());
        }
        String providerSnStr = StringUtil.arrayToStrWithSplit((Object[])providerSNs.toArray(), (String)",");
        resourcePool.setResourceProvider(providerSnStr);
        return resourcePool;
    }

    private boolean isExistedStorageResourcePoolByName(String name) {
        String queryHQL = "from StorageResourcePool where name=?";
        List list = CommonDAOLocator.getBaseDao().find(queryHQL, new Object[]{name});
        return !VerifyUtil.isEmpty((Collection)list);
    }

    private boolean isExistedStorageResourcePoolByName(String uuid, String name) {
        String queryHQL = "from StorageResourcePool where name=? and uuid!=?";
        List list = CommonDAOLocator.getBaseDao().find(queryHQL, new Object[]{name, uuid});
        return !VerifyUtil.isEmpty((Collection)list);
    }

    private Map<String, Boolean> getUsedPoolResourceIInfos(String poolUuid) {
        HashMap<String, Boolean> resIsUsedInfos = new HashMap<String, Boolean>();
        String queryPoolResourceHQL = "select a from StoragePoolResource a where a.poolUuid = ?";
        List results = CommonDAOLocator.getBaseDao().find(queryPoolResourceHQL, new Object[]{poolUuid});
        if (!VerifyUtil.isEmpty((Collection)results)) {
            for (Object object : results) {
                StoragePoolResource poolResource = (StoragePoolResource)object;
                resIsUsedInfos.put(poolResource.getResourceUuid(), poolResource.getIsUsed());
            }
        }
        return resIsUsedInfos;
    }

    private void deleteStorageResources(String poolUuid, String[] resourceList, Session session) {
        StringBuilder deleteSQL = new StringBuilder();
        deleteSQL.append("delete from ti_storagepoolresource a where a.pooluuid=? and a.resourceuuid=? ");
        deleteSQL.append("and not exists (select b.* from t_managedobject b, ti_storageresource c, ti_lun c1, ");
        deleteSQL.append("ti_hyperclonepair d where b.moid=c.moid and c.moid=c1.moid and c1.wwn=? ");
        deleteSQL.append("and c.devsn=d.devicesn and c.resourceid=d.tgtlunid)");
        String querySQL = "select a.* from ti_storagepoolresource a where a.resourceuuid=?";
        for (String resourceUuid : resourceList) {
            NativeQuery selectQuery = session.createSQLQuery(querySQL);
            selectQuery.setString(0, resourceUuid);
            int count = 0;
            List results = selectQuery.list();
            if (!VerifyUtil.isEmpty((Collection)results)) {
                count = results.size();
            }
            NativeQuery delQuery = session.createSQLQuery(deleteSQL.toString());
            delQuery.setString(0, poolUuid);
            delQuery.setString(1, resourceUuid);
            delQuery.setString(2, resourceUuid);
            int result = delQuery.executeUpdate();
            if (0 == count || 1 == result) continue;
            throw new LegoCheckedException(1073948238L);
        }
    }

    private void updateResourceProviderOfPool(StorageResourcePool resourcePool, String[] resourceList, Session session) {
        HashSet<String> deviceSNs = new HashSet<String>();
        IStorageResourceService resourceService = (IStorageResourceService)ServiceLocator.getInstance().getService(IStorageResourceService.class);
        List resources = resourceService.getStorageResourcesByUuid(Arrays.asList(resourceList), StorageResource.class);
        for (StorageResource storageResource : resources) {
            deviceSNs.add(storageResource.getDevSn());
        }
        HashSet<String> newResourceProviders = new HashSet<String>();
        Set<String> resourceUuids = this.getPoolResourceUuidsByPool(resourcePool.getUuid(), session);
        ArrayList<String> preResourceList = new ArrayList<String>();
        preResourceList.addAll(resourceUuids);
        List poolResources = resourceService.getStorageResourcesByUuid(preResourceList, StorageResource.class);
        for (StorageResource storageResource : poolResources) {
            deviceSNs.add(storageResource.getDevSn());
        }
        newResourceProviders.addAll(deviceSNs);
        String providerSnStr = StringUtil.arrayToStrWithSplit((Object[])newResourceProviders.toArray(), (String)",");
        resourcePool.setResourceProvider(providerSnStr);
        session.update((Object)resourcePool);
    }

    private void startQuartzScheduler() {
        String propFile = "storageresourcepool_quartz.properties";
        Properties props = ResourceUtil.getInstance().readProperties(propFile, StorageResourcePoolServiceImpl.class);
        try {
            StdSchedulerFactory sf = new StdSchedulerFactory();
            if (sf.getScheduler(this.storageResPoolSchedulerName) != null) {
                this.quartzScheduler = sf.getScheduler(this.storageResPoolSchedulerName);
            } else {
                sf.initialize(props);
                this.quartzScheduler = sf.getScheduler();
            }
            this.quartzScheduler.start();
        }
        catch (SchedulerException e) {
            logger.error((Object)"start quartz failed", (Throwable)e, 90160758784001L);
            throw new LegoCheckedException(-1L, (Throwable)e);
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)"load quartz file failed", (long)-1L, (String[])new String[0], (Log)logger);
        }
    }

    private void startUpdateStoragePoolResourceJob() {
        String interval = ResourceUtil.getValue((String)"poolResourceUpdateInterval", (String)"5");
        int defaultInterval = 300000;
        try {
            defaultInterval = Integer.parseInt(interval) * 60 * 1000;
        }
        catch (Exception e) {
            logger.error((Object)("Parsing interval failed. Str:" + interval + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784001L);
        }
        SimpleTriggerImpl trigger = new SimpleTriggerImpl("UpdateStoragePoolResourceTrigger", null, new Date(), null, -1, (long)defaultInterval);
        try {
            JobDetailImpl jobDetail = new JobDetailImpl("JOB_UpdateStoragePoolResource", "JOB_GROUP_UpdateStoragePoolResource", UpdateStoragePoolResourceJob.class);
            jobDetail.setDurability(true);
            this.quartzScheduler.scheduleJob((JobDetail)jobDetail, (Trigger)trigger);
        }
        catch (SchedulerException e) {
            logger.error((Object)"Schedule job failed", (Throwable)e, 90160758784001L);
        }
    }

    private void fillControllerNameOfLun(StorageResource storageResource, Map<String, String> controllerLocations) {
        String controllerName;
        if (!(storageResource instanceof Lun) || VerifyUtil.isEmpty(controllerLocations)) {
            return;
        }
        Lun lun = (Lun)storageResource;
        String controllerUUID = lun.getDevSn() + "14:0:" + lun.getControllerId();
        if (lun instanceof XveLun) {
            controllerUUID = new XveUUID(lun.getDevSn(), XveMOType.CONTROLLER, lun.getControllerId()).toString();
        }
        if (null == (controllerName = controllerLocations.get(controllerUUID))) {
            logger.error((Object)("Controller does not exist. ControllerId:" + controllerUUID + ",LunId:" + lun.getLunId() + ",LunName:" + lun.getName()));
            controllerName = "";
        }
        lun.setControllerName(controllerName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createCascadeDelPoolResourceTrigger() {
        Session session = null;
        try {
            StringBuilder createFuncSQL = new StringBuilder();
            createFuncSQL.append("create or replace function func_cascade_del_poolresource ");
            createFuncSQL.append("returns trigger as $func_cascade_del_poolresource$ ");
            createFuncSQL.append("begin if (TG_OP  = 'DELETE') then ");
            createFuncSQL.append("delete from ti_storagepoolresource a where a.resourceuuid=(");
            createFuncSQL.append("select distinct c.wwn from t_managedobject b, ti_lun c ");
            createFuncSQL.append("where b.uuid=OLD.uuid and b.moid=c.moid); ");
            createFuncSQL.append("end if; end; $func_cascade_del_poolresource$ LANGUAGE plpgsql;");
            String createTriggerSQL = "create or replace trigger t_cascade_del_poolresource after delete on t_managedobject for each row execute procedure func_cascade_del_poolresource();";
            session = CommonDAOLocator.getBaseDao().getHibernateTemplate().getSessionFactory().openSession();
            session.beginTransaction();
            NativeQuery query = session.createSQLQuery(createFuncSQL.toString());
            query.executeUpdate();
            query = session.createSQLQuery(createTriggerSQL);
            query.executeUpdate();
            session.getTransaction().commit();
        }
        catch (Throwable e) {
            try {
                DBOperationUtil.rollbackSession(session);
                logger.error((Object)("creating cascade del pool resource trigger failed." + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784001L);
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                DBOperationUtil.closeSession(session);
            }
        }
        DBOperationUtil.closeSession((Session)session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isExceedMaxResourceCount(String poolUuid, int newAddedCount) {
        Session session;
        block4: {
            boolean bl;
            session = null;
            try {
                String querySQL = "select * from ti_storagepoolresource where pooluuid=:pooluuid";
                session = CommonDAOLocator.getBaseDao().getHibernateTemplate().getSessionFactory().openSession();
                NativeQuery query = session.createSQLQuery(querySQL);
                query.setString("pooluuid", poolUuid);
                List results = query.list();
                if (VerifyUtil.isEmpty((Collection)results) || 512 >= results.size() + newAddedCount) break block4;
                bl = true;
            }
            catch (Exception e) {
                try {
                    logger.error((Object)("isExceededMaxResourceCount failed." + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784001L);
                }
                catch (Throwable throwable) {
                    DBOperationUtil.closeSession(session);
                    throw throwable;
                }
                DBOperationUtil.closeSession((Session)session);
            }
            DBOperationUtil.closeSession((Session)session);
            return bl;
        }
        DBOperationUtil.closeSession((Session)session);
        return false;
    }

    private List<StoragePoolResource> constructStoragePoolResources(String uuid, List<?> results) {
        ArrayList<StoragePoolResource> resources = new ArrayList<StoragePoolResource>();
        Map<String, Boolean> resourceIsUsedInfos = this.getUsedPoolResourceIInfos(uuid);
        Map<String, String> poolIdAndNameMap = this.getStoragePoolNames();
        Map<String, String> controllerLocations = this.getControllerLocations();
        for (Object object : results) {
            StorageResource storageResource = (StorageResource)object;
            StoragePoolResource poolResource = this.constructPoolResourceByStorageResource(uuid, storageResource, poolIdAndNameMap, resourceIsUsedInfos, controllerLocations);
            resources.add(poolResource);
        }
        return resources;
    }

    private StoragePoolResource constructPoolResourceByStorageResource(String uuid, StorageResource storageResource, Map<String, String> poolIdAndNameMap, Map<String, Boolean> resourceIsUsedInfos, Map<String, String> controllerLocations) {
        Lun lun = (Lun)storageResource;
        this.fillControllerNameOfLun((StorageResource)lun, controllerLocations);
        if (lun instanceof XveLun) {
            XveLun xveLun = (XveLun)lun;
            XveUUID poolUuid = new XveUUID(xveLun.getDevSn(), XveMOType.STORAGEPOOL, xveLun.getStoragePoolId());
            xveLun.setStoragePoolName(poolIdAndNameMap.get(poolUuid.toString()));
        }
        StoragePoolResource poolResource = new StoragePoolResource();
        poolResource.setIsUsed(resourceIsUsedInfos.get(lun.getWwn()));
        poolResource.setPoolUuid(uuid);
        poolResource.setResourceId(lun.getResourceId());
        poolResource.setResourceUuid(lun.getWwn());
        poolResource.setStorageResource((StorageResource)lun);
        return poolResource;
    }
}

