/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.system.cfgdata;

import com.huawei.ism.drm.system.cfgdata.DrvSshPara;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.Ipv4AddressUtil;
import com.huawei.lego.core.sdk.util.Ipv6AddressUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.security.PublicKey;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.sshd.client.SshClient;
import org.apache.sshd.client.future.ConnectFuture;
import org.apache.sshd.client.keyverifier.AcceptAllServerKeyVerifier;
import org.apache.sshd.client.keyverifier.ServerKeyVerifier;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.common.SshException;
import org.apache.sshd.common.file.util.BasePath;
import org.apache.sshd.common.future.CancelOption;
import org.apache.sshd.common.util.buffer.ByteArrayBuffer;
import org.apache.sshd.sftp.client.SftpClientFactory;
import org.apache.sshd.sftp.client.fs.SftpFileSystem;
import org.apache.sshd.sftp.client.fs.SftpPath;
import org.springframework.util.DigestUtils;

public class SftpSshdUtil {
    private static final Log LOGGER = LogFactory.getInstance(SftpSshdUtil.class);
    private static final Duration CONNECT_TIMEOUT = Duration.ofSeconds(7L);
    private static final Duration AUTH_TIMEOUT = Duration.ofSeconds(5L);
    private static final String[] CHARS = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "a", "b", "c", "d", "e", "f"};
    private SshClient sshClient;
    private SftpFileSystem sftpFileSystem;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getFtpHostKey(String ip, Integer port) {
        if (!Ipv4AddressUtil.isValidIPv4((String)ip) || !Ipv6AddressUtil.isValidIPv6((String)ip)) {
            LOGGER.error((Object)"The parameter ip is incorrect,ip is %s.", new Object[]{ip});
            return "";
        }
        if (SftpSshdUtil.checkPort(port)) {
            LOGGER.error((Object)"The parameter port is incorrect.");
            return "";
        }
        String hostKey = "";
        SshClient client = null;
        ClientSession clientSession = null;
        try {
            client = SshClient.setUpDefaultClient();
            client.start();
            clientSession = (ClientSession)((ConnectFuture)client.connect("", ip, port.intValue()).verify(CONNECT_TIMEOUT, new CancelOption[0])).getSession();
            clientSession.auth().verify(AUTH_TIMEOUT, new CancelOption[0]);
        }
        catch (SshException ex) {
            if (clientSession == null) {
                String string = hostKey;
                return string;
            }
            PublicKey publicKey = clientSession.getServerKey();
            ByteArrayBuffer buffer = new ByteArrayBuffer();
            buffer.putRawPublicKey(publicKey);
            hostKey = SftpSshdUtil.getFingerPrint(buffer.getCompactData());
        }
        catch (IOException ex) {
            LOGGER.error((Object)"Method getHostKey failed, the sftp server ip is %s ,error msg is %s.", new Object[]{ip, ExceptionUtil.getErrorMessage((Throwable)ex)});
        }
        finally {
            if (clientSession != null) {
                clientSession.close(true);
            }
            if (client != null) {
                client.stop();
            }
        }
        return hostKey;
    }

    private static String getFingerPrint(byte[] data) {
        try {
            byte[] foo = DigestUtils.md5Digest((byte[])data);
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < foo.length; ++i) {
                int bar = foo[i] & 0xFF;
                sb.append(CHARS[bar >>> 4 & 0xF]);
                sb.append(CHARS[bar & 0xF]);
                if (i + 1 >= foo.length) continue;
                sb.append(":");
            }
            return sb.toString();
        }
        catch (IllegalArgumentException var6) {
            LOGGER.error((Object)"getFingerPrint failed,error msg is %s.", new Object[]{ExceptionUtil.getErrorMessage((Throwable)var6)});
            return "";
        }
    }

    public static boolean isInvalidSshPara(DrvSshPara para) {
        if (para == null) {
            return true;
        }
        if (!Ipv4AddressUtil.isValidIPv4((String)para.getIp()) || !Ipv6AddressUtil.isValidIPv6((String)para.getIp())) {
            LOGGER.error((Object)"Invalid ssh ip address.");
            return true;
        }
        if (StringUtils.isBlank((CharSequence)para.getSshPassword())) {
            LOGGER.error((Object)"Invalid ssh password.");
            return true;
        }
        if (StringUtils.isBlank((CharSequence)para.getUserName())) {
            LOGGER.error((Object)"Invalid ssh username.");
            return true;
        }
        return SftpSshdUtil.checkPort(para.getSshPort());
    }

    private static boolean checkPort(Integer port) {
        if (port == null || port > 65535 || port < 1) {
            LOGGER.error((Object)"Invalid ssh port:%s", new Object[]{String.valueOf(port)});
            return true;
        }
        return false;
    }

    public boolean login(DrvSshPara para) {
        if (SftpSshdUtil.isInvalidSshPara(para)) {
            LOGGER.error((Object)"Invalid login parameter.");
            return false;
        }
        this.sshClient = SshClient.setUpDefaultClient();
        this.sshClient.setServerKeyVerifier((ServerKeyVerifier)AcceptAllServerKeyVerifier.INSTANCE);
        this.sshClient.start();
        boolean isSuccess = false;
        for (int index = 0; index < 3; ++index) {
            if (!this.initSession(para, index)) continue;
            isSuccess = true;
            break;
        }
        if (isSuccess) {
            LOGGER.info((Object)"Login ftp server success. IP\uff1a%s , user :%s", new Object[]{para.getIp(), para.getUserName()});
        } else {
            LOGGER.error((Object)"Login ftp server failed. IP\uff1a%s , user :%s", new Object[]{para.getIp(), para.getUserName()});
        }
        return isSuccess;
    }

    private boolean initSession(DrvSshPara para, int index) {
        try {
            ClientSession session = (ClientSession)((ConnectFuture)this.sshClient.connect(para.getUserName(), para.getIp(), para.getSshPort().intValue()).verify(CONNECT_TIMEOUT, new CancelOption[0])).getSession();
            if (session == null) {
                LOGGER.error((Object)"Failed to get session.");
                return false;
            }
            session.addPasswordIdentity(para.getSshPassword());
            session.auth().verify(AUTH_TIMEOUT, new CancelOption[0]);
            this.sftpFileSystem = SftpClientFactory.instance().createSftpFileSystem(session);
            return true;
        }
        catch (IOException ex) {
            LOGGER.error((Object)"Failed to login to the SFTP server,index is %s,msg is %s.", new Object[]{index, ExceptionUtil.getErrorMessage((Throwable)ex)});
            return false;
        }
    }

    public boolean createDirectory(String path) {
        if (StringUtils.isBlank((CharSequence)path)) {
            LOGGER.error((Object)"The directory path is empty.");
            return false;
        }
        this.checkLogin();
        try {
            BasePath remote = this.sftpFileSystem.getDefaultDir().resolve(path);
            Files.createDirectories((Path)remote, new FileAttribute[0]);
            LOGGER.info((Object)"Create directory success.");
            return true;
        }
        catch (IOException ex) {
            LOGGER.error((Object)"Failed to create the remote directory,msg is %s.", new Object[]{ExceptionUtil.getErrorMessage((Throwable)ex)});
            return false;
        }
    }

    private void checkLogin() {
        if (this.sftpFileSystem == null) {
            throw new LegoCheckedException("Please login first.");
        }
    }

    public boolean upLoadFile(File localFile, String remoteDirectory, String remoteFileName) {
        if (localFile == null || !localFile.exists() || !localFile.isFile()) {
            LOGGER.error((Object)"The local file does not exist or is not file.");
            return false;
        }
        if (StringUtils.isBlank((CharSequence)remoteFileName)) {
            LOGGER.error((Object)"The remoteFileName is empty.");
            return false;
        }
        this.checkLogin();
        try {
            SftpPath remote = (SftpPath)this.sftpFileSystem.getDefaultDir().resolve(remoteDirectory);
            Files.createDirectories((Path)remote, new FileAttribute[0]);
            Files.copy(Paths.get(localFile.toURI()), (Path)remote.resolve(remoteFileName), StandardCopyOption.REPLACE_EXISTING);
            LOGGER.info((Object)"UpLoad file success.");
            return true;
        }
        catch (IOException ex) {
            LOGGER.error((Object)"Upload file failed.remoteFileName is %s,msg is %s.", new Object[]{remoteFileName, ExceptionUtil.getErrorMessage((Throwable)ex)});
            return false;
        }
    }

    private boolean deleteDirectory(String path) {
        if (StringUtils.isBlank((CharSequence)path)) {
            LOGGER.error((Object)"The param parameter is empty.");
            return false;
        }
        BasePath remote = this.sftpFileSystem.getDefaultDir().resolve(path);
        if (!Files.isDirectory((Path)remote, new LinkOption[0])) {
            LOGGER.error((Object)"The parameter path is not directory.");
            return false;
        }
        try {
            this.deleteRecursive((Path)remote);
            LOGGER.info((Object)"Method delete directory and file success.");
            return true;
        }
        catch (LegoCheckedException | IOException ex) {
            LOGGER.error((Object)"Delete directory and file failed,error msg is %s.", new Object[]{ExceptionUtil.getErrorMessage((Throwable)ex)});
            return false;
        }
    }

    public boolean deleteDirectory(String parentDir, String dirPath) {
        if (StringUtils.isBlank((CharSequence)parentDir)) {
            LOGGER.error((Object)"Invalid parentDir parameter.");
            return false;
        }
        if (StringUtils.isBlank((CharSequence)dirPath)) {
            LOGGER.error((Object)"Invalid dirPath parameter.");
            return false;
        }
        this.checkLogin();
        String path = parentDir + "/" + dirPath;
        if (this.deleteDirectory(path)) {
            LOGGER.info((Object)"Delete dir success.");
            return true;
        }
        LOGGER.error((Object)"Failed to delete dir.");
        return false;
    }

    private void deleteRecursive(Path path) throws IOException {
        if (path == null || !Files.exists(path, new LinkOption[0])) {
            return;
        }
        if (Files.isDirectory(path, new LinkOption[0])) {
            try (DirectoryStream<Path> ds = Files.newDirectoryStream(path);){
                for (Path child : ds) {
                    this.deleteRecursive(child);
                }
            }
        }
        Files.delete(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteFile(String remoteDir, String remotePath, DrvSshPara para) {
        if (SftpSshdUtil.isInvalidSshPara(para)) {
            LOGGER.error((Object)"Invalid ftp parameter.");
            return false;
        }
        if (StringUtils.isBlank((CharSequence)remotePath)) {
            LOGGER.error((Object)"Invalid remotePath parameter.");
            return false;
        }
        if (StringUtils.isBlank((CharSequence)remoteDir)) {
            LOGGER.error((Object)"Invalid remoteDir parameter.");
            return false;
        }
        boolean loginFlag = this.login(para);
        if (!loginFlag) {
            LOGGER.error((Object)"Connect ftp server(%s) failed.", new Object[]{para.getIp()});
            return false;
        }
        BasePath remoteDirPath = this.sftpFileSystem.getDefaultDir().resolve(remoteDir);
        Path filePath = remoteDirPath.resolve(remotePath);
        if (Files.isDirectory(filePath, new LinkOption[0])) {
            LOGGER.error((Object)"Parameter remotePath is not file.");
            return false;
        }
        try {
            Files.delete(filePath);
            LOGGER.info((Object)"Method deleteFile success.");
            boolean bl = true;
            return bl;
        }
        catch (IOException ex) {
            LOGGER.error((Object)"Delete file failed,error is %s.", new Object[]{ExceptionUtil.getErrorMessage((Throwable)ex)});
        }
        finally {
            this.logout();
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<Path> getChildDirectory(String path) {
        if (StringUtils.isBlank((CharSequence)path)) {
            LOGGER.error((Object)"The parameter path is empty.");
            return Collections.emptyList();
        }
        this.checkLogin();
        BasePath remoteDirPath = this.sftpFileSystem.getDefaultDir().resolve(path);
        if (!Files.isDirectory((Path)remoteDirPath, new LinkOption[0])) {
            LOGGER.error((Object)"The parameter path is not file directory.");
            return Collections.emptyList();
        }
        try (Stream<Path> stream = Files.list((Path)remoteDirPath);){
            List<Path> list = stream.filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).collect(Collectors.toList());
            return list;
        }
        catch (IOException ex) {
            LOGGER.error((Object)"Get child directory failed,error is %s.", new Object[]{ExceptionUtil.getErrorMessage((Throwable)ex)});
            return Collections.emptyList();
        }
    }

    public void logout() {
        if (this.sftpFileSystem != null) {
            try {
                this.sftpFileSystem.close();
            }
            catch (IOException ex) {
                LOGGER.error((Object)"Close SftpFileSystem failed.", new Object[]{ExceptionUtil.getErrorMessage((Throwable)ex)});
            }
        }
        if (this.sshClient != null) {
            this.sshClient.stop();
        }
    }
}

