/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.system.cfgdata;

import com.huawei.ism.drm.system.cfgdata.DrvSshPara;
import com.huawei.ism.drm.system.cfgdata.SftpSshdUtil;
import com.huawei.ism.drm.system.cfgdata.SshRespBody;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.SecurityUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.EnumSet;
import org.apache.sshd.client.SshClient;
import org.apache.sshd.client.channel.ChannelExec;
import org.apache.sshd.client.channel.ClientChannelEvent;
import org.apache.sshd.client.future.ConnectFuture;
import org.apache.sshd.client.future.OpenFuture;
import org.apache.sshd.client.keyverifier.AcceptAllServerKeyVerifier;
import org.apache.sshd.client.keyverifier.ServerKeyVerifier;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.common.future.CancelOption;

public class SshSshdUtil {
    private static final Log LOGGER = LogFactory.getInstance(SshSshdUtil.class);
    private static final Duration CONNECT_TIMEOUT = Duration.ofSeconds(7L);
    private static final Duration AUTH_TIMEOUT = Duration.ofSeconds(5L);
    private static final int EXEC_FAILED = -1;
    private ClientSession session;
    private SshClient sshClient;

    public boolean initSession(DrvSshPara para) {
        if (SftpSshdUtil.isInvalidSshPara(para)) {
            LOGGER.error((Object)"Invalid login parameter.");
            return false;
        }
        try {
            this.sshClient = SshClient.setUpDefaultClient();
            this.sshClient.setServerKeyVerifier((ServerKeyVerifier)AcceptAllServerKeyVerifier.INSTANCE);
            this.sshClient.start();
            this.session = (ClientSession)((ConnectFuture)this.sshClient.connect(para.getUserName(), para.getIp(), para.getSshPort().intValue()).verify(CONNECT_TIMEOUT, new CancelOption[0])).getSession();
            if (this.session == null) {
                LOGGER.error((Object)"Failed to get session.");
                return false;
            }
            this.session.addPasswordIdentity(para.getSshPassword());
            this.session.auth().verify(AUTH_TIMEOUT, new CancelOption[0]);
            SecurityUtil.erasePwd((String)para.getSshPassword());
        }
        catch (IOException e) {
            LOGGER.error((Object)"Login host: %s failed, errorMsg: %s", new Object[]{para.getIp(), ExceptionUtil.getErrorMessage((Throwable)e)});
            return false;
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SshRespBody runShell(String command) {
        SshRespBody respBody = new SshRespBody();
        if (SecurityUtil.fileValueBlackListCheck((String)command)) {
            LOGGER.error((Object)"The input command is illegal.");
            respBody.setResCode(-1);
            respBody.setErrorMsg("The input command is illegal");
            return respBody;
        }
        this.checkLogin();
        try (ChannelExec channel = this.session.createExecChannel(command);
             ByteArrayOutputStream responseStream = new ByteArrayOutputStream();
             ByteArrayOutputStream errorStream = new ByteArrayOutputStream();){
            if (VerifyUtil.isEmpty((Object)channel)) {
                LOGGER.error((Object)"Create channel failed.");
                respBody.setResCode(-1);
                respBody.setErrorMsg("Create channel failed, session is illegal.");
                SshRespBody sshRespBody = respBody;
                return sshRespBody;
            }
            channel.setOut((OutputStream)responseStream);
            channel.setErr((OutputStream)errorStream);
            if (!((OpenFuture)channel.open().verify(CONNECT_TIMEOUT, new CancelOption[0])).isOpened()) {
                LOGGER.error((Object)"Exec channel open failed.");
                throw new LegoCheckedException(-1L);
            }
            channel.waitFor(EnumSet.of(ClientChannelEvent.CLOSED), CONNECT_TIMEOUT);
            int status = channel.getExitStatus();
            channel.close();
            respBody.setResCode(status);
            respBody.setResInfo(responseStream.toString(StandardCharsets.UTF_8.toString()));
            respBody.setErrorMsg(errorStream.toString(StandardCharsets.UTF_8.toString()));
            return respBody;
        }
        catch (IOException e) {
            LOGGER.error((Object)"Exec command failed, errorMsg: %s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
            throw new LegoCheckedException(-1L);
        }
    }

    private void checkLogin() {
        if (this.session == null) {
            throw new LegoCheckedException("Please get ssh session first.");
        }
    }

    public void closeCollection() throws IOException {
        if (this.session != null && this.session.isOpen()) {
            this.session.close();
        }
        if (this.sshClient != null && this.sshClient.isOpen()) {
            this.sshClient.stop();
            this.sshClient.close();
        }
    }
}

