/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.cert.sdk.service.command;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class Parameter {
    public static final String CERT_NAME = "cert-name";
    public static final String RESULT_MAP = "resultMap";
    public static final String TIME_STAMP = "timestamp";
    private Map<String, String> opts;
    private List<String> args;

    public Parameter(Map<String, String> opts) {
        this(opts, new ArrayList<String>());
    }

    public Parameter(Map<String, String> opts, List<String> args) {
        this.opts = new HashMap<String, String>(opts);
        this.args = new ArrayList<String>(args);
    }

    public Map<String, String> getOpts() {
        return this.opts;
    }

    public List<String> getArgs() {
        return this.args;
    }

    public static Parameter combine(Parameter ... items) {
        Parameter result = new Parameter(new HashMap<String, String>(), new ArrayList<String>());
        if (items == null) {
            return result;
        }
        for (Parameter item : items) {
            Optional.ofNullable(item.opts).ifPresent(result.opts::putAll);
            Optional.ofNullable(item.args).ifPresent(result.args::addAll);
        }
        return result;
    }
}

