/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.sdk.model;

import com.huawei.ism.cbb.proxy.xve.XveEuumDefineParent;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.ReplicationConstantDefine;
import com.huawei.ism.drm.storage.sdk.model.ReplicationRelation;
import com.huawei.ism.drm.storage.sdk.model.ReplicationTargetLun;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class ReplicationPair
extends ReplicationRelation {
    private static final long serialVersionUID = 2305415444946554025L;
    private String consistentGroupId;
    private Long createTime;
    private List<ReplicationTargetLun> repTgtLuns = new ArrayList<ReplicationTargetLun>(0);
    private Double srcLunCapacity;
    private String srcLunId;
    private String srcLunWWN;
    private String srcLunName;
    private Long slientTime;
    private int srcLunStatus;
    private String tgtLocation;
    private String tgtDevName;
    private String vstorePairId;

    public String getConsistentGroupId() {
        return this.consistentGroupId;
    }

    public void setConsistentGroupId(String consistentGroupId) {
        this.consistentGroupId = consistentGroupId;
    }

    public int getSrcLunStatus() {
        return this.srcLunStatus;
    }

    public void setSrcLunStatus(int srcLunStatus) {
        this.srcLunStatus = srcLunStatus;
    }

    public Long getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(Long createTime) {
        this.createTime = createTime;
    }

    public Long getSlientTime() {
        return this.slientTime;
    }

    public void setSlientTime(Long slientTime) {
        this.slientTime = slientTime;
    }

    public String getTgtLocation() {
        return this.tgtLocation;
    }

    public void setTgtLocation(String tgtLocation) {
        this.tgtLocation = tgtLocation;
    }

    public String getTgtDevName() {
        return this.tgtDevName;
    }

    public void setTgtDevName(String tgtDevName) {
        this.tgtDevName = tgtDevName;
    }

    public Double getSrcLunCapacity() {
        return this.srcLunCapacity;
    }

    public void setSrcLunCapacity(Double srcLunCapacity) {
        this.srcLunCapacity = srcLunCapacity;
    }

    public String getSrcLunName() {
        return this.srcLunName;
    }

    public void setSrcLunName(String srcLunName) {
        this.srcLunName = srcLunName;
    }

    public List<ReplicationTargetLun> getRepTgtLuns() {
        return this.repTgtLuns;
    }

    public void setRepTgtLuns(List<ReplicationTargetLun> repTgtLuns) {
        this.repTgtLuns = repTgtLuns;
    }

    public String getSrcLunId() {
        return this.srcLunId;
    }

    public void setSrcLunId(String srcLunId) {
        this.srcLunId = srcLunId;
    }

    public String getSrcLunWWN() {
        return this.srcLunWWN;
    }

    public void setSrcLunWWN(String srcLunWWN) {
        this.srcLunWWN = srcLunWWN;
    }

    public boolean equals(Object obj) {
        if (null == obj) {
            return false;
        }
        if (!(obj instanceof ReplicationPair)) {
            return false;
        }
        ReplicationPair other = (ReplicationPair)((Object)obj);
        if (!this.isSameReplicatonId(other.getReplicationId())) {
            return false;
        }
        if (!this.isSameRole(other)) {
            return false;
        }
        if (!this.isSameSrcDev(other.getSrcDevSN())) {
            return false;
        }
        if (!this.isSameSrcLunId(other.getSrcLunId())) {
            return false;
        }
        return this.hasSameTargetLun(other);
    }

    public int hashCode() {
        int result = this.getReplicationId().hashCode();
        if (null != this.getSrcDevSN()) {
            result += this.getSrcDevSN().hashCode();
        }
        if (null != this.getSrcLunId()) {
            result += this.getSrcLunId().hashCode();
        }
        return result;
    }

    private boolean isSameReplicatonId(String replicationId) {
        if (null == replicationId) {
            return false;
        }
        return replicationId.equals(this.getReplicationId());
    }

    private boolean isSameRole(ReplicationPair other) {
        if (null == other) {
            return false;
        }
        return other.getIsPrimary() != false && this.getIsPrimary() != false || other.getIsPrimary() == false && this.getIsPrimary() == false;
    }

    private boolean isSameSrcDev(String srcDevSN) {
        if (null == srcDevSN) {
            return false;
        }
        return srcDevSN.equals(this.getSrcDevSN());
    }

    private boolean isSameSrcLunId(String sourceLunId) {
        if (null == sourceLunId) {
            return false;
        }
        return sourceLunId.equals(this.getSrcLunId());
    }

    private boolean hasSameTargetLun(ReplicationPair other) {
        if (null == other) {
            return false;
        }
        List<ReplicationTargetLun> tgtLuns = null;
        if (other.getIsPrimary().booleanValue()) {
            tgtLuns = other.getRepTgtLuns();
        } else if (this.getIsPrimary().booleanValue()) {
            tgtLuns = this.getRepTgtLuns();
        }
        return tgtLuns != null && !tgtLuns.isEmpty();
    }

    public String getVstorePairId() {
        return this.vstorePairId;
    }

    public void setVstorePairId(String vstorePairId) {
        this.vstorePairId = vstorePairId;
    }

    public String getTgtDevSN() {
        if (null == this.repTgtLuns || this.repTgtLuns.isEmpty()) {
            return null;
        }
        return this.repTgtLuns.get(0).getTgtDevSN();
    }

    public String getTgtLunId() {
        if (null == this.repTgtLuns || this.repTgtLuns.isEmpty()) {
            return null;
        }
        return this.repTgtLuns.get(0).getTgtLunId();
    }

    public boolean isNormal() {
        List<ReplicationTargetLun> tgtLuns = this.getRepTgtLuns();
        if (VerifyUtil.isEmpty(tgtLuns) || tgtLuns.isEmpty()) {
            return false;
        }
        for (ReplicationTargetLun tgtLun : tgtLuns) {
            int pairStatus = tgtLun.getPairStatus();
            if (XveEuumDefineParent.RUNNING_STATUS_E.NORMAL.getValue() == pairStatus || XveEuumDefineParent.RUNNING_STATUS_E.SYNCHRONIZING.getValue() == pairStatus || ReplicationConstantDefine.PairStatus.SYNCHRONIZING.getValue() == pairStatus) continue;
            return false;
        }
        return true;
    }

    public boolean isSplit() {
        List<ReplicationTargetLun> tgtLunList = this.getRepTgtLuns();
        if (VerifyUtil.isEmpty(tgtLunList)) {
            return false;
        }
        for (ReplicationTargetLun tgtLun : tgtLunList) {
            int pairStatus = tgtLun.getPairStatus();
            if (pairStatus != XveEuumDefineParent.RUNNING_STATUS_E.SPLIT.getValue() && pairStatus != ReplicationConstantDefine.PairStatus.SPLITED.getValue()) continue;
            return true;
        }
        return false;
    }

    public boolean isStandby() {
        List<ReplicationTargetLun> tgtLuns = this.getRepTgtLuns();
        if (VerifyUtil.isEmpty(tgtLuns)) {
            return false;
        }
        for (ReplicationTargetLun tgtLun : tgtLuns) {
            if (XveEuumDefineParent.RUNNING_STATUS_E.STANDBY.getValue() != tgtLun.getPairStatus().intValue()) continue;
            return true;
        }
        return false;
    }

    public boolean isAsync() {
        return this.getReplicationMode() == 2;
    }

    public Optional<String> getTgtLunName() {
        if (VerifyUtil.isEmpty(this.repTgtLuns)) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.repTgtLuns.get(0)).map(ReplicationTargetLun::getTgtLunName);
    }
}

