/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.sdk.model;

import com.huawei.ism.drm.constant.SwitchoverEnum;
import com.huawei.ism.drm.storage.sdk.model.RemoteLinkDevice;
import com.huawei.ism.drm.storage.sdk.model.ResourceTimeWindowRange;
import com.huawei.ism.drm.storage.sdk.model.StorageLinkPort;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class ResourceTimeWindow
implements Serializable {
    private static final long serialVersionUID = 4798349738131257176L;
    private String windowId = null;
    private String resourceId = null;
    private String portId = null;
    private long time = -1L;
    private long lastSwitchOnTime = -1L;
    private long endSwitchOnTime;
    private String remoteName;
    private String esn;
    private String remoteWwn;
    private Boolean needIsolateAlarm = Boolean.FALSE;
    private Set<ResourceTimeWindowRange> timeWindowRanges = new HashSet<ResourceTimeWindowRange>();
    private SwitchoverEnum switchoverEnum = SwitchoverEnum.SECURITY;
    private String associatedPgIds;

    public void setAssociatedPgIds(String associatedPgIds) {
        this.associatedPgIds = associatedPgIds;
    }

    public String getAssociatedPgIds() {
        return this.associatedPgIds;
    }

    public void setNeedIsolateAlarm(Boolean needIsolateAlarm) {
        this.needIsolateAlarm = needIsolateAlarm;
    }

    public Boolean getNeedIsolateAlarm() {
        return this.needIsolateAlarm;
    }

    public void setRemoteWwn(String remoteWwn) {
        this.remoteWwn = remoteWwn;
    }

    public String getRemoteWwn() {
        return this.remoteWwn;
    }

    public void setWindowId(String windowId) {
        this.windowId = windowId;
    }

    public String getWindowId() {
        return this.windowId;
    }

    public String getResourceId() {
        return this.resourceId;
    }

    public void setResourceId(String resourceId) {
        this.resourceId = resourceId;
    }

    public String getPortId() {
        return this.portId;
    }

    public void setPortId(String portId) {
        this.portId = portId;
    }

    public void setEsn(String esn) {
        this.esn = esn;
    }

    public String getEsn() {
        return this.esn;
    }

    public void setRemoteName(String remoteName) {
        this.remoteName = remoteName;
    }

    public String getRemoteName() {
        return this.remoteName;
    }

    public Set<ResourceTimeWindowRange> getTimeWindowRanges() {
        return this.timeWindowRanges;
    }

    public void setTimeWindowRanges(Set<ResourceTimeWindowRange> timeWindowRanges) {
        this.timeWindowRanges = timeWindowRanges;
    }

    public long getTime() {
        return this.time;
    }

    public void setTime(long time) {
        this.time = time;
    }

    public void setSwitchoverEnum(SwitchoverEnum switchoverEnum) {
        this.switchoverEnum = switchoverEnum;
    }

    public SwitchoverEnum getSwitchoverEnum() {
        return this.switchoverEnum;
    }

    public void setLastSwitchOnTime(long lastSwitchOnTime) {
        this.lastSwitchOnTime = lastSwitchOnTime;
    }

    public long getLastSwitchOnTime() {
        return this.lastSwitchOnTime;
    }

    public void setEndSwitchOnTime(long endSwitchOnTime) {
        this.endSwitchOnTime = endSwitchOnTime;
    }

    public long getEndSwitchOnTime() {
        return this.endSwitchOnTime;
    }

    public void addTimeWindowRanges(ResourceTimeWindowRange timeWindowRange) {
        this.timeWindowRanges.add(timeWindowRange);
    }

    public void clearTimeWindowRanges() {
        this.timeWindowRanges.clear();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ResourceTimeWindow other = (ResourceTimeWindow)obj;
        if (!this.isSameWindowId(other.getWindowId())) {
            return false;
        }
        if (!this.isSameResourceId(other.getResourceId())) {
            return false;
        }
        return this.isSamePortId(other.getPortId());
    }

    private boolean isSameWindowId(String windowId) {
        if (windowId == null) {
            return false;
        }
        return windowId.equals(this.windowId);
    }

    private boolean isSameResourceId(String resourceId) {
        if (resourceId == null) {
            return false;
        }
        return resourceId.equals(this.resourceId);
    }

    private boolean isSamePortId(String portId) {
        if (portId == null) {
            return false;
        }
        return portId.equals(this.portId);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.windowId == null ? 0 : this.windowId.hashCode());
        result = 31 * result + (this.resourceId == null ? 0 : this.resourceId.hashCode());
        result = 31 * result + (this.portId == null ? 0 : this.portId.hashCode());
        return result;
    }

    public String getSubType() {
        return "";
    }

    public String toString() {
        return "ResourceTimeWindow{windowId='" + this.windowId + '\'' + ", resourceId='" + this.resourceId + '\'' + ", portId='" + this.portId + '\'' + ", time=" + this.time + ", remoteName='" + this.remoteName + '\'' + ", esn='" + this.esn + '\'' + ", remoteWwn='" + this.remoteWwn + '\'' + ", needIsolateAlarm=" + this.needIsolateAlarm + ", timeWindowRanges=" + this.timeWindowRanges + '}';
    }

    public static ResourceTimeWindow instance(String devSn, RemoteLinkDevice remoteDevice) {
        ResourceTimeWindow timeWindow = new ResourceTimeWindow();
        timeWindow.setResourceId(remoteDevice.getDeviceId());
        List portIds = remoteDevice.getLinkPorts().stream().map(StorageLinkPort::getPortId).collect(Collectors.toList());
        String tmpStr = portIds.toString();
        String portIdStr = tmpStr.substring(1, tmpStr.length() - 1);
        timeWindow.setPortId(portIdStr);
        HashSet<ResourceTimeWindowRange> timeWindowRanges = new HashSet<ResourceTimeWindowRange>();
        ResourceTimeWindowRange range = ResourceTimeWindow.getRanges();
        timeWindowRanges.add(range);
        timeWindow.setTimeWindowRanges(timeWindowRanges);
        timeWindow.setResourceId(devSn);
        timeWindow.setRemoteName(remoteDevice.getRemoteName());
        timeWindow.setEsn(remoteDevice.getEsn());
        timeWindow.setRemoteWwn(remoteDevice.getRemoteWwn());
        timeWindow.setNeedIsolateAlarm(true);
        timeWindow.setSwitchoverEnum(SwitchoverEnum.SECURITY);
        timeWindow.setLastSwitchOnTime(-1L);
        timeWindow.setTime(System.currentTimeMillis());
        return timeWindow;
    }

    private static ResourceTimeWindowRange getRanges() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        ResourceTimeWindowRange range = new ResourceTimeWindowRange();
        range.setStartTime(calendar.getTime());
        calendar.add(5, 1);
        range.setEndTime(calendar.getTime());
        return range;
    }
}

