/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.topo.sdk.twaver;

import com.huawei.ism.drm.topo.sdk.context.TopoBaseContext;
import com.huawei.ism.drm.topo.sdk.twaver.NodeComparator;
import com.huawei.twaver.IData;
import com.huawei.twaver.Link;
import com.huawei.twaver.Node;
import java.util.ArrayList;
import java.util.List;

public class Locator {
    private transient TopoBaseContext context;

    public Locator(TopoBaseContext context) {
        this.context = context;
    }

    public void locate(Node node) {
        IData parent = node.getParent();
        if (parent == null) {
            return;
        }
        List children = parent.getChildren();
        if (children != null && children.size() > 1) {
            List datas = this.context.getElementBox().getDatas();
            children.sort(new NodeComparator(datas));
            int index = datas.indexOf(parent);
            datas.removeAll(children);
            datas.addAll(index + 1, children);
        }
    }

    protected int compare(Node n1, Node n2) {
        double m1 = this.measure(n1);
        double m2 = this.measure(n2);
        return Double.compare(m1, m2);
    }

    protected double measure(Node node) {
        int sum = 0;
        int num = 0;
        List<Node> froms = this.getFromNodes(node);
        List datas = this.context.getElementBox().getDatas();
        for (Node from : froms) {
            int index = datas.indexOf(from);
            if (index == -1) continue;
            sum += index;
            ++num;
        }
        return num > 0 ? (double)sum / (double)num : 0.0;
    }

    protected List<Node> getFromNodes(Node node) {
        ArrayList<Node> nodes = new ArrayList<Node>();
        List links = node.getToLinks();
        if (links != null) {
            for (Link link : links) {
                nodes.add(link.getFromNode());
            }
        }
        return nodes;
    }
}

