/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.topo.sdk.twaver;

import com.huawei.twaver.Link;
import com.huawei.twaver.Node;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

public class NodeComparator
implements Comparator<Object>,
Serializable {
    private static final long serialVersionUID = 202472713827852370L;
    private List<Object> datas = null;

    public NodeComparator(List<Object> datas) {
        this.datas = datas;
    }

    @Override
    public int compare(Object d1, Object d2) {
        if (d1 instanceof Node && d2 instanceof Node) {
            return this.compare((Node)d1, (Node)d2);
        }
        return 0;
    }

    @Override
    private int compare(Node n1, Node n2) {
        double m1 = this.measure(n1);
        double m2 = this.measure(n2);
        return Double.compare(m1, m2);
    }

    private double measure(Node node) {
        int sum = 0;
        int num = 0;
        List<Node> froms = this.getFromNodes(node);
        for (Node from : froms) {
            int index = this.datas.indexOf(from);
            if (index == -1) continue;
            sum += index;
            ++num;
        }
        return num > 0 ? (double)sum / (double)num : 0.0;
    }

    private List<Node> getFromNodes(Node node) {
        ArrayList<Node> nodes = new ArrayList<Node>();
        List links = node.getToLinks();
        if (links != null) {
            for (Link link : links) {
                nodes.add(link.getFromNode());
            }
        }
        return nodes;
    }
}

