/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.util;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.HashMap;
import java.util.Map;

public final class RecoveryOperationController {
    private static final Log logger = LogFactory.getInstance(RecoveryOperationController.class);
    private static final int IS_ALLOWED = 0;
    private static final int IS_FORBIDDEN = 1;
    private static final int IS_NA = 3;
    private static Map<String, Integer> operationStatusMap = new HashMap<String, Integer>();

    private RecoveryOperationController() {
    }

    public static void checkOperation(DrmEnumDefine.RecoveryPlanStatusE status, DrmEnumDefine.RecoveryPlanOperationType operation) {
        if (RecoveryOperationController.isForbidden(status, operation)) {
            throw new LegoCheckedException(1073948693L);
        }
    }

    public static boolean isForbidden(DrmEnumDefine.RecoveryPlanStatusE status, DrmEnumDefine.RecoveryPlanOperationType operation) {
        if (status == null || operation == null) {
            String errorMsg = "RecoveryPlan status or operation is null.";
            logger.error((Object)errorMsg);
            throw new LegoCheckedException(1073947393L, errorMsg);
        }
        String key = RecoveryOperationController.generateKey(status, operation);
        if (!operationStatusMap.containsKey(key)) {
            String errorMsg = "The RecoveryPlan status operation map is not configured:" + key;
            logger.error((Object)errorMsg);
            throw new LegoCheckedException(1073947393L, errorMsg);
        }
        return 0 != operationStatusMap.get(key);
    }

    private static String generateKey(DrmEnumDefine.RecoveryPlanStatusE status, DrmEnumDefine.RecoveryPlanOperationType operation) {
        return status.getValue() + ":" + operation.getValue();
    }

    static {
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.READY, DrmEnumDefine.RecoveryPlanOperationType.MODIFY_BASIC_INFO), 0);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.READY, DrmEnumDefine.RecoveryPlanOperationType.DELETE_RECOVERY_PLAN), 0);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.READY, DrmEnumDefine.RecoveryPlanOperationType.PLANED_MOTION), 0);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.READY, DrmEnumDefine.RecoveryPlanOperationType.HOT_MIGRATION), 0);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.READY, DrmEnumDefine.RecoveryPlanOperationType.DISASTER_RECOVERY), 0);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.READY, DrmEnumDefine.RecoveryPlanOperationType.DRILLING), 0);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.READY, DrmEnumDefine.RecoveryPlanOperationType.CLEAN_DRILLING), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.READY, DrmEnumDefine.RecoveryPlanOperationType.REPROTECT), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.READY, DrmEnumDefine.RecoveryPlanOperationType.SNAPSHOT_ROLLBACK), 0);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.READY, DrmEnumDefine.RecoveryPlanOperationType.MOIFY_RECOVERY_SETTING), 0);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.READY, DrmEnumDefine.RecoveryPlanOperationType.EDIT_RECOVERY_PROCESSOR), 0);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.READY, DrmEnumDefine.RecoveryPlanOperationType.SWAP), 0);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.TEST_RUNNING, DrmEnumDefine.RecoveryPlanOperationType.MODIFY_BASIC_INFO), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.TEST_RUNNING, DrmEnumDefine.RecoveryPlanOperationType.DELETE_RECOVERY_PLAN), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.TEST_RUNNING, DrmEnumDefine.RecoveryPlanOperationType.PLANED_MOTION), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.TEST_RUNNING, DrmEnumDefine.RecoveryPlanOperationType.DISASTER_RECOVERY), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.TEST_RUNNING, DrmEnumDefine.RecoveryPlanOperationType.DRILLING), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.TEST_RUNNING, DrmEnumDefine.RecoveryPlanOperationType.CLEAN_DRILLING), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.TEST_RUNNING, DrmEnumDefine.RecoveryPlanOperationType.REPROTECT), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.TEST_RUNNING, DrmEnumDefine.RecoveryPlanOperationType.SNAPSHOT_ROLLBACK), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.TEST_RUNNING, DrmEnumDefine.RecoveryPlanOperationType.MOIFY_RECOVERY_SETTING), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.TEST_RUNNING, DrmEnumDefine.RecoveryPlanOperationType.EDIT_RECOVERY_PROCESSOR), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.TEST_RUNNING, DrmEnumDefine.RecoveryPlanOperationType.SWAP), 3);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.TEST_FAILED, DrmEnumDefine.RecoveryPlanOperationType.MODIFY_BASIC_INFO), 0);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.TEST_FAILED, DrmEnumDefine.RecoveryPlanOperationType.DELETE_RECOVERY_PLAN), 0);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.TEST_FAILED, DrmEnumDefine.RecoveryPlanOperationType.PLANED_MOTION), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.TEST_FAILED, DrmEnumDefine.RecoveryPlanOperationType.DISASTER_RECOVERY), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.TEST_FAILED, DrmEnumDefine.RecoveryPlanOperationType.DRILLING), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.TEST_FAILED, DrmEnumDefine.RecoveryPlanOperationType.CLEAN_DRILLING), 0);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.TEST_FAILED, DrmEnumDefine.RecoveryPlanOperationType.REPROTECT), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.TEST_FAILED, DrmEnumDefine.RecoveryPlanOperationType.SNAPSHOT_ROLLBACK), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.TEST_FAILED, DrmEnumDefine.RecoveryPlanOperationType.MOIFY_RECOVERY_SETTING), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.TEST_FAILED, DrmEnumDefine.RecoveryPlanOperationType.EDIT_RECOVERY_PROCESSOR), 0);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.TEST_FAILED, DrmEnumDefine.RecoveryPlanOperationType.SWAP), 3);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.TEST_COMPLETED, DrmEnumDefine.RecoveryPlanOperationType.MODIFY_BASIC_INFO), 0);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.TEST_COMPLETED, DrmEnumDefine.RecoveryPlanOperationType.DELETE_RECOVERY_PLAN), 0);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.TEST_COMPLETED, DrmEnumDefine.RecoveryPlanOperationType.PLANED_MOTION), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.TEST_COMPLETED, DrmEnumDefine.RecoveryPlanOperationType.DISASTER_RECOVERY), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.TEST_COMPLETED, DrmEnumDefine.RecoveryPlanOperationType.DRILLING), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.TEST_COMPLETED, DrmEnumDefine.RecoveryPlanOperationType.CLEAN_DRILLING), 0);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.TEST_COMPLETED, DrmEnumDefine.RecoveryPlanOperationType.REPROTECT), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.TEST_COMPLETED, DrmEnumDefine.RecoveryPlanOperationType.SNAPSHOT_ROLLBACK), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.TEST_COMPLETED, DrmEnumDefine.RecoveryPlanOperationType.MOIFY_RECOVERY_SETTING), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.TEST_COMPLETED, DrmEnumDefine.RecoveryPlanOperationType.EDIT_RECOVERY_PROCESSOR), 0);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.TEST_COMPLETED, DrmEnumDefine.RecoveryPlanOperationType.SWAP), 3);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.PLANED_MOTION_RUNNING, DrmEnumDefine.RecoveryPlanOperationType.MODIFY_BASIC_INFO), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.PLANED_MOTION_RUNNING, DrmEnumDefine.RecoveryPlanOperationType.DELETE_RECOVERY_PLAN), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.PLANED_MOTION_RUNNING, DrmEnumDefine.RecoveryPlanOperationType.PLANED_MOTION), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.PLANED_MOTION_RUNNING, DrmEnumDefine.RecoveryPlanOperationType.DISASTER_RECOVERY), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.PLANED_MOTION_RUNNING, DrmEnumDefine.RecoveryPlanOperationType.DRILLING), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.PLANED_MOTION_RUNNING, DrmEnumDefine.RecoveryPlanOperationType.CLEAN_DRILLING), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.PLANED_MOTION_RUNNING, DrmEnumDefine.RecoveryPlanOperationType.REPROTECT), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.PLANED_MOTION_RUNNING, DrmEnumDefine.RecoveryPlanOperationType.SNAPSHOT_ROLLBACK), 3);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.PLANED_MOTION_RUNNING, DrmEnumDefine.RecoveryPlanOperationType.MOIFY_RECOVERY_SETTING), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.PLANED_MOTION_RUNNING, DrmEnumDefine.RecoveryPlanOperationType.EDIT_RECOVERY_PROCESSOR), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.PLANED_MOTION_RUNNING, DrmEnumDefine.RecoveryPlanOperationType.SWAP), 3);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.PLANED_MOTION_FAILED, DrmEnumDefine.RecoveryPlanOperationType.MODIFY_BASIC_INFO), 0);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.PLANED_MOTION_FAILED, DrmEnumDefine.RecoveryPlanOperationType.DELETE_RECOVERY_PLAN), 0);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.PLANED_MOTION_FAILED, DrmEnumDefine.RecoveryPlanOperationType.PLANED_MOTION), 0);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.PLANED_MOTION_FAILED, DrmEnumDefine.RecoveryPlanOperationType.DISASTER_RECOVERY), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.PLANED_MOTION_FAILED, DrmEnumDefine.RecoveryPlanOperationType.DRILLING), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.PLANED_MOTION_FAILED, DrmEnumDefine.RecoveryPlanOperationType.CLEAN_DRILLING), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.PLANED_MOTION_FAILED, DrmEnumDefine.RecoveryPlanOperationType.REPROTECT), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.PLANED_MOTION_FAILED, DrmEnumDefine.RecoveryPlanOperationType.SNAPSHOT_ROLLBACK), 3);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.PLANED_MOTION_FAILED, DrmEnumDefine.RecoveryPlanOperationType.MOIFY_RECOVERY_SETTING), 0);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.PLANED_MOTION_FAILED, DrmEnumDefine.RecoveryPlanOperationType.EDIT_RECOVERY_PROCESSOR), 0);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.PLANED_MOTION_FAILED, DrmEnumDefine.RecoveryPlanOperationType.SWAP), 3);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.HOT_MIGRATION_FAILED, DrmEnumDefine.RecoveryPlanOperationType.HOT_MIGRATION), 0);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.HOT_MIGRATION_FAILED, DrmEnumDefine.RecoveryPlanOperationType.PLANED_MOTION), 0);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.HOT_MIGRATION_FAILED, DrmEnumDefine.RecoveryPlanOperationType.DELETE_RECOVERY_PLAN), 0);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.PLANED_MOTION_COMPLETED, DrmEnumDefine.RecoveryPlanOperationType.MODIFY_BASIC_INFO), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.PLANED_MOTION_COMPLETED, DrmEnumDefine.RecoveryPlanOperationType.DELETE_RECOVERY_PLAN), 0);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.PLANED_MOTION_COMPLETED, DrmEnumDefine.RecoveryPlanOperationType.PLANED_MOTION), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.PLANED_MOTION_COMPLETED, DrmEnumDefine.RecoveryPlanOperationType.DISASTER_RECOVERY), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.PLANED_MOTION_COMPLETED, DrmEnumDefine.RecoveryPlanOperationType.DRILLING), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.PLANED_MOTION_COMPLETED, DrmEnumDefine.RecoveryPlanOperationType.CLEAN_DRILLING), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.PLANED_MOTION_COMPLETED, DrmEnumDefine.RecoveryPlanOperationType.REPROTECT), 0);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.PLANED_MOTION_COMPLETED, DrmEnumDefine.RecoveryPlanOperationType.SNAPSHOT_ROLLBACK), 3);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.PLANED_MOTION_COMPLETED, DrmEnumDefine.RecoveryPlanOperationType.MOIFY_RECOVERY_SETTING), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.PLANED_MOTION_COMPLETED, DrmEnumDefine.RecoveryPlanOperationType.EDIT_RECOVERY_PROCESSOR), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.PLANED_MOTION_COMPLETED, DrmEnumDefine.RecoveryPlanOperationType.SWAP), 3);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.PLANED_MOTION_PAUSED, DrmEnumDefine.RecoveryPlanOperationType.PLANED_MOTION), 0);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.DISASTER_RECOVERY_PAUSED, DrmEnumDefine.RecoveryPlanOperationType.DISASTER_RECOVERY), 0);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.DISASTER_RECOVERY_RUNNING, DrmEnumDefine.RecoveryPlanOperationType.MODIFY_BASIC_INFO), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.DISASTER_RECOVERY_RUNNING, DrmEnumDefine.RecoveryPlanOperationType.DELETE_RECOVERY_PLAN), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.DISASTER_RECOVERY_RUNNING, DrmEnumDefine.RecoveryPlanOperationType.PLANED_MOTION), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.DISASTER_RECOVERY_RUNNING, DrmEnumDefine.RecoveryPlanOperationType.DISASTER_RECOVERY), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.DISASTER_RECOVERY_RUNNING, DrmEnumDefine.RecoveryPlanOperationType.DRILLING), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.DISASTER_RECOVERY_RUNNING, DrmEnumDefine.RecoveryPlanOperationType.CLEAN_DRILLING), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.DISASTER_RECOVERY_RUNNING, DrmEnumDefine.RecoveryPlanOperationType.REPROTECT), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.DISASTER_RECOVERY_RUNNING, DrmEnumDefine.RecoveryPlanOperationType.SNAPSHOT_ROLLBACK), 3);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.DISASTER_RECOVERY_RUNNING, DrmEnumDefine.RecoveryPlanOperationType.MOIFY_RECOVERY_SETTING), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.DISASTER_RECOVERY_RUNNING, DrmEnumDefine.RecoveryPlanOperationType.EDIT_RECOVERY_PROCESSOR), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.DISASTER_RECOVERY_RUNNING, DrmEnumDefine.RecoveryPlanOperationType.SWAP), 3);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.DISASTER_RECOVERY_FAILED, DrmEnumDefine.RecoveryPlanOperationType.MODIFY_BASIC_INFO), 0);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.DISASTER_RECOVERY_FAILED, DrmEnumDefine.RecoveryPlanOperationType.DELETE_RECOVERY_PLAN), 0);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.DISASTER_RECOVERY_FAILED, DrmEnumDefine.RecoveryPlanOperationType.PLANED_MOTION), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.DISASTER_RECOVERY_FAILED, DrmEnumDefine.RecoveryPlanOperationType.DISASTER_RECOVERY), 0);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.DISASTER_RECOVERY_FAILED, DrmEnumDefine.RecoveryPlanOperationType.DRILLING), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.DISASTER_RECOVERY_FAILED, DrmEnumDefine.RecoveryPlanOperationType.CLEAN_DRILLING), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.DISASTER_RECOVERY_FAILED, DrmEnumDefine.RecoveryPlanOperationType.REPROTECT), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.DISASTER_RECOVERY_FAILED, DrmEnumDefine.RecoveryPlanOperationType.SNAPSHOT_ROLLBACK), 3);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.DISASTER_RECOVERY_FAILED, DrmEnumDefine.RecoveryPlanOperationType.MOIFY_RECOVERY_SETTING), 0);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.DISASTER_RECOVERY_FAILED, DrmEnumDefine.RecoveryPlanOperationType.EDIT_RECOVERY_PROCESSOR), 0);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.DISASTER_RECOVERY_FAILED, DrmEnumDefine.RecoveryPlanOperationType.SWAP), 3);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.DISASTER_RECOVERY_COMPLETED, DrmEnumDefine.RecoveryPlanOperationType.MODIFY_BASIC_INFO), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.DISASTER_RECOVERY_COMPLETED, DrmEnumDefine.RecoveryPlanOperationType.DELETE_RECOVERY_PLAN), 0);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.DISASTER_RECOVERY_COMPLETED, DrmEnumDefine.RecoveryPlanOperationType.PLANED_MOTION), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.DISASTER_RECOVERY_COMPLETED, DrmEnumDefine.RecoveryPlanOperationType.DISASTER_RECOVERY), 0);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.DISASTER_RECOVERY_COMPLETED, DrmEnumDefine.RecoveryPlanOperationType.DRILLING), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.DISASTER_RECOVERY_COMPLETED, DrmEnumDefine.RecoveryPlanOperationType.CLEAN_DRILLING), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.DISASTER_RECOVERY_COMPLETED, DrmEnumDefine.RecoveryPlanOperationType.REPROTECT), 0);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.DISASTER_RECOVERY_COMPLETED, DrmEnumDefine.RecoveryPlanOperationType.SNAPSHOT_ROLLBACK), 3);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.DISASTER_RECOVERY_COMPLETED, DrmEnumDefine.RecoveryPlanOperationType.MOIFY_RECOVERY_SETTING), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.DISASTER_RECOVERY_COMPLETED, DrmEnumDefine.RecoveryPlanOperationType.EDIT_RECOVERY_PROCESSOR), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.DISASTER_RECOVERY_COMPLETED, DrmEnumDefine.RecoveryPlanOperationType.SWAP), 3);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.REPROTECT_RUNNING, DrmEnumDefine.RecoveryPlanOperationType.MODIFY_BASIC_INFO), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.REPROTECT_RUNNING, DrmEnumDefine.RecoveryPlanOperationType.DELETE_RECOVERY_PLAN), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.REPROTECT_RUNNING, DrmEnumDefine.RecoveryPlanOperationType.PLANED_MOTION), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.REPROTECT_RUNNING, DrmEnumDefine.RecoveryPlanOperationType.DISASTER_RECOVERY), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.REPROTECT_RUNNING, DrmEnumDefine.RecoveryPlanOperationType.DRILLING), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.REPROTECT_RUNNING, DrmEnumDefine.RecoveryPlanOperationType.CLEAN_DRILLING), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.REPROTECT_RUNNING, DrmEnumDefine.RecoveryPlanOperationType.REPROTECT), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.REPROTECT_RUNNING, DrmEnumDefine.RecoveryPlanOperationType.SNAPSHOT_ROLLBACK), 3);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.REPROTECT_RUNNING, DrmEnumDefine.RecoveryPlanOperationType.MOIFY_RECOVERY_SETTING), 0);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.REPROTECT_RUNNING, DrmEnumDefine.RecoveryPlanOperationType.EDIT_RECOVERY_PROCESSOR), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.REPROTECT_RUNNING, DrmEnumDefine.RecoveryPlanOperationType.SWAP), 3);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.REPROTECT_FAILED, DrmEnumDefine.RecoveryPlanOperationType.MODIFY_BASIC_INFO), 0);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.REPROTECT_FAILED, DrmEnumDefine.RecoveryPlanOperationType.DELETE_RECOVERY_PLAN), 0);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.REPROTECT_FAILED, DrmEnumDefine.RecoveryPlanOperationType.PLANED_MOTION), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.REPROTECT_FAILED, DrmEnumDefine.RecoveryPlanOperationType.DISASTER_RECOVERY), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.REPROTECT_FAILED, DrmEnumDefine.RecoveryPlanOperationType.DRILLING), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.REPROTECT_FAILED, DrmEnumDefine.RecoveryPlanOperationType.CLEAN_DRILLING), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.REPROTECT_FAILED, DrmEnumDefine.RecoveryPlanOperationType.REPROTECT), 0);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.REPROTECT_FAILED, DrmEnumDefine.RecoveryPlanOperationType.SNAPSHOT_ROLLBACK), 3);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.REPROTECT_FAILED, DrmEnumDefine.RecoveryPlanOperationType.MOIFY_RECOVERY_SETTING), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.REPROTECT_FAILED, DrmEnumDefine.RecoveryPlanOperationType.EDIT_RECOVERY_PROCESSOR), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.REPROTECT_FAILED, DrmEnumDefine.RecoveryPlanOperationType.SWAP), 3);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.REPROTECT_COMPLETED, DrmEnumDefine.RecoveryPlanOperationType.MODIFY_BASIC_INFO), 0);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.REPROTECT_COMPLETED, DrmEnumDefine.RecoveryPlanOperationType.DELETE_RECOVERY_PLAN), 0);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.REPROTECT_COMPLETED, DrmEnumDefine.RecoveryPlanOperationType.PLANED_MOTION), 0);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.REPROTECT_COMPLETED, DrmEnumDefine.RecoveryPlanOperationType.HOT_MIGRATION), 0);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.REPROTECT_COMPLETED, DrmEnumDefine.RecoveryPlanOperationType.DISASTER_RECOVERY), 0);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.REPROTECT_COMPLETED, DrmEnumDefine.RecoveryPlanOperationType.DRILLING), 0);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.REPROTECT_COMPLETED, DrmEnumDefine.RecoveryPlanOperationType.CLEAN_DRILLING), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.REPROTECT_COMPLETED, DrmEnumDefine.RecoveryPlanOperationType.REPROTECT), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.REPROTECT_COMPLETED, DrmEnumDefine.RecoveryPlanOperationType.SNAPSHOT_ROLLBACK), 0);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.REPROTECT_COMPLETED, DrmEnumDefine.RecoveryPlanOperationType.MOIFY_RECOVERY_SETTING), 0);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.REPROTECT_COMPLETED, DrmEnumDefine.RecoveryPlanOperationType.EDIT_RECOVERY_PROCESSOR), 0);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.REPROTECT_COMPLETED, DrmEnumDefine.RecoveryPlanOperationType.SWAP), 3);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.CLEAN_RUNNING, DrmEnumDefine.RecoveryPlanOperationType.MODIFY_BASIC_INFO), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.CLEAN_RUNNING, DrmEnumDefine.RecoveryPlanOperationType.DELETE_RECOVERY_PLAN), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.CLEAN_RUNNING, DrmEnumDefine.RecoveryPlanOperationType.PLANED_MOTION), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.CLEAN_RUNNING, DrmEnumDefine.RecoveryPlanOperationType.DISASTER_RECOVERY), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.CLEAN_RUNNING, DrmEnumDefine.RecoveryPlanOperationType.DRILLING), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.CLEAN_RUNNING, DrmEnumDefine.RecoveryPlanOperationType.CLEAN_DRILLING), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.CLEAN_RUNNING, DrmEnumDefine.RecoveryPlanOperationType.REPROTECT), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.CLEAN_RUNNING, DrmEnumDefine.RecoveryPlanOperationType.SNAPSHOT_ROLLBACK), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.CLEAN_RUNNING, DrmEnumDefine.RecoveryPlanOperationType.MOIFY_RECOVERY_SETTING), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.CLEAN_RUNNING, DrmEnumDefine.RecoveryPlanOperationType.EDIT_RECOVERY_PROCESSOR), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.CLEAN_RUNNING, DrmEnumDefine.RecoveryPlanOperationType.SWAP), 3);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.CLEAN_FAILED, DrmEnumDefine.RecoveryPlanOperationType.MODIFY_BASIC_INFO), 0);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.CLEAN_FAILED, DrmEnumDefine.RecoveryPlanOperationType.DELETE_RECOVERY_PLAN), 0);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.CLEAN_FAILED, DrmEnumDefine.RecoveryPlanOperationType.PLANED_MOTION), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.CLEAN_FAILED, DrmEnumDefine.RecoveryPlanOperationType.DISASTER_RECOVERY), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.CLEAN_FAILED, DrmEnumDefine.RecoveryPlanOperationType.DRILLING), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.CLEAN_FAILED, DrmEnumDefine.RecoveryPlanOperationType.CLEAN_DRILLING), 0);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.CLEAN_FAILED, DrmEnumDefine.RecoveryPlanOperationType.REPROTECT), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.CLEAN_FAILED, DrmEnumDefine.RecoveryPlanOperationType.SNAPSHOT_ROLLBACK), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.CLEAN_FAILED, DrmEnumDefine.RecoveryPlanOperationType.MOIFY_RECOVERY_SETTING), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.CLEAN_FAILED, DrmEnumDefine.RecoveryPlanOperationType.EDIT_RECOVERY_PROCESSOR), 0);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.CLEAN_FAILED, DrmEnumDefine.RecoveryPlanOperationType.SWAP), 3);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.CLEAN_COMPLETED, DrmEnumDefine.RecoveryPlanOperationType.MODIFY_BASIC_INFO), 0);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.CLEAN_COMPLETED, DrmEnumDefine.RecoveryPlanOperationType.DELETE_RECOVERY_PLAN), 0);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.CLEAN_COMPLETED, DrmEnumDefine.RecoveryPlanOperationType.PLANED_MOTION), 0);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.CLEAN_COMPLETED, DrmEnumDefine.RecoveryPlanOperationType.DISASTER_RECOVERY), 0);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.CLEAN_COMPLETED, DrmEnumDefine.RecoveryPlanOperationType.DRILLING), 0);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.CLEAN_COMPLETED, DrmEnumDefine.RecoveryPlanOperationType.CLEAN_DRILLING), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.CLEAN_COMPLETED, DrmEnumDefine.RecoveryPlanOperationType.REPROTECT), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.CLEAN_COMPLETED, DrmEnumDefine.RecoveryPlanOperationType.SNAPSHOT_ROLLBACK), 0);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.CLEAN_COMPLETED, DrmEnumDefine.RecoveryPlanOperationType.MOIFY_RECOVERY_SETTING), 0);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.CLEAN_COMPLETED, DrmEnumDefine.RecoveryPlanOperationType.EDIT_RECOVERY_PROCESSOR), 0);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.CLEAN_COMPLETED, DrmEnumDefine.RecoveryPlanOperationType.SWAP), 3);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.CLEAN_COMPLETED, DrmEnumDefine.RecoveryPlanOperationType.HOT_MIGRATION), 0);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.ROLLBACK_RUNNING, DrmEnumDefine.RecoveryPlanOperationType.MODIFY_BASIC_INFO), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.ROLLBACK_RUNNING, DrmEnumDefine.RecoveryPlanOperationType.DELETE_RECOVERY_PLAN), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.ROLLBACK_RUNNING, DrmEnumDefine.RecoveryPlanOperationType.PLANED_MOTION), 3);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.ROLLBACK_RUNNING, DrmEnumDefine.RecoveryPlanOperationType.DISASTER_RECOVERY), 3);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.ROLLBACK_RUNNING, DrmEnumDefine.RecoveryPlanOperationType.DRILLING), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.ROLLBACK_RUNNING, DrmEnumDefine.RecoveryPlanOperationType.CLEAN_DRILLING), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.ROLLBACK_RUNNING, DrmEnumDefine.RecoveryPlanOperationType.REPROTECT), 3);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.ROLLBACK_RUNNING, DrmEnumDefine.RecoveryPlanOperationType.SNAPSHOT_ROLLBACK), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.ROLLBACK_RUNNING, DrmEnumDefine.RecoveryPlanOperationType.MOIFY_RECOVERY_SETTING), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.ROLLBACK_RUNNING, DrmEnumDefine.RecoveryPlanOperationType.EDIT_RECOVERY_PROCESSOR), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.ROLLBACK_RUNNING, DrmEnumDefine.RecoveryPlanOperationType.SWAP), 3);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.ROLLBACK_FAILED, DrmEnumDefine.RecoveryPlanOperationType.MODIFY_BASIC_INFO), 0);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.ROLLBACK_FAILED, DrmEnumDefine.RecoveryPlanOperationType.DELETE_RECOVERY_PLAN), 0);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.ROLLBACK_FAILED, DrmEnumDefine.RecoveryPlanOperationType.PLANED_MOTION), 0);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.ROLLBACK_FAILED, DrmEnumDefine.RecoveryPlanOperationType.DISASTER_RECOVERY), 0);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.ROLLBACK_FAILED, DrmEnumDefine.RecoveryPlanOperationType.DRILLING), 0);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.ROLLBACK_FAILED, DrmEnumDefine.RecoveryPlanOperationType.CLEAN_DRILLING), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.ROLLBACK_FAILED, DrmEnumDefine.RecoveryPlanOperationType.REPROTECT), 3);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.ROLLBACK_FAILED, DrmEnumDefine.RecoveryPlanOperationType.SNAPSHOT_ROLLBACK), 0);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.ROLLBACK_FAILED, DrmEnumDefine.RecoveryPlanOperationType.MOIFY_RECOVERY_SETTING), 0);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.ROLLBACK_FAILED, DrmEnumDefine.RecoveryPlanOperationType.EDIT_RECOVERY_PROCESSOR), 0);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.ROLLBACK_FAILED, DrmEnumDefine.RecoveryPlanOperationType.SWAP), 3);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.ROLLBACK_COMPLETED, DrmEnumDefine.RecoveryPlanOperationType.MODIFY_BASIC_INFO), 0);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.ROLLBACK_COMPLETED, DrmEnumDefine.RecoveryPlanOperationType.DELETE_RECOVERY_PLAN), 0);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.ROLLBACK_COMPLETED, DrmEnumDefine.RecoveryPlanOperationType.PLANED_MOTION), 0);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.ROLLBACK_COMPLETED, DrmEnumDefine.RecoveryPlanOperationType.DISASTER_RECOVERY), 0);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.ROLLBACK_COMPLETED, DrmEnumDefine.RecoveryPlanOperationType.DRILLING), 0);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.ROLLBACK_COMPLETED, DrmEnumDefine.RecoveryPlanOperationType.CLEAN_DRILLING), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.ROLLBACK_COMPLETED, DrmEnumDefine.RecoveryPlanOperationType.REPROTECT), 3);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.ROLLBACK_COMPLETED, DrmEnumDefine.RecoveryPlanOperationType.SNAPSHOT_ROLLBACK), 0);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.ROLLBACK_COMPLETED, DrmEnumDefine.RecoveryPlanOperationType.MOIFY_RECOVERY_SETTING), 0);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.ROLLBACK_COMPLETED, DrmEnumDefine.RecoveryPlanOperationType.EDIT_RECOVERY_PROCESSOR), 0);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.ROLLBACK_COMPLETED, DrmEnumDefine.RecoveryPlanOperationType.SWAP), 3);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.SWAP_RUNNING, DrmEnumDefine.RecoveryPlanOperationType.MODIFY_BASIC_INFO), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.SWAP_RUNNING, DrmEnumDefine.RecoveryPlanOperationType.DELETE_RECOVERY_PLAN), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.SWAP_RUNNING, DrmEnumDefine.RecoveryPlanOperationType.PLANED_MOTION), 3);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.SWAP_RUNNING, DrmEnumDefine.RecoveryPlanOperationType.DISASTER_RECOVERY), 3);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.SWAP_RUNNING, DrmEnumDefine.RecoveryPlanOperationType.DRILLING), 3);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.SWAP_RUNNING, DrmEnumDefine.RecoveryPlanOperationType.CLEAN_DRILLING), 3);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.SWAP_RUNNING, DrmEnumDefine.RecoveryPlanOperationType.REPROTECT), 3);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.SWAP_RUNNING, DrmEnumDefine.RecoveryPlanOperationType.SNAPSHOT_ROLLBACK), 3);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.SWAP_RUNNING, DrmEnumDefine.RecoveryPlanOperationType.MOIFY_RECOVERY_SETTING), 3);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.SWAP_RUNNING, DrmEnumDefine.RecoveryPlanOperationType.EDIT_RECOVERY_PROCESSOR), 3);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.SWAP_RUNNING, DrmEnumDefine.RecoveryPlanOperationType.SWAP), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.SWAP_FAILED, DrmEnumDefine.RecoveryPlanOperationType.MODIFY_BASIC_INFO), 0);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.SWAP_FAILED, DrmEnumDefine.RecoveryPlanOperationType.DELETE_RECOVERY_PLAN), 0);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.SWAP_FAILED, DrmEnumDefine.RecoveryPlanOperationType.PLANED_MOTION), 3);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.SWAP_FAILED, DrmEnumDefine.RecoveryPlanOperationType.DISASTER_RECOVERY), 3);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.SWAP_FAILED, DrmEnumDefine.RecoveryPlanOperationType.DRILLING), 3);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.SWAP_FAILED, DrmEnumDefine.RecoveryPlanOperationType.CLEAN_DRILLING), 3);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.SWAP_FAILED, DrmEnumDefine.RecoveryPlanOperationType.REPROTECT), 3);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.SWAP_FAILED, DrmEnumDefine.RecoveryPlanOperationType.SNAPSHOT_ROLLBACK), 3);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.SWAP_FAILED, DrmEnumDefine.RecoveryPlanOperationType.MOIFY_RECOVERY_SETTING), 3);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.SWAP_FAILED, DrmEnumDefine.RecoveryPlanOperationType.EDIT_RECOVERY_PROCESSOR), 3);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.SWAP_FAILED, DrmEnumDefine.RecoveryPlanOperationType.SWAP), 0);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.READY, DrmEnumDefine.RecoveryPlanOperationType.MOUNT_REPLICA), 0);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.UMOUNT_COMPLETED, DrmEnumDefine.RecoveryPlanOperationType.MOUNT_REPLICA), 0);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.MOUNTING_REPLICA, DrmEnumDefine.RecoveryPlanOperationType.MOUNT_REPLICA), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.UMOUNT_FAILED, DrmEnumDefine.RecoveryPlanOperationType.MOUNT_REPLICA), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.UMOUNTING_REPLICA, DrmEnumDefine.RecoveryPlanOperationType.MOUNT_REPLICA), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.MOUNT_FAILED, DrmEnumDefine.RecoveryPlanOperationType.MOUNT_REPLICA), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.MOUNT_FAILED, DrmEnumDefine.RecoveryPlanOperationType.UMOUNT_REPLICA), 0);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.UMOUNT_FAILED, DrmEnumDefine.RecoveryPlanOperationType.UMOUNT_REPLICA), 0);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.MOUNT_COMPLETED, DrmEnumDefine.RecoveryPlanOperationType.UMOUNT_REPLICA), 0);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.READY, DrmEnumDefine.RecoveryPlanOperationType.UMOUNT_REPLICA), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.MOUNTING_REPLICA, DrmEnumDefine.RecoveryPlanOperationType.UMOUNT_REPLICA), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.UMOUNTING_REPLICA, DrmEnumDefine.RecoveryPlanOperationType.UMOUNT_REPLICA), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.MOUNT_FAILED, DrmEnumDefine.RecoveryPlanOperationType.DELETE_RECOVERY_PLAN), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.MOUNT_COMPLETED, DrmEnumDefine.RecoveryPlanOperationType.EDIT_RECOVERY_PROCESSOR), 0);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.UMOUNT_COMPLETED, DrmEnumDefine.RecoveryPlanOperationType.EDIT_RECOVERY_PROCESSOR), 0);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.UMOUNT_COMPLETED, DrmEnumDefine.RecoveryPlanOperationType.DELETE_RECOVERY_PLAN), 0);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.UMOUNT_FAILED, DrmEnumDefine.RecoveryPlanOperationType.DELETE_RECOVERY_PLAN), 0);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.MOUNTING_REPLICA, DrmEnumDefine.RecoveryPlanOperationType.EDIT_RECOVERY_PROCESSOR), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.MOUNT_FAILED, DrmEnumDefine.RecoveryPlanOperationType.EDIT_RECOVERY_PROCESSOR), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.UMOUNTING_REPLICA, DrmEnumDefine.RecoveryPlanOperationType.EDIT_RECOVERY_PROCESSOR), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.UMOUNT_FAILED, DrmEnumDefine.RecoveryPlanOperationType.EDIT_RECOVERY_PROCESSOR), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.READY, DrmEnumDefine.RecoveryPlanOperationType.MOIFY_RECOVERY_SETTING), 0);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.UMOUNT_COMPLETED, DrmEnumDefine.RecoveryPlanOperationType.MOIFY_RECOVERY_SETTING), 0);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.MOUNTING_REPLICA, DrmEnumDefine.RecoveryPlanOperationType.MOIFY_RECOVERY_SETTING), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.UMOUNTING_REPLICA, DrmEnumDefine.RecoveryPlanOperationType.MOIFY_RECOVERY_SETTING), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.MOUNT_FAILED, DrmEnumDefine.RecoveryPlanOperationType.MOIFY_RECOVERY_SETTING), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.MOUNT_COMPLETED, DrmEnumDefine.RecoveryPlanOperationType.MOIFY_RECOVERY_SETTING), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.UMOUNT_FAILED, DrmEnumDefine.RecoveryPlanOperationType.MOIFY_RECOVERY_SETTING), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.READY, DrmEnumDefine.RecoveryPlanOperationType.VM_ROLLBACK), 0);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.TEST_RUNNING, DrmEnumDefine.RecoveryPlanOperationType.VM_ROLLBACK), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.TEST_FAILED, DrmEnumDefine.RecoveryPlanOperationType.VM_ROLLBACK), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.TEST_COMPLETED, DrmEnumDefine.RecoveryPlanOperationType.VM_ROLLBACK), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.PLANED_MOTION_RUNNING, DrmEnumDefine.RecoveryPlanOperationType.VM_ROLLBACK), 3);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.PLANED_MOTION_FAILED, DrmEnumDefine.RecoveryPlanOperationType.VM_ROLLBACK), 3);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.PLANED_MOTION_COMPLETED, DrmEnumDefine.RecoveryPlanOperationType.VM_ROLLBACK), 3);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.DISASTER_RECOVERY_RUNNING, DrmEnumDefine.RecoveryPlanOperationType.VM_ROLLBACK), 3);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.DISASTER_RECOVERY_FAILED, DrmEnumDefine.RecoveryPlanOperationType.VM_ROLLBACK), 3);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.DISASTER_RECOVERY_COMPLETED, DrmEnumDefine.RecoveryPlanOperationType.VM_ROLLBACK), 3);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.REPROTECT_RUNNING, DrmEnumDefine.RecoveryPlanOperationType.VM_ROLLBACK), 3);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.REPROTECT_FAILED, DrmEnumDefine.RecoveryPlanOperationType.VM_ROLLBACK), 3);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.REPROTECT_COMPLETED, DrmEnumDefine.RecoveryPlanOperationType.VM_ROLLBACK), 0);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.CLEAN_RUNNING, DrmEnumDefine.RecoveryPlanOperationType.VM_ROLLBACK), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.CLEAN_FAILED, DrmEnumDefine.RecoveryPlanOperationType.VM_ROLLBACK), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.CLEAN_COMPLETED, DrmEnumDefine.RecoveryPlanOperationType.VM_ROLLBACK), 0);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.ROLLBACK_RUNNING, DrmEnumDefine.RecoveryPlanOperationType.VM_ROLLBACK), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.ROLLBACK_FAILED, DrmEnumDefine.RecoveryPlanOperationType.VM_ROLLBACK), 0);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.ROLLBACK_COMPLETED, DrmEnumDefine.RecoveryPlanOperationType.VM_ROLLBACK), 0);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.SWAP_RUNNING, DrmEnumDefine.RecoveryPlanOperationType.VM_ROLLBACK), 3);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.SWAP_FAILED, DrmEnumDefine.RecoveryPlanOperationType.VM_ROLLBACK), 3);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.VM_ROLLBACK_RUNNING, DrmEnumDefine.RecoveryPlanOperationType.MODIFY_BASIC_INFO), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.VM_ROLLBACK_RUNNING, DrmEnumDefine.RecoveryPlanOperationType.DELETE_RECOVERY_PLAN), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.VM_ROLLBACK_RUNNING, DrmEnumDefine.RecoveryPlanOperationType.PLANED_MOTION), 3);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.VM_ROLLBACK_RUNNING, DrmEnumDefine.RecoveryPlanOperationType.DISASTER_RECOVERY), 3);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.VM_ROLLBACK_RUNNING, DrmEnumDefine.RecoveryPlanOperationType.DRILLING), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.VM_ROLLBACK_RUNNING, DrmEnumDefine.RecoveryPlanOperationType.CLEAN_DRILLING), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.VM_ROLLBACK_RUNNING, DrmEnumDefine.RecoveryPlanOperationType.REPROTECT), 3);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.VM_ROLLBACK_RUNNING, DrmEnumDefine.RecoveryPlanOperationType.SNAPSHOT_ROLLBACK), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.VM_ROLLBACK_RUNNING, DrmEnumDefine.RecoveryPlanOperationType.VM_ROLLBACK), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.VM_ROLLBACK_RUNNING, DrmEnumDefine.RecoveryPlanOperationType.MOIFY_RECOVERY_SETTING), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.VM_ROLLBACK_RUNNING, DrmEnumDefine.RecoveryPlanOperationType.EDIT_RECOVERY_PROCESSOR), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.VM_ROLLBACK_RUNNING, DrmEnumDefine.RecoveryPlanOperationType.SWAP), 3);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.VM_ROLLBACK_FAILED, DrmEnumDefine.RecoveryPlanOperationType.MODIFY_BASIC_INFO), 0);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.VM_ROLLBACK_FAILED, DrmEnumDefine.RecoveryPlanOperationType.DELETE_RECOVERY_PLAN), 0);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.VM_ROLLBACK_FAILED, DrmEnumDefine.RecoveryPlanOperationType.PLANED_MOTION), 0);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.VM_ROLLBACK_FAILED, DrmEnumDefine.RecoveryPlanOperationType.DISASTER_RECOVERY), 0);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.VM_ROLLBACK_FAILED, DrmEnumDefine.RecoveryPlanOperationType.DRILLING), 0);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.VM_ROLLBACK_FAILED, DrmEnumDefine.RecoveryPlanOperationType.CLEAN_DRILLING), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.VM_ROLLBACK_FAILED, DrmEnumDefine.RecoveryPlanOperationType.REPROTECT), 3);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.VM_ROLLBACK_FAILED, DrmEnumDefine.RecoveryPlanOperationType.SNAPSHOT_ROLLBACK), 0);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.VM_ROLLBACK_FAILED, DrmEnumDefine.RecoveryPlanOperationType.VM_ROLLBACK), 0);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.VM_ROLLBACK_FAILED, DrmEnumDefine.RecoveryPlanOperationType.MOIFY_RECOVERY_SETTING), 0);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.VM_ROLLBACK_FAILED, DrmEnumDefine.RecoveryPlanOperationType.EDIT_RECOVERY_PROCESSOR), 0);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.VM_ROLLBACK_FAILED, DrmEnumDefine.RecoveryPlanOperationType.SWAP), 3);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.VM_ROLLBACK_COMPLETED, DrmEnumDefine.RecoveryPlanOperationType.MODIFY_BASIC_INFO), 0);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.VM_ROLLBACK_COMPLETED, DrmEnumDefine.RecoveryPlanOperationType.DELETE_RECOVERY_PLAN), 0);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.VM_ROLLBACK_COMPLETED, DrmEnumDefine.RecoveryPlanOperationType.PLANED_MOTION), 0);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.VM_ROLLBACK_COMPLETED, DrmEnumDefine.RecoveryPlanOperationType.DISASTER_RECOVERY), 0);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.VM_ROLLBACK_COMPLETED, DrmEnumDefine.RecoveryPlanOperationType.DRILLING), 0);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.VM_ROLLBACK_COMPLETED, DrmEnumDefine.RecoveryPlanOperationType.CLEAN_DRILLING), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.VM_ROLLBACK_COMPLETED, DrmEnumDefine.RecoveryPlanOperationType.REPROTECT), 3);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.VM_ROLLBACK_COMPLETED, DrmEnumDefine.RecoveryPlanOperationType.SNAPSHOT_ROLLBACK), 0);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.VM_ROLLBACK_COMPLETED, DrmEnumDefine.RecoveryPlanOperationType.VM_ROLLBACK), 0);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.VM_ROLLBACK_COMPLETED, DrmEnumDefine.RecoveryPlanOperationType.MOIFY_RECOVERY_SETTING), 0);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.VM_ROLLBACK_COMPLETED, DrmEnumDefine.RecoveryPlanOperationType.EDIT_RECOVERY_PROCESSOR), 0);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RecoveryPlanStatusE.VM_ROLLBACK_COMPLETED, DrmEnumDefine.RecoveryPlanOperationType.SWAP), 3);
    }
}

