/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.kube.discovery.process;

import com.huawei.ism.cbb.base.poll.IPoller;
import com.huawei.ism.cbb.discover.framework.AbstractContext;
import com.huawei.ism.cbb.discover.framework.CommonTemplate;
import com.huawei.ism.cbb.discover.framework.CommonTemplateManager;
import com.huawei.ism.cbb.discover.framework.IProcessor;
import com.huawei.ism.cbb.discover.poll.DevicePoller;
import com.huawei.ism.cbb.discover.poll.PingPoller;
import com.huawei.ism.cbb.discover.poll.PollControllerLocator;
import com.huawei.ism.drm.kube.sdk.model.KubernetesNE;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;

public class KubePollProcessor
implements IProcessor {
    private static final Log LOG = LogFactory.getInstance(KubePollProcessor.class);

    public boolean process(AbstractContext context) {
        LOG.info((Object)"[kubernetes]KubePollProcessor start, server ip: %s", new Object[]{context.getAttribute("kubeServerIp")});
        KubernetesNE kubernetesNE = (KubernetesNE)context.getAttribute("StorageDevice", KubernetesNE.class);
        CommonTemplate pollTemplate = CommonTemplateManager.getInstance().getPollTemplateByDeviceType("Kube");
        PollControllerLocator.getInstance().getPollController().addPoller((IPoller)new DevicePoller(kubernetesNE.getSn(), "Kube", pollTemplate), 600, 1800);
        CommonTemplate pingTemplate = CommonTemplateManager.getInstance().getPingTemplateByDeviceType("Kube");
        PollControllerLocator.getInstance().getPingController().addPoller((IPoller)new PingPoller(kubernetesNE.getSn(), "Kube", pingTemplate));
        LOG.info((Object)"[kubernetes]KubePollProcessor end, server ip: %s", new Object[]{context.getAttribute("kubeServerIp")});
        return true;
    }

    public void postProcess(AbstractContext abstractContext) {
    }

    public void clean(AbstractContext abstractContext) {
    }
}

