/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.kube.discovery.process;

import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.discover.framework.AbstractContext;
import com.huawei.ism.cbb.discover.framework.IProcessor;
import com.huawei.ism.drm.kube.discovery.util.ProcessorUtil;
import com.huawei.ism.drm.kube.sdk.model.KubeStorage;
import com.huawei.ism.drm.kube.sdk.model.KubernetesNE;
import com.huawei.ism.drm.kube.service.IKubeService;
import com.huawei.ism.drm.kube.service.impl.KubeServiceImpl;
import com.huawei.ism.drm.kube.utils.KubeRefreshResourceUtils;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;

public class KubeSaveProcessor
implements IProcessor {
    private static final Log LOGGER = LogFactory.getInstance(KubeSaveProcessor.class);
    private final IKubeService kubeService = new KubeServiceImpl();

    public boolean process(AbstractContext context) {
        KubernetesNE kubernetesNE;
        Object kubeStoragesObj;
        KubernetesNE networkEntity = ProcessorUtil.getKubeNe(context);
        LOGGER.info((Object)"[kubernetes]KubeSaveProcessor start, server ip: %s", new Object[]{networkEntity.getLinkIp()});
        Boolean isConnectCdrSuccess = (Boolean)context.getAttribute("kubeCdrStatus", Boolean.class);
        if (isConnectCdrSuccess != null && !isConnectCdrSuccess.booleanValue()) {
            LOGGER.error((Object)"[kubernetes]Kubernetes save process canceled, cause could not connect to CDR. server ip:%s", new Object[]{context.getAttribute("kubeServerIp")});
            return false;
        }
        String deviceSn = networkEntity.getSn();
        Object resourceSetObj = context.getAttribute("kubeResourceSet");
        if (!VerifyUtil.isEmpty((Object)resourceSetObj)) {
            List resourceSets = (List)resourceSetObj;
            KubeRefreshResourceUtils.saveOrUpdateOrDeleteResourceSet(deviceSn, resourceSets, true);
        }
        if (!VerifyUtil.isEmpty((Object)(kubeStoragesObj = context.getAttribute("kubeStorage")))) {
            List kubeStorages = (List)kubeStoragesObj;
            this.saveOrUpdateOrDeleteKubeStorage(deviceSn, kubeStorages);
        }
        if (VerifyUtil.isEmpty((Object)(kubernetesNE = (KubernetesNE)context.getAttribute("StorageDevice", KubernetesNE.class)))) {
            LOGGER.error((Object)"Can not get retrieved device data for kube!");
            throw new LegoCheckedException(0x200909L);
        }
        this.saveKubeDeviceToDB(kubernetesNE);
        return true;
    }

    private void saveKubeDeviceToDB(KubernetesNE kubeNe) {
        LOGGER.info((Object)"Begin to save kubeNe info, moId: %s.", new Object[]{String.valueOf(kubeNe.getMoId())});
        CommonDAOLocator.getMoDao().getTransactionTemplate().execute((TransactionCallback)new SaveKubeTransactionCallback(kubeNe));
    }

    private void saveOrUpdateOrDeleteKubeStorage(String deviceSn, List<KubeStorage> newKubeStorageList) {
        if (VerifyUtil.isEmpty(newKubeStorageList)) {
            LOGGER.warn((Object)"[kubernetes]Cancel save or update storages, cause storages is empty.");
            this.kubeService.removeLocalkubeStorage(this.kubeService.getKuberStorages(deviceSn));
            return;
        }
        List oldKubeStorageList = this.kubeService.getKuberStorages(deviceSn);
        HashMap newKubeStorageMap = new HashMap();
        newKubeStorageList.forEach(kubeStorage -> newKubeStorageMap.put(kubeStorage.getKubeId() + kubeStorage.getId(), kubeStorage));
        this.kubeService.batchSaveOrUpdateKubeStorage(newKubeStorageList);
        this.kubeService.removeLocalkubeStorage(oldKubeStorageList.stream().filter(kubeStorage -> !newKubeStorageMap.containsKey(kubeStorage.getKubeId() + kubeStorage.getId())).collect(Collectors.toList()));
    }

    public void postProcess(AbstractContext abstractContext) {
    }

    public void clean(AbstractContext abstractContext) {
    }

    static class SaveKubeTransactionCallback
    implements TransactionCallback {
        private final KubernetesNE kubeNe;

        public SaveKubeTransactionCallback(KubernetesNE kubeNe) {
            this.kubeNe = kubeNe;
        }

        public Object doInTransaction(TransactionStatus ts) {
            try {
                CommonDAOLocator.getMoDao().addMoAndSubMo((ManagedObject)this.kubeNe);
            }
            catch (Exception ex) {
                ts.setRollbackOnly();
                ExceptionUtil.rethrowException((Throwable)ex, (String)"Save kube info.", (long)132416L, null, (Log)LOGGER);
            }
            return new HashMap();
        }
    }
}

