/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.kube.discovery.process;

import com.huawei.ism.cbb.base.task.AbstractBackTask;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.discover.framework.AbstractContext;
import com.huawei.ism.cbb.discover.framework.CommonTemplate;
import com.huawei.ism.cbb.discover.framework.CommonTemplateManager;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.kube.model.KubeExtendInfo;
import com.huawei.ism.drm.kube.sdk.model.Kubernetes;
import com.huawei.ism.drm.kube.sdk.model.KubernetesNE;
import com.huawei.ism.drm.kube.service.IKubeService;
import com.huawei.lego.cbb.backtask.sdk.model.BackTask;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.Collection;
import java.util.List;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Restrictions;

public class RefreshKubernetesTask
extends AbstractBackTask {
    private static final Log LOGGER = LogFactory.getInstance(RefreshKubernetesTask.class);
    private final String id;
    private final String userName;

    public RefreshKubernetesTask(String userName, String taskId, BackTask backTask, boolean isNeedUpdateDb) {
        super(taskId, backTask, isNeedUpdateDb);
        this.id = taskId;
        this.userName = userName;
    }

    protected void doWork() {
        Kubernetes kubernetes = ((IKubeService)ServiceLocator.getInstance().getService(IKubeService.class)).getKubeById(this.id);
        KubeExtendInfo kubeExtendInfo = new KubeExtendInfo();
        kubeExtendInfo.setSiteId(kubernetes.getSiteId());
        kubeExtendInfo.setDeviceSn(kubernetes.getDeviceSn());
        kubeExtendInfo.setIp(kubernetes.getIpAddress());
        kubeExtendInfo.setUser(this.userName);
        kubeExtendInfo.setClusterName(kubernetes.getName());
        KubernetesNE kubernetesNE = null;
        DetachedCriteria criteria = DetachedCriteria.forClass(KubernetesNE.class);
        criteria.add((Criterion)Restrictions.eq((String)"uuid", (Object)kubernetes.getDbId()));
        List objects = CommonDAOLocator.getBaseDao().getHibernateTemplate().findByCriteria(criteria);
        if (VerifyUtil.isEmpty((Collection)objects) || !(objects.get(0) instanceof KubernetesNE)) {
            LOGGER.error((Object)"KubernetesNE uuid: %s dosen't exist.Failed to query.", new Object[]{kubernetes.getDbId()});
            throw new LegoCheckedException(1073947394L);
        }
        kubernetesNE = (KubernetesNE)objects.get(0);
        AbstractContext context = new AbstractContext();
        context.setAttribute("kubeExtendInfo", (Object)kubeExtendInfo);
        context.setAttribute("kubeServerIp", (Object)kubernetes.getIpAddress());
        context.setAttribute("kubeSiteId", (Object)kubernetes.getSiteId());
        context.setAttribute("kubeDeviceSN", (Object)kubernetes.getDeviceSn());
        context.setAttribute("StorageDevice", (Object)kubernetesNE);
        context.setAttribute("DiscoveryType", (Object)"refresh");
        context.setAttribute("icommand:action", (Object)"icommand:action:refresh");
        context.setAttribute("refreshOrPoll", (Object)true);
        CommonTemplate refreshTemplate = CommonTemplateManager.getInstance().getTemplateByManagementProtocol("Kube", 2);
        refreshTemplate.process(context);
    }
}

