/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.kube.execute.process;

import com.huawei.ism.drm.kube.sdk.IKubeHandler;
import com.huawei.ism.drm.kube.sdk.model.KubeProtectionJob;
import com.huawei.ism.drm.kube.sdk.model.KubeProtectionPlan;
import com.huawei.ism.drm.kube.sdk.model.constants.KubeEnumDefine;
import com.huawei.ism.drm.kube.sdk.utils.KubeResourceNameGenerator;
import com.huawei.ism.drm.kube.service.impl.KubeServiceImpl;
import com.huawei.ism.drm.protection.action.model.ActionContext;
import com.huawei.ism.drm.protection.framework.engine.action.AbstractBaseProtectAction;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class PreCDRReplicationAction
extends AbstractBaseProtectAction {
    private static final Log LOGGER = LogFactory.getInstance(PreCDRReplicationAction.class);

    public boolean doExecute(ActionContext context) {
        ProtectGroup protectGroup = null;
        if (context.getObject("PG_ENTITY") instanceof ProtectGroup) {
            protectGroup = (ProtectGroup)context.getObject("PG_ENTITY");
        }
        String srcSn = protectGroup.getPoProviderSN();
        String trgSn = ((ProtectGroupReplica)protectGroup.getReplicaList().iterator().next()).getRecoveryArray();
        KubeServiceImpl kubeService = new KubeServiceImpl();
        boolean isLocalCDRStatusNormal = kubeService.checkCDRStatusBySN(srcSn);
        boolean isRemoteCDRStatusNormal = kubeService.checkCDRStatusBySN(trgSn);
        if (!isLocalCDRStatusNormal || !isRemoteCDRStatusNormal) {
            LOGGER.error((Object)"Can not link to CDR. IsLocalCDRStatusNormal:%s. IsRemoteCDRStatusNormal:%s.", new Object[]{isLocalCDRStatusNormal, isRemoteCDRStatusNormal});
            return false;
        }
        String kubeProtectionName = (String)protectGroup.getProps().get("kube_protection_plan");
        IKubeHandler kubeHandler = PreCDRReplicationAction.getKubeHandler();
        Optional localProtectionPlanOpt = kubeHandler.getProtectionPlan(srcSn, kubeProtectionName);
        Optional remoteProtectionPlanOpt = kubeHandler.getProtectionPlan(trgSn, kubeProtectionName);
        if (!localProtectionPlanOpt.isPresent() || !remoteProtectionPlanOpt.isPresent()) {
            LOGGER.error((Object)"Can not find protectionPlan. IsLocalProtectionPlanNormal:%s. IsRemoteProtectionPlanNormal:%s.", new Object[]{localProtectionPlanOpt.isPresent(), remoteProtectionPlanOpt.isPresent()});
            return false;
        }
        context.addObject("kube_protection_plan", localProtectionPlanOpt.get());
        try {
            KubeProtectionJob kubeProtectionJob = this.getOrCreateProtectionJob(context, protectGroup, kubeHandler);
            context.addObject("protectionJob", (Object)kubeProtectionJob);
        }
        catch (LegoCheckedException e) {
            boolean isRemoteProtectionPlanOptNormal;
            LOGGER.error((Object)"Create protection job failed, errorMsg: %s.", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
            boolean isLocalProtectionPlanOptStatusNormal = KubeEnumDefine.CDRProtectGroupStatus.NORMAL.equals((Object)((KubeProtectionPlan)localProtectionPlanOpt.get()).getStatus());
            if (!isLocalProtectionPlanOptStatusNormal) {
                this.setDetail("lego.err.1073947751");
                this.setDetailParams(this.constructParams(new String[]{kubeProtectionName, ((KubeProtectionPlan)localProtectionPlanOpt.get()).getStatus().getValue()}));
            }
            if (!(isRemoteProtectionPlanOptNormal = KubeEnumDefine.CDRProtectGroupStatus.NORMAL.equals((Object)((KubeProtectionPlan)remoteProtectionPlanOpt.get()).getStatus()))) {
                this.setDetail("lego.err.1073947751");
                this.setDetailParams(this.constructParams(new String[]{kubeProtectionName, ((KubeProtectionPlan)remoteProtectionPlanOpt.get()).getStatus().getValue()}));
            }
            return false;
        }
        return true;
    }

    private KubeProtectionJob getOrCreateProtectionJob(ActionContext context, ProtectGroup protectGroup, IKubeHandler kubeHandler) {
        KubeProtectionJob kubeProtectionJob;
        Map executeParameter = (Map)context.getObject("EXCUTE_PARAMETER_MAP", Map.class);
        Object protectionJobObj = executeParameter.get("protectionJob");
        if (VerifyUtil.isEmpty(protectionJobObj)) {
            kubeProtectionJob = new KubeProtectionJob();
            kubeProtectionJob.setName(KubeResourceNameGenerator.generate());
            kubeProtectionJob.setProtectionPlanName((String)protectGroup.getProps().get("kube_protection_plan"));
            HashMap<String, String> labels = new HashMap<String, String>();
            labels.put("bcm-protectionjob", String.valueOf(System.currentTimeMillis()));
            kubeProtectionJob.setLabels(labels);
            kubeHandler.createProtectionJob(protectGroup.getPoProviderSN(), kubeProtectionJob);
        } else {
            if (!(protectionJobObj instanceof KubeProtectionJob)) {
                throw new LegoCheckedException(1073947393L);
            }
            kubeProtectionJob = (KubeProtectionJob)protectionJobObj;
        }
        return kubeProtectionJob;
    }

    private static IKubeHandler getKubeHandler() {
        return (IKubeHandler)ServiceLocator.getInstance().getService(IKubeHandler.class);
    }
}

