/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.kube.protection.provider;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.kube.model.PersistentVolumeStatus;
import com.huawei.ism.drm.kube.protection.utils.KubeProtectProviderUtil;
import com.huawei.ism.drm.kube.sdk.IKubeHandler;
import com.huawei.ism.drm.kube.sdk.model.PersistentVolumeClaimInfo;
import com.huawei.ism.drm.kube.sdk.model.bo.LabelBO;
import com.huawei.ism.drm.kube.sdk.model.bo.PersistentVolumeBO;
import com.huawei.ism.drm.kube.utils.KubeProviderUtil;
import com.huawei.ism.drm.protection.framework.service.provider.AbstractProtectObjectProvider;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObjectStorageInfo;
import com.huawei.ism.drm.protection.group.sdk.service.IProtectGroupService;
import com.huawei.ism.drm.protection.schedule.sdk.model.Schedule;
import com.huawei.ism.drm.protection.schedule.sdk.model.ScheduleSyncType;
import com.huawei.ism.drm.protection.template.sdk.model.PolicyTemplate;
import com.huawei.ism.drm.protection.template.sdk.service.IPolicyTemplateManager;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public class PersistentVolumeProvider
extends AbstractProtectObjectProvider {
    private static final Log LOGGER = LogFactory.getInstance(PersistentVolumeProvider.class);
    private static final int MAX_PROTECT_OBJECT_SIZE = 256;
    private IPolicyTemplateManager policyTemplateManager;

    public void setPolicyTemplateManager(IPolicyTemplateManager policyTemplateManager) {
        this.policyTemplateManager = policyTemplateManager;
    }

    public List<ProtectObject> getSupportProtectObjectTypes() {
        ArrayList<ProtectObject> poList = new ArrayList<ProtectObject>();
        ProtectObject po = new ProtectObject();
        po.setPoType(21);
        po.setName("Kubernetes Persistent Volume");
        poList.add(po);
        return poList;
    }

    public int getProviderByType() {
        return 21;
    }

    public void buildProtectObjects(ProtectGroup protectGroup) {
        Set protectObjects = protectGroup.getPolist();
        if (protectObjects == null) {
            LOGGER.warn((Object)"No protect object to build.");
            return;
        }
        String kubeSN = protectGroup.getPoProviderSN();
        IKubeHandler kubeHandler = (IKubeHandler)ServiceLocator.getInstance().getService(IKubeHandler.class);
        List volumes = kubeHandler.getPersistentVolumes(kubeSN);
        protectObjects.forEach(protectObject -> this.updateProtectObject((ProtectObject)protectObject, volumes, kubeSN));
    }

    private void updateProtectObject(ProtectObject protectObject, List<PersistentVolumeBO> volumes, String providerSn) {
        String volumeId = protectObject.getMoUuid();
        PersistentVolumeBO volume = this.getPersistentVolumeById(volumes, volumeId);
        IKubeHandler kubeHandler = (IKubeHandler)ServiceLocator.getInstance().getService(IKubeHandler.class);
        Optional persistentVolumeClaimInfoOpt = kubeHandler.getPersistentVolumeClaimInfo(providerSn, volume.getPvcName(), volume.getPvcNamespace());
        if (!persistentVolumeClaimInfoOpt.isPresent()) {
            LOGGER.error((Object)"PVC %s is not exist", new Object[]{volume.getPvcName()});
            throw new LegoCheckedException(1073947750L);
        }
        protectObject.setName(this.get(persistentVolumeClaimInfoOpt.get(), PersistentVolumeClaimInfo::getName, "persistent volume claim name", ((PersistentVolumeClaimInfo)persistentVolumeClaimInfoOpt.get()).getId()));
        protectObject.setPoType(21);
        protectObject.setProviderSN(providerSn);
        String storageBackend = this.get(volume, PersistentVolumeBO::getStorageName, "storageBackend", volumeId);
        protectObject.setProperty("storageBackend", (Object)storageBackend);
        protectObject.getProps().put("IS_MANUAL", String.valueOf(0));
        protectObject.getProps().put("capacity", String.valueOf(volume.getCapacity()));
        if (VerifyUtil.isEmpty((String)protectObject.getUuid())) {
            protectObject.setUuid(((PersistentVolumeClaimInfo)persistentVolumeClaimInfoOpt.get()).getId());
        }
    }

    private <E, T> T get(E object, Function<E, T> getter, String field, String primary) {
        T value = getter.apply(object);
        if (VerifyUtil.isEmpty(value)) {
            throw new LegoCheckedException(1073947393L, "not find " + field + " for " + primary);
        }
        return value;
    }

    private PersistentVolumeBO getPersistentVolumeById(List<PersistentVolumeBO> volumes, String volumeId) {
        return volumes.stream().filter(volume -> Objects.equals(volume.getId(), volumeId)).findAny().orElseThrow(() -> new LegoCheckedException(2117645L));
    }

    public List<ProtectObject> getAvailableProtectObject(String poProviderSn, Map<String, Object> extendCondition) {
        IKubeHandler kubeHandler = (IKubeHandler)ServiceLocator.getInstance().getService(IKubeHandler.class);
        List persistentVolumes = kubeHandler.getPersistentVolumes(poProviderSn);
        if (VerifyUtil.isEmpty((Collection)persistentVolumes)) {
            LOGGER.warn((Object)"The result of persistent volumes from k8s is empty, device sn is %s", new Object[]{poProviderSn});
            return Collections.emptyList();
        }
        List<String> protectedVolumeIds = KubeProviderUtil.getProtectedObjectIds(21);
        ArrayList<ProtectObject> result = new ArrayList<ProtectObject>(persistentVolumes.size());
        String volumeName = KubeProviderUtil.parseExtendParam(extendCondition, "name", String.class);
        String storageName = KubeProviderUtil.parseExtendParam(extendCondition, "storage", String.class);
        for (PersistentVolumeBO bo : persistentVolumes) {
            PersistentVolumeClaimInfo info;
            if (VerifyUtil.isEmpty((String)bo.getPvcNamespace()) || VerifyUtil.isEmpty((String)bo.getPvcName())) {
                LOGGER.error((Object)"PersistentVolume %s has no pvc name or pvc nameSpace. Pvc name:%s. Pvc nameSpace:%s.", new Object[]{bo.getName(), bo.getPvcName(), bo.getPvcNamespace()});
                continue;
            }
            Optional persistentVolumeClaimInfoOpt = kubeHandler.getPersistentVolumeClaimInfo(poProviderSn, bo.getPvcName(), bo.getPvcNamespace());
            if (!persistentVolumeClaimInfoOpt.isPresent() || this.isPoNotNormal(protectedVolumeIds, volumeName, storageName, bo, info = (PersistentVolumeClaimInfo)persistentVolumeClaimInfoOpt.get())) continue;
            this.buildPo(poProviderSn, result, bo, info);
        }
        return result;
    }

    private void buildPo(String poProviderSn, List<ProtectObject> result, PersistentVolumeBO bo, PersistentVolumeClaimInfo info) {
        ProtectObject po = new ProtectObject();
        po.setMoUuid(bo.getId());
        po.setName(info.getName());
        po.setPoType(21);
        po.setProviderSN(poProviderSn);
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("status", info.getStatus());
        props.put("labels", info.getLabels());
        props.put("storageName", bo.getStorageName());
        props.put("namespace", bo.getPvcNamespace());
        props.put("kube_persistent_volume", bo.getName());
        props.put("storage_class", bo.getStorageClass());
        po.setProps(props);
        result.add(po);
    }

    private boolean isPoNotNormal(List<String> protectedVolumeIds, String volumeName, String storageName, PersistentVolumeBO bo, PersistentVolumeClaimInfo info) {
        if (!VerifyUtil.isEmpty(protectedVolumeIds) && protectedVolumeIds.contains(bo.getId())) {
            return true;
        }
        if (!PersistentVolumeStatus.BOUND.getCode().equals(info.getStatus())) {
            return true;
        }
        if (VerifyUtil.isEmpty((String)bo.getStorageName())) {
            return true;
        }
        if (!VerifyUtil.isEmpty((String)volumeName) && !bo.getName().contains(volumeName)) {
            return true;
        }
        if (!VerifyUtil.isEmpty((String)storageName) && !bo.getStorageName().contains(storageName)) {
            return true;
        }
        return "xuanwu".equals(bo.getPvcNamespace());
    }

    public void loadProtectObjectStorageInfo(List<ProtectObject> protectObjectList) {
        if (VerifyUtil.isEmpty(protectObjectList)) {
            LOGGER.warn((Object)"Not find poList.");
            throw new LegoCheckedException(1073947394L);
        }
        protectObjectList.forEach(item -> {
            item.setPoType(21);
            item.getProps().put("IS_MANUAL", String.valueOf(0));
        });
    }

    private static String mergeLabels(List<LabelBO> labelList) {
        if (VerifyUtil.isEmpty(labelList)) {
            return "";
        }
        return labelList.stream().map(LabelBO::getName).collect(Collectors.joining(", "));
    }

    public List<ProtectObjectStorageInfo> getProtectObjectStorageInfo(ProtectObject protectObject) {
        return Collections.emptyList();
    }

    public List<ProtectObject> getAddAvailableProtectObject(String poProviderSn, String pgId, Map<String, Object> extParamInQueryParam) {
        IProtectGroupService service = (IProtectGroupService)ServiceLocator.getInstance().getService(IProtectGroupService.class);
        ProtectGroup pg = service.getProtectGroupByID(pgId, false);
        String storageName = ((ProtectObject)pg.getPolist().iterator().next()).getProperty("storageBackend");
        List srcPos = this.getAvailableProtectObject(poProviderSn, extParamInQueryParam).stream().filter(po -> storageName.equals(po.getProperty("storageName"))).collect(Collectors.toList());
        List<ProtectObject> trgPos = this.getAvailableProtectObject(((Schedule)pg.getTemplate().getSchedules().iterator().next()).getTargetSn(), extParamInQueryParam);
        HashSet trgSpaceAndNames = new HashSet();
        trgPos.forEach(po -> trgSpaceAndNames.add(po.getProperty("namespace") + "/" + po.getName()));
        return srcPos.stream().filter(po -> !trgSpaceAndNames.contains(po.getProperty("namespace") + "/" + po.getName())).collect(Collectors.toList());
    }

    public void checkProtectObjectsInProtectGroup(ProtectGroup protectGroup) {
        if (!VerifyUtil.isEmpty((Collection)protectGroup.getPolist()) && protectGroup.getPolist().size() > 256) {
            LOGGER.error((Object)"Persistent Volume is over limit.");
            throw new LegoCheckedException(1073948163L);
        }
    }

    public void checkPolicyProps(PolicyTemplate policyTemplate) {
        super.checkPolicyTemplate(policyTemplate);
        Set scheduleSet = policyTemplate.getSchedules();
        for (Schedule schedule : scheduleSet) {
            if (schedule.getScheduleMode() == 1) continue;
            if (schedule.getPeriodType() == 5 && schedule.getSyncType() != ScheduleSyncType.WAIT_AFTER_SYNC_BEGIN.getValue() && schedule.getSyncType() != ScheduleSyncType.WAIT_AFTER_SYNC_END.getValue()) {
                LOGGER.error((Object)"Second period type must specify sync type.");
                throw new LegoCheckedException(1073947393L);
            }
            if (schedule.getPeriodType() != 4) continue;
            LOGGER.error((Object)"Not support month period type for persistent volume.");
            throw new LegoCheckedException(1073947393L);
        }
    }

    public List<PolicyTemplate> getSupportPolicyTemplate(List<ProtectObject> protectObjectList) {
        return KubeProtectProviderUtil.buildSupportPolicyTemplate(this.policyTemplateManager, 55);
    }
}

