/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.kube.protection.provider;

import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.kube.protection.provider.PersistentVolumeProvider;
import com.huawei.ism.drm.kube.protection.utils.KubeProtectProviderUtil;
import com.huawei.ism.drm.kube.sdk.IKubeHandler;
import com.huawei.ism.drm.kube.sdk.model.KubeResourceSetPVC;
import com.huawei.ism.drm.kube.sdk.model.ResourceSetInfo;
import com.huawei.ism.drm.kube.service.IKubeService;
import com.huawei.ism.drm.kube.service.impl.KubeServiceImpl;
import com.huawei.ism.drm.kube.utils.KubeProviderUtil;
import com.huawei.ism.drm.protection.framework.service.provider.AbstractProtectObjectProvider;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObjectStorageInfo;
import com.huawei.ism.drm.protection.schedule.sdk.model.Schedule;
import com.huawei.ism.drm.protection.template.sdk.model.PolicyTemplate;
import com.huawei.ism.drm.protection.template.sdk.service.IPolicyTemplateManager;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.UUIDGenerator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Restrictions;

public class ResourceSetProvider
extends AbstractProtectObjectProvider {
    private static final Log LOGGER = LogFactory.getInstance(PersistentVolumeProvider.class);
    private final IKubeService kubeService = new KubeServiceImpl();
    private IPolicyTemplateManager policyTemplateManager;

    public void setPolicyTemplateManager(IPolicyTemplateManager policyTemplateManager) {
        this.policyTemplateManager = policyTemplateManager;
    }

    public List<ProtectObject> getSupportProtectObjectTypes() {
        ArrayList<ProtectObject> poList = new ArrayList<ProtectObject>();
        ProtectObject po = new ProtectObject();
        po.setPoType(20);
        po.setName("Kubernetes Resource Set");
        poList.add(po);
        return poList;
    }

    public int getProviderByType() {
        return 20;
    }

    public void buildProtectObjects(ProtectGroup protectGroup) {
        if (VerifyUtil.isEmpty((Collection)protectGroup.getPolist())) {
            LOGGER.warn((Object)"No protect object to build.");
            return;
        }
        IKubeService iKubeService = (IKubeService)ServiceLocator.getInstance().getService(IKubeService.class);
        IKubeHandler kubeHandler = (IKubeHandler)ServiceLocator.getInstance().getService(IKubeHandler.class);
        for (ProtectObject protectObject : protectGroup.getPolist()) {
            ResourceSetInfo resourceSetInfo = iKubeService.getResourceSet(protectGroup.getPoProviderSN(), protectObject.getMoUuid());
            protectObject.setName(resourceSetInfo.getName());
            protectObject.setPoType(20);
            protectObject.setProviderSN(protectGroup.getPoProviderSN());
            protectObject.getProps().put("IS_MANUAL", String.valueOf(0));
            protectObject.setProperty("namespace", (Object)resourceSetInfo.getNamespace());
            protectObject.getProps().put("resourceDetailName", resourceSetInfo.getResourceDetailName());
            if (VerifyUtil.isEmpty((String)protectObject.getUuid())) {
                protectObject.setUuid(UUIDGenerator.getUUID());
            }
            double sumCapacity = ResourceSetProvider.getResourceSetCapacity(protectGroup, kubeHandler, resourceSetInfo);
            protectObject.getProps().put("capacity", String.valueOf(sumCapacity));
        }
    }

    private static double getResourceSetCapacity(ProtectGroup protectGroup, IKubeHandler kubeHandler, ResourceSetInfo resourceSetInfo) {
        List pvcList = kubeHandler.getResourceSetPVCs(protectGroup.getPoProviderSN(), resourceSetInfo.getResourceDetailName());
        double sumCapacity = 0.0;
        for (KubeResourceSetPVC pvc : pvcList) {
            sumCapacity += pvc.getKubePV().getCapacity();
        }
        return sumCapacity;
    }

    public List<ProtectObject> getAvailableProtectObject(String poProviderSn, Map<String, Object> extendCondition) {
        List resourceSets = this.kubeService.getResourceSets(poProviderSn);
        if (VerifyUtil.isEmpty((Collection)resourceSets)) {
            LOGGER.warn((Object)"The result of resource set from database is empty, device sn is %s", new Object[]{poProviderSn});
            return Collections.emptyList();
        }
        List<String> protectedResourceSetIds = KubeProviderUtil.getProtectedObjectIds(20);
        ArrayList<ProtectObject> result = new ArrayList<ProtectObject>(resourceSets.size());
        String resourceSetName = KubeProviderUtil.parseExtendParam(extendCondition, "name", String.class);
        for (ResourceSetInfo resourceSet : resourceSets) {
            if (!VerifyUtil.isEmpty(protectedResourceSetIds) && protectedResourceSetIds.contains(resourceSet.getId()) || !VerifyUtil.isEmpty((String)resourceSetName) && !resourceSet.getName().contains(resourceSetName)) continue;
            ProtectObject po = new ProtectObject();
            po.setMoUuid(resourceSet.getId());
            po.setName(resourceSet.getName());
            po.setPoType(20);
            po.setProviderSN(poProviderSn);
            HashMap<String, String> props = new HashMap<String, String>(2);
            props.put("namespace", resourceSet.getNamespace());
            props.put("pods", ResourceSetProvider.mergePods(resourceSet.getProtectResources()));
            po.setProps(props);
            result.add(po);
        }
        return result;
    }

    public void loadProtectObjectStorageInfo(List<ProtectObject> protectObjectList) {
        ArrayList<String> resourceSetIds = new ArrayList<String>();
        HashMap<String, ProtectObject> poMap = new HashMap<String, ProtectObject>();
        for (ProtectObject protectObject : protectObjectList) {
            String id = protectObject.getMoUuid();
            resourceSetIds.add(id);
            poMap.put(id, protectObject);
        }
        DetachedCriteria criteria = DetachedCriteria.forClass(ResourceSetInfo.class);
        criteria.add(Restrictions.in((String)"id", resourceSetIds));
        List objects = CommonDAOLocator.getBaseDao().getHibernateTemplate().findByCriteria(criteria);
        if (VerifyUtil.isEmpty((Collection)objects) || objects.size() != resourceSetIds.size()) {
            LOGGER.error((Object)"Not find any resourceSet by id.");
            throw new LegoCheckedException(1073947394L);
        }
        objects.stream().filter(item -> item instanceof ResourceSetInfo).map(item -> (ResourceSetInfo)item).forEach(item -> this.setProtectObject((Map<String, ProtectObject>)poMap, (ResourceSetInfo)item));
    }

    private void setProtectObject(Map<String, ProtectObject> poMap, ResourceSetInfo info) {
        String id = info.getId();
        ProtectObject protectObject = poMap.get(id);
        if (VerifyUtil.isEmpty((Object)protectObject)) {
            LOGGER.error((Object)"Not find po by id: %s", new Object[]{id});
            throw new LegoCheckedException(1073947394L);
        }
        protectObject.setName(info.getName());
        protectObject.setPoType(20);
        protectObject.setProviderSN(info.getKubeId());
        protectObject.getProps().put("IS_MANUAL", String.valueOf(0));
        protectObject.getProps().put("resourceDetailName", info.getResourceDetailName());
    }

    private static String mergePods(String pods) {
        if (VerifyUtil.isEmpty((String)pods) || "[]".equals(pods)) {
            return "";
        }
        List podList = (List)JSONObject.toBean((String)pods, List.class);
        return podList.stream().filter(Objects::nonNull).map(e -> JSONObject.fromObject((Object)e).getString("name")).collect(Collectors.joining(", "));
    }

    public List<ProtectObjectStorageInfo> getProtectObjectStorageInfo(ProtectObject protectObject) {
        return Collections.emptyList();
    }

    public List<ProtectObject> getAddAvailableProtectObject(String poProviderSn, String pgId, Map<String, Object> extParamInQueryParam) {
        return Collections.emptyList();
    }

    public void checkProtectObjectsInProtectGroup(ProtectGroup protectGroup) {
        if (!VerifyUtil.isEmpty((Collection)protectGroup.getPolist()) && protectGroup.getPolist().size() != 1) {
            LOGGER.error((Object)"Resource set is over limit.");
            throw new LegoCheckedException(1073948163L);
        }
    }

    public void checkPolicyProps(PolicyTemplate policyTemplate) {
        super.checkPolicyTemplate(policyTemplate);
        Set scheduleSet = policyTemplate.getSchedules();
        for (Schedule schedule : scheduleSet) {
            if (schedule.getScheduleMode() == 1 || schedule.getPeriodType() != 5) continue;
            LOGGER.error((Object)"Not support second period type.");
            throw new LegoCheckedException(1073947393L);
        }
    }

    public List<PolicyTemplate> getSupportPolicyTemplate(List<ProtectObject> protectObjectList) {
        return KubeProtectProviderUtil.buildSupportPolicyTemplate(this.policyTemplateManager, 49, 50, 54);
    }
}

