/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.kube.recovery.plugin;

import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.kube.recovery.plugin.KubeRecoveryPlanPluginUtil;
import com.huawei.ism.drm.recovery.framework.plugin.IRecoveryPlanPlugin;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.util.Map;

public class KubeResourceSetRecoveryPlanPlugin
implements IRecoveryPlanPlugin {
    private static final Log LOGGER = LogFactory.getInstance(KubeResourceSetRecoveryPlanPlugin.class);

    public int getPoType() {
        return 20;
    }

    public void beforeCreate(RecoveryPlan recoveryPlan) {
        LOGGER.info((Object)"[kubernetes]Start handle customised recovery plan plugin before create, planName: %s, poType: %s", new Object[]{recoveryPlan.getName(), 20});
        KubeRecoveryPlanPluginUtil.validate(recoveryPlan);
        KubeRecoveryPlanPluginUtil.createRecoveryPlan(recoveryPlan);
    }

    public void beforeModify(RecoveryPlan oldPlan, RecoveryPlan newPlan) {
        LOGGER.info((Object)"[kubernetes]Start handle customised recovery plan plugin before modify, planName: %s, poType: %s", new Object[]{oldPlan.getName(), 20});
        try {
            newPlan.setProtectGroups(oldPlan.getProtectGroups());
            KubeRecoveryPlanPluginUtil.validate(newPlan);
            KubeRecoveryPlanPluginUtil.modifyRecoveryPlan(newPlan);
        }
        catch (LegoCheckedException e) {
            LOGGER.error((Object)"Modify kubernetes recovery plan failed, error: %s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
            CommonDAOLocator.getBaseDao().getHibernateTemplate().update((Object)oldPlan);
            throw e;
        }
        Map newGlobalSettings = newPlan.getGlobalSettings();
        newGlobalSettings.put("cdrRecoveryName", KubeRecoveryPlanPluginUtil.getCdrRecoveryPlanName(oldPlan));
        oldPlan.setGlobalSettings(newGlobalSettings);
        oldPlan.setName(newPlan.getName());
        oldPlan.setDescription(newPlan.getDescription());
        CommonDAOLocator.getBaseDao().getHibernateTemplate().update((Object)oldPlan);
    }

    public void beforeDelete(RecoveryPlan recoveryPlan) {
        LOGGER.info((Object)"[kubernetes]Start handle customised recovery plan plugin before modify, planName: %s, poType: %s", new Object[]{recoveryPlan.getName(), 20});
        KubeRecoveryPlanPluginUtil.deleteRecoveryPlan(recoveryPlan);
    }
}

