/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.kube.recovery.process.backup;

import com.huawei.ism.drm.kube.recovery.process.BaseKubeRecoveryEventProcessor;
import com.huawei.ism.drm.kube.sdk.model.KubeRestoreJob;
import com.huawei.ism.drm.kube.sdk.model.constants.KubeEnumDefine;
import com.huawei.ism.drm.kube.sdk.model.enums.KubeEventKeywords;
import com.huawei.ism.drm.kube.sdk.model.enums.KubeJobType;
import com.huawei.ism.drm.kube.sdk.model.enums.KubeRecoveryJobType;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.JSONObject;

public class KubeRecoveryBackupReplicaTaskProcessor
extends BaseKubeRecoveryEventProcessor {
    private static final long serialVersionUID = -614284131477637447L;
    private static final Log LOGGER = LogFactory.getInstance(KubeRecoveryBackupReplicaTaskProcessor.class);

    @Override
    protected boolean isProduct() {
        return true;
    }

    @Override
    protected KubeRecoveryJobType getJobType() {
        return KubeRecoveryJobType.BACKUP;
    }

    @Override
    protected KubeJobType getJobSubType() {
        return KubeJobType.RESTORE_JOB;
    }

    @Override
    protected String getStartKeyword() {
        return "";
    }

    @Override
    protected String getEndKeyword() {
        return KubeEventKeywords.BackupRestoreJob.END.getValue();
    }

    @Override
    protected boolean execute(RecoveryProcessorContext context) {
        LOGGER.info((Object)"Start execute backup replica task processor");
        KubeRestoreJob kubeRestoreJob = new KubeRestoreJob();
        kubeRestoreJob.setName(this.getJobName());
        kubeRestoreJob.setBackupName(this.getGlobalSetting("REPLICA_ID"));
        kubeRestoreJob.setTargetNameSpace(this.getGlobalSetting("execNamespace"));
        kubeRestoreJob.setRestorePrefix(this.getGlobalSetting("restorePrefix"));
        kubeRestoreJob.setPostHookName(this.getGlobalSetting("execPostHook"));
        kubeRestoreJob.setPreserveNodePort(Boolean.parseBoolean(this.getGlobalSetting("preserveNodePort")));
        kubeRestoreJob.setPreserveClusterIpAddr(Boolean.parseBoolean(this.getGlobalSetting("preserveClusterIpAddr")));
        String restoreSpeed = this.getGlobalSetting("ROLLBACK_RATE");
        String cdrRestoreSpeed = KubeEnumDefine.SpeedType.getCdrRestoreSpeed((String)restoreSpeed);
        kubeRestoreJob.setRestoreSpeed(cdrRestoreSpeed);
        LOGGER.info((Object)"Start create restore job, job info: %s", new Object[]{JSONObject.fromObject((Object)kubeRestoreJob).toString()});
        KubeRecoveryBackupReplicaTaskProcessor.getKubeHandler().createRestoreJob(this.getDevSn(), kubeRestoreJob);
        return this.listenEvent();
    }
}

