/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.kube.recovery.process.common;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.kube.recovery.process.BaseKubeRecoveryProcessor;
import com.huawei.ism.drm.kube.recovery.process.common.KubeCleanProductionKubeResourceSubProcessor;
import com.huawei.ism.drm.kube.sdk.IKubeHandler;
import com.huawei.ism.drm.kube.sdk.model.KubeResource;
import com.huawei.ism.drm.kube.utils.KubeResourceUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import io.fabric8.kubernetes.api.model.Namespace;
import io.fabric8.kubernetes.api.model.PersistentVolume;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaim;
import io.fabric8.kubernetes.api.model.storage.StorageClass;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class KubeCleanProductionKubeResourceProcessor
extends BaseKubeRecoveryProcessor {
    private static final long serialVersionUID = -8525675223195370552L;
    private static final List<String> RESERVED_RESOURCE_KINDS = KubeCleanProductionKubeResourceProcessor.loadReservedResourceKinds();
    private String resourceTypes;

    public String getResourceTypes() {
        return this.resourceTypes;
    }

    public KubeCleanProductionKubeResourceProcessor setResourceTypes(String resourceTypes) {
        this.resourceTypes = resourceTypes;
        return this;
    }

    private static List<String> loadReservedResourceKinds() {
        ArrayList<String> kinds = new ArrayList<String>();
        for (Class clazz : Arrays.asList(PersistentVolumeClaim.class, PersistentVolume.class, StorageClass.class, Namespace.class)) {
            kinds.add(clazz.getSimpleName());
        }
        kinds.addAll(Arrays.asList("VolumeSet", "Cluster", "SchedulePolicy", "ResourceSet", "ProtectionPlan", "RecoveryPlan"));
        return Collections.unmodifiableList(kinds);
    }

    protected boolean execute(RecoveryProcessorContext context) {
        List<RecoveryProcessor> processors = this.createSubProcessors(this.getRecoveryPlan());
        this.saveSubProcessors(processors);
        boolean isExecSuccess = this.invoke(context);
        if (isExecSuccess) {
            if (this.getProcType() == DrmEnumDefine.RecoveryPlanExecuteTypeE.PLANED_MOTION.getValue()) {
                this.refreshResourceSet(this.getDevSn(0));
                this.refreshResourceSet(this.getDevSn(1));
            } else {
                this.refreshResourceSet(this.getDevSn(0));
            }
        }
        return isExecSuccess;
    }

    public List<RecoveryProcessor> createSubProcessors(RecoveryPlan recoveryPlan) {
        ProtectGroup protectGroup = recoveryPlan.getProtectGroup();
        IKubeHandler kubeHandler = KubeCleanProductionKubeResourceProcessor.getKubeHandler();
        ArrayList<RecoveryProcessor> processors = new ArrayList<RecoveryProcessor>();
        for (ProtectObject protectObject : protectGroup.getPolist()) {
            String resourceDetailName = protectObject.getProperty("resourceDetailName");
            List resources = kubeHandler.getDetailResourceList(protectGroup.getPoProviderSN(), resourceDetailName);
            KubeResourceUtil.sort(resources);
            resources.stream().filter(resource -> this.isDeletableResourceType(resource.getKind())).map(this::createSubProcessor).forEach(processors::add);
        }
        return processors;
    }

    private boolean isDeletableResourceType(String kind) {
        if (RESERVED_RESOURCE_KINDS.contains(kind)) {
            return false;
        }
        if (this.resourceTypes == null) {
            return true;
        }
        List<String> types = Arrays.asList(this.resourceTypes.split(","));
        return types.contains(kind);
    }

    private KubeCleanProductionKubeResourceSubProcessor createSubProcessor(KubeResource resource) {
        return (KubeCleanProductionKubeResourceSubProcessor)this.createSubProcessor(KubeCleanProductionKubeResourceSubProcessor::new, processor -> {
            processor.setResourceName(resource.getName());
            processor.setResourceKind(resource.getKind());
            processor.setResourceVersion(resource.getVersion());
            processor.setResourceNamespace(resource.getNamespace());
        });
    }
}

