/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.kube.recovery.process.common;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.PolicyTemplateType;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.kube.recovery.process.common.KubeRecoveryPrepareProcessor;
import com.huawei.ism.drm.kube.sdk.model.BackupInstanceInfo;
import com.huawei.ism.drm.kube.sdk.model.constants.KubeEnumDefine;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.recovery.framework.util.RecoveryPlanUtil;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;

public class KubeRecoveryProductionPrepareProcessor
extends KubeRecoveryPrepareProcessor {
    private static final Log LOGGER = LogFactory.getInstance(KubeRecoveryProductionPrepareProcessor.class);

    @Override
    protected boolean execute(RecoveryProcessorContext recoveryProcessorContext) {
        this.checkProductionCluster();
        int policyTemplate = RecoveryPlanUtil.getPolicyTemplateFromRecovery((RecoveryPlan)this.getRecoveryPlan()).getType();
        if (PolicyTemplateType.KUBE_BACKUP_TYPES.contains(policyTemplate)) {
            this.checkBackupInstanceStatus();
        }
        if (PolicyTemplateType.KUBE_REPLICATION_TYPES.contains(policyTemplate)) {
            this.checkProductionProtectionPlanStatus();
        }
        return this.success();
    }

    private void checkBackupInstanceStatus() {
        RecoveryPlan recoveryPlan = this.getRecoveryPlan();
        ProtectGroup protectGroup = recoveryPlan.getProtectGroup();
        String backupInstanceName = protectGroup.getProperty("kube_backup_instance");
        if (VerifyUtil.isEmpty((String)backupInstanceName)) {
            LOGGER.error((Object)"Prepare for executing recovery plan failed, could not find backup instance from props of pg (%s).", new Object[]{protectGroup.getName()});
            throw new LegoCheckedException(1073947393L);
        }
        BackupInstanceInfo backupInstanceInfo = KubeRecoveryProductionPrepareProcessor.getKubeHandler().getBackupInstanceInfo(this.getDevSn(0), backupInstanceName);
        if (!KubeEnumDefine.BackupInstanceStatus.NORMAL.getValue().equals(backupInstanceInfo.getStatus())) {
            throw new LegoCheckedException(1073947754L, new String[]{backupInstanceName, backupInstanceInfo.getStatus()});
        }
    }
}

