/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.kube.recovery.process.reprotect;

import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.kube.recovery.process.BaseKubeRecoveryProcessor;
import com.huawei.ism.drm.kube.recovery.process.reprotect.KubeRefactorRelationProcessor;
import com.huawei.ism.drm.protection.group.sdk.service.IProtectGroupService;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.framework.process.reprotect.RefactorProtectRelationProcessor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;

public class KubeRefactorConfigurationProcessor
extends BaseKubeRecoveryProcessor {
    private static final long serialVersionUID = -4045872739858204844L;

    public KubeRefactorConfigurationProcessor() {
        this.setReentrantable(false);
    }

    protected boolean execute(RecoveryProcessorContext context) {
        ArrayList<BaseRecoveryProcessor> processors = new ArrayList<BaseRecoveryProcessor>();
        processors.add(this.createSubProcessor(KubeRefactorRelationProcessor::new, processor -> processor.setReentrantable(false)));
        processors.add(this.createSubProcessor(RefactorProtectRelationProcessor::new, processor -> {
            processor.setProcName(RefactorProtectRelationProcessor.class.getName() + "2");
            processor.setReentrantable(false);
        }));
        this.saveSubProcessors(processors);
        boolean isExecSuccess = this.invoke(context);
        if (isExecSuccess) {
            IProtectGroupService pgService = (IProtectGroupService)ServiceLocator.getInstance().getService(IProtectGroupService.class);
            RecoveryPlan recoveryPlan = this.getRecoveryPlan();
            String pgId = recoveryPlan.getProtectGroup().getUuid();
            pgService.resetProtectGroupStatus(pgId);
        }
        return isExecSuccess;
    }

    protected void updateSubProcessors(Set<RecoveryProcessor> newSubProcessors) {
        HashSet<RecoveryProcessor> processors = new HashSet<RecoveryProcessor>(newSubProcessors);
        super.updateSubProcessors(newSubProcessors);
        Set items = Optional.ofNullable(this.getChildProc()).orElse(Collections.emptySet());
        if (items.stream().noneMatch(KubeRefactorRelationProcessor.class::isInstance)) {
            ArrayList list = new ArrayList();
            processors.stream().filter(KubeRefactorRelationProcessor.class::isInstance).forEach(list::add);
            list.addAll(items);
            Set linkedRecoveryProcessors = this.linkRecoveryProcessors(list);
            this.setChildProc(linkedRecoveryProcessors);
        }
    }
}

