/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.kube.recovery.process.reprotect;

import com.huawei.ism.drm.base.util.dao.HibernateUtil;
import com.huawei.ism.drm.common.sdk.model.DRMObject;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.service.IProtectGroupService;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.schedule.sdk.model.Schedule;
import com.huawei.ism.drm.recovery.framework.provider.BaseRefactorConfigurationProvider;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.site.resource.sdk.service.IResourceService;
import com.huawei.ism.drm.site.sdk.model.DrResource;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.stereotype.Component;

@Component
public class KubeRefactorConfigurationProvider
extends BaseRefactorConfigurationProvider {
    private static final int RESOURCE_SET_DUPLICATE_RETRY_TIMES = 30;
    private static final Log LOGGER = LogFactory.getInstance(KubeRefactorConfigurationProvider.class);

    protected void reverseProtectObjectAttributes(ProtectObject protectObject, Map<String, Object> params) {
        ProtectGroup protectGroup = protectObject.getProtectGroup();
        String providerSN = protectGroup.getPoProviderSN();
        protectObject.setProviderSN(providerSN);
        DrResource drResource = ((IResourceService)ServiceLocator.getInstance().getService(IResourceService.class)).getDrResourceBySn(providerSN);
        protectObject.setProviderName(drResource.getName());
        this.updateProtectObjectMoUuid(protectObject);
        Map props = protectObject.getProps();
        this.reverse(props::get, props::put, "kube_persistent_volume", "kube_remote_persistent_volume");
        KubeRefactorConfigurationProvider.updateStorageBackend(protectObject, "storageBackend");
        KubeRefactorConfigurationProvider.updateStorageBackend(protectObject, "storageName");
    }

    private static void updateStorageBackend(ProtectObject protectObject, String key) {
        if (protectObject.hasProperty(key)) {
            ProtectGroup protectGroup = protectObject.getProtectGroup();
            String storageBackend = protectGroup.getProperty("sourceStorageBackendName");
            protectObject.setProperty(key, (Object)storageBackend);
        }
    }

    private void updateProtectObjectMoUuid(ProtectObject protectObject) {
        if (protectObject.getPoType() != DrmEnumDefine.AppType.KUBE_RESOURCE_SET.getValue()) {
            return;
        }
        String moUuid = this.queryCurrentResourceSetMoUuid(protectObject);
        protectObject.setMoUuid(moUuid);
    }

    private String queryCurrentResourceSetMoUuid(ProtectObject protectObject) {
        String providerSN = protectObject.getProviderSN();
        String name = protectObject.getName();
        List items = Collections.emptyList();
        int index = 0;
        while (index < 30 && (items = (List)HibernateUtil.call(session -> session.createQuery("select id from ResourceSetInfo where kubeId=:kube and name=:name", String.class).setParameter("kube", (Object)providerSN).setParameter("name", (Object)name).list())).size() != 1) {
            if (++index >= 30) continue;
            CommonUtil.sleep((long)1L, (TimeUnit)TimeUnit.SECONDS);
        }
        if (items.size() > 1) {
            String resourceSetIds = String.join((CharSequence)",", items);
            LOGGER.error((Object)"ResourceSet may duplicates. SN: %s, resourceSetName: %s, resourceSetIds:( %s )", new Object[]{providerSN, name, resourceSetIds});
            throw new LegoCheckedException(1073947393L);
        }
        String moUuid = items.stream().findFirst().orElse(null);
        if (moUuid == null) {
            LOGGER.error((Object)"ResourceSet may not update. SN: %s, RS: %s", new Object[]{providerSN, name});
            throw new LegoCheckedException(1073947393L);
        }
        return moUuid;
    }

    protected void refactorProtectGroup(ProtectGroup protectGroup, Map<String, Object> params) {
        this.refactorProtectGroupReplicas(protectGroup);
        super.refactorProtectGroup(protectGroup, params);
    }

    protected void refactorProtectObjectStorageInfos(ProtectObject protectObject, Map<String, Object> params) {
    }

    protected void refactorPolicyTemplate(ProtectGroup pg) {
    }

    protected void refactorLocalScheduleAndProps(ProtectGroup pg, int oldPolicytemplateType) {
    }

    private void refactorProtectGroupReplicas(ProtectGroup protectGroup) {
        Set<ProtectGroupReplica> replicas = KubeRefactorConfigurationProvider.nonNull(protectGroup.getReplicaList());
        for (ProtectGroupReplica replica : replicas) {
            replica.setRecoverySite(protectGroup.getProductSiteId());
            String source = replica.getProductArray();
            String target = replica.getRecoveryArray();
            replica.setProductArray(target);
            replica.setRecoveryArray(source);
        }
    }

    protected void reverseProtectGroupAttributes(ProtectGroup protectGroup, Map<String, Object> params) {
        Set<Schedule> schedules = KubeRefactorConfigurationProvider.nonNull(protectGroup.getTemplate().getSchedules());
        Set<String> targetSns = schedules.stream().map(Schedule::getTargetSn).collect(Collectors.toSet());
        if (targetSns.size() != 1) {
            throw new LegoCheckedException(1073947393L, "sn list is not unique");
        }
        targetSns.forEach(arg_0 -> ((ProtectGroup)protectGroup).setPoProviderSN(arg_0));
        Map properties = protectGroup.getProps();
        this.reverse(properties::get, properties::put, "sourceStorageBackendName", "targetStorageBackendName");
        schedules.forEach(schedule -> this.reverseScheduleConfiguration(protectGroup, (Schedule)schedule));
    }

    private <T> void reverse(Function<String, T> getter, BiConsumer<String, T> setter, String sourceKey, String targetKey) {
        T target;
        T source = getter.apply(sourceKey);
        if (Objects.equals(source, target = getter.apply(targetKey))) {
            return;
        }
        setter.accept(sourceKey, (String)target);
        setter.accept(targetKey, (String)source);
    }

    private void reverseScheduleConfiguration(ProtectGroup protectGroup, Schedule schedule) {
        String sourceSn = schedule.getSourceSn();
        String targetSn = schedule.getTargetSn();
        schedule.setSourceSn(targetSn);
        schedule.setTargetSn(sourceSn);
        String sourceSiteId = schedule.getSourceSiteId();
        String targetSiteId = schedule.getTargetSiteId();
        schedule.setSourceSiteId(targetSiteId);
        schedule.setTargetSiteId(sourceSiteId);
        Map params = schedule.getExtParameters();
        String targetStorageBackendName = protectGroup.getProperty("targetStorageBackendName");
        params.put("kubeTargetStorage", targetStorageBackendName);
        Optional.ofNullable(schedule.getExtParameterDatas()).ifPresent(data -> {
            String json = JSONObject.fromObject((Object)data).set((Object)"kubeTargetStorage", (Object)targetStorageBackendName).toString();
            schedule.setExtParameterDatas(json);
        });
    }

    protected void refactorRecoveryPlan(RecoveryPlan recoveryPlan, Map<String, Object> params) {
        String execPostHook;
        HashMap oldSettings = new HashMap(recoveryPlan.getGlobalSettings());
        super.refactorRecoveryPlan(recoveryPlan, params);
        this.reverse(oldSettings::get, oldSettings::put, "PRODUCT_SITE_ID", "DISASTER_SITE_ID");
        Map newSettings = recoveryPlan.getGlobalSettings();
        Stream.of("PRODUCT_SITE_ID", "DISASTER_SITE_ID").forEach(key -> {
            String cfr_ignored_0 = (String)newSettings.put(key, oldSettings.get(key));
        });
        recoveryPlan.setProperty("cdrRecoveryName", oldSettings.get("cdrRecoveryName"));
        String postHook = (String)oldSettings.get("postHook");
        if (!VerifyUtil.isEmpty((String)postHook)) {
            recoveryPlan.setProperty("postHook", (Object)postHook);
        }
        if (!VerifyUtil.isEmpty((String)(execPostHook = (String)oldSettings.get("execPostHook")))) {
            recoveryPlan.setProperty("execPostHook", (Object)execPostHook);
        }
    }

    public List<String> getAppType() {
        return Arrays.asList(DrmEnumDefine.AppType.KUBE_PERSISTENT_VOLUME.name(), DrmEnumDefine.AppType.KUBE_RESOURCE_SET.name());
    }

    private static <T> Set<T> nonNull(Set<T> set) {
        return Optional.ofNullable(set).orElse(Collections.emptySet());
    }

    public void afterRefactorConfiguration(Set<ProtectGroup> protectGroups) {
        String[] pgIds = (String[])protectGroups.stream().map(DRMObject::getUuid).toArray(String[]::new);
        IProtectGroupService pgService = (IProtectGroupService)ServiceLocator.getInstance().getService(IProtectGroupService.class);
        for (String pgId : pgIds) {
            pgService.resetProtectGroupStatus(pgId);
        }
    }

    public void afterRefactorConfiguration(RecoveryProcessorContext context) {
        super.afterRefactorConfiguration(context);
        context.removeAttribute("LockProtectGroup");
    }
}

