/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.kube.recovery.process.reprotect;

import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.drm.kube.recovery.process.BaseKubeRecoveryProcessor;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.schedule.sdk.model.Schedule;
import com.huawei.ism.drm.protection.template.sdk.model.PolicyTemplate;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.framework.process.ProtectGroupExecuteStatusChecker;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public class KubeReprotectSynchronizeProcessor
extends BaseKubeRecoveryProcessor {
    private static final long serialVersionUID = 6745917927903704261L;
    private static final Log LOGGER = LogFactory.getInstance(KubeReprotectSynchronizeProcessor.class);

    protected boolean execute(RecoveryProcessorContext context) {
        this.enableProtectGroupSchedules();
        ProtectGroup protectGroup = this.getRecoveryPlan().getProtectGroup();
        String disasterSiteId = protectGroup.getAnyoneReplicationReplica().getRecoverySite();
        ProtectGroupExecuteStatusChecker checker = new ProtectGroupExecuteStatusChecker(protectGroup, (BaseRecoveryProcessor)this, disasterSiteId);
        return checker.startProcess();
    }

    private void enableProtectGroupSchedules() {
        ProtectGroup protectGroup = this.getRecoveryPlan().getProtectGroup();
        LOGGER.info((Object)"Start enable protect group schedules, group name: %s", new Object[]{protectGroup.getName()});
        String enableSchedulesStr = protectGroup.getProperty("enable_schedules");
        if (VerifyUtil.isEmpty((String)enableSchedulesStr)) {
            LOGGER.warn((Object)"No schedules need to be enabled because no schedules have been disabled, enableSchedules: %s", new Object[]{enableSchedulesStr});
            return;
        }
        List enableSchedules = (List)JSONObject.toBean((String)enableSchedulesStr, List.class);
        if (VerifyUtil.isEmpty((Collection)enableSchedules)) {
            LOGGER.warn((Object)"No schedules need to be enabled because no schedules have been disabled, enableSchedules: %s", new Object[]{enableSchedulesStr});
            return;
        }
        PolicyTemplate template = protectGroup.getTemplate();
        Set schedules = template.getSchedules();
        for (Schedule schedule : schedules) {
            if (!enableSchedules.contains(schedule.getScheduleId())) continue;
            LOGGER.info((Object)"Start enable schedule : %s", new Object[]{schedule.getScheduleId()});
            schedule.setEnable(Boolean.valueOf(true));
            CommonDAOLocator.getBaseDao().getHibernateTemplate().saveOrUpdate((Object)schedule);
        }
    }
}

