/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.kube.recovery.process.reprotect;

import com.huawei.ism.drm.kube.recovery.process.BaseKubeRecoveryProcessor;
import com.huawei.ism.drm.kube.sdk.IKubeHandler;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public class KubeReverseMonitorProcessor
extends BaseKubeRecoveryProcessor {
    public static final String FINISHED = "Finished";
    protected static final String VOLUMES = "Volumes";
    protected static final String RESOURCES = "Resources";
    private static final long serialVersionUID = 1555179720717924264L;
    private static final Log LOGGER = LogFactory.getInstance(KubeReverseMonitorProcessor.class);
    private static final List<String> STAGE_LIST = Arrays.asList("Initial", "Volumes", "Resources", "Finished");
    private static final String FAILED = "Failed";
    private static final String COMPLETED = "Completed";
    private static final int DURATION = 5;
    private String jobName;
    private String stage;
    private int stageIndex;
    private boolean isProduct;

    public String getJobName() {
        return this.jobName;
    }

    public void setJobName(String jobName) {
        this.jobName = jobName;
    }

    public String getStage() {
        return this.stage;
    }

    public void setStage(String stage) {
        int index = STAGE_LIST.indexOf(stage);
        if (index == -1) {
            throw new LegoCheckedException(1073947393L);
        }
        this.stageIndex = index;
        this.stage = stage;
    }

    public int getStageIndex() {
        return this.stageIndex;
    }

    @Override
    public boolean isProduct() {
        return this.isProduct;
    }

    public void setProduct(Boolean isProduct) {
        this.isProduct = Boolean.TRUE.equals(isProduct);
    }

    protected boolean execute(RecoveryProcessorContext context) {
        if (this.checkIfRefractSucceed()) {
            LOGGER.info((Object)"CDR has already refract succeed, skip current operation");
            return this.success();
        }
        IKubeHandler kubeHandler = KubeReverseMonitorProcessor.getKubeHandler();
        String devSn = this.getDevSn();
        AtomicBoolean running = new AtomicBoolean();
        while (true) {
            if (!running.compareAndSet(false, true)) {
                CommonUtil.sleep((long)5L, (TimeUnit)TimeUnit.SECONDS);
            }
            String[] progress = kubeHandler.queryReprotectionJobProgress(devSn, this.jobName);
            String jobStage = progress[0];
            String jobState = progress[1];
            int jobStageIndex = STAGE_LIST.indexOf(jobStage);
            if (jobStageIndex > this.stageIndex) {
                return this.success();
            }
            if (jobStageIndex < this.stageIndex) {
                if (!FAILED.equals(jobState)) continue;
                String failedStage = Optional.ofNullable(jobStage).map(value -> value.toLowerCase(Locale.ROOT)).orElse("unknown");
                LOGGER.error((Object)"reprotection job(%s) of %s failed at stage %s", new Object[]{this.jobName, devSn, failedStage});
                return this.failure("ism.drm.recovery.k8s.reprotect.reverse.failed", new String[]{failedStage});
            }
            if (FAILED.equals(jobState)) {
                LOGGER.error((Object)"reprotection job(%s) of %s failed at stage %s", new Object[]{this.jobName, devSn, this.stage});
                return this.failure("ism.drm.recovery.k8s.reprotect.reverse.failed", new String[]{this.stage});
            }
            if (COMPLETED.equals(jobState)) break;
        }
        return this.success();
    }

    @Override
    protected List<Object> hashData() {
        List<Object> data = super.hashData();
        data.add(this.isProduct);
        data.add(this.stage);
        data.add(this.jobName);
        return data;
    }
}

