/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.kube.service.impl.task;

import com.huawei.ism.cbb.base.task.AbstractBackTask;
import com.huawei.ism.drm.kube.sdk.IKubeHandler;
import com.huawei.ism.drm.kube.sdk.model.ResourceSetInfo;
import com.huawei.ism.drm.kube.utils.KubeRefreshResourceUtils;
import com.huawei.lego.cbb.backtask.sdk.model.BackTask;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import java.util.Optional;
import java.util.concurrent.TimeUnit;

public class CreateResourceSetTask
extends AbstractBackTask {
    private static final Log LOGGER = LogFactory.getInstance(CreateResourceSetTask.class);
    private static final int DURATION = 5;
    private static final String RESOURCE_SET_STATUS_NORMAL = "Normal";
    private String kubeSn;
    private ResourceSetInfo resourceSetInfo;

    public CreateResourceSetTask(String taskId, String kubeSn, ResourceSetInfo resourceSetInfo, BackTask backTask) {
        super(taskId, backTask, true);
        this.kubeSn = kubeSn;
        this.resourceSetInfo = resourceSetInfo;
    }

    protected void doWork() {
        String resourceSetName = this.resourceSetInfo.getName();
        Optional optional = this.getKubeHandler().getResourceSetInfo(this.kubeSn, resourceSetName);
        if (optional.isPresent()) {
            LOGGER.error((Object)"Create resource set failed, target resource set (%s) of cluster (%s) is already exist", new Object[]{resourceSetName, this.kubeSn});
            throw new LegoCheckedException(1073947742L);
        }
        this.createResourceSetsAndCheckComplete(this.kubeSn, this.resourceSetInfo);
        KubeRefreshResourceUtils.refreshResourceSet(this.kubeSn, this.resourceSetInfo.getName());
    }

    private void createResourceSetsAndCheckComplete(String kubeSn, ResourceSetInfo resourceSetInfo) {
        long current;
        this.getKubeHandler().createKubeResourceSets(kubeSn, resourceSetInfo);
        String resourceSetName = resourceSetInfo.getName();
        long startTime = System.currentTimeMillis();
        do {
            CommonUtil.sleep((long)5L, (TimeUnit)TimeUnit.SECONDS);
            Optional optional = this.getKubeHandler().getResourceSetInfo(kubeSn, resourceSetName);
            if (!optional.isPresent()) {
                String message = "ResourceSet is not exist. name: " + resourceSetName;
                throw new LegoCheckedException(201L, message);
            }
            ResourceSetInfo createdResourceSet = (ResourceSetInfo)optional.get();
            String status = createdResourceSet.getStatus();
            if (!RESOURCE_SET_STATUS_NORMAL.equals(status)) continue;
            LOGGER.info((Object)"Create resourceSet (%s) complete, then start refresh it", new Object[]{resourceSetName});
            return;
        } while ((current = System.currentTimeMillis()) - startTime <= TimeUnit.MINUTES.toMillis(5L));
        LOGGER.error((Object)"Monitor resource set (%s) timeout", new Object[]{resourceSetName});
        throw new LegoCheckedException(1073947433L);
    }

    private IKubeHandler getKubeHandler() {
        return (IKubeHandler)ServiceLocator.getInstance().getService(IKubeHandler.class);
    }
}

