/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.host.agent.action;

import com.huawei.ism.base.sdk.model.NeMgrProtocolExtend;
import com.huawei.ism.cbb.util.NumberUtil;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.app.sdk.model.SnmpAuthInfo;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.host.util.HostDataCollectUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObjectStorageInfo;
import com.huawei.ism.drm.rest.client.RestClient;
import com.huawei.ism.drm.rest.client.util.URLContext;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.LegoBaseConfig;
import com.huawei.lego.core.sdk.util.WccEncryptor;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.message.BasicHeader;

public abstract class AgentRestAction {
    protected static final Log LOGGER = LogFactory.getInstance(AgentRestAction.class);
    private static final String HEADER_DB_USER_NAME = "dbUserName";
    private static final String HEADER_DB_USER_PWD = "dbPassword";
    private static final String HEADER_ASM_USER_NAME = "asmUserName";
    private static final String HEADER_ASM_USER_PWD = "asmPassword";
    private static final String HEADER_SNMP_USER_NAME = "snmpUsername";
    private static final String HEADER_SNMP_AUTH_PWD = "authPassword";
    private static final String HEADER_SNMP_ENCRYPT_PWD = "encryptPassword";
    private static final String X_AUTH_USER_KEY = "x-auth-user";
    private static final String X_AUTH_PWD_KEY = "x-auth-key";
    private static final int DEFAULT_RESPONSE_TIME_OUT = 1800000;
    private static final Map<String, RestClient> clientMap = new HashMap<String, RestClient>();
    private final NeMgrProtocolExtend extend;
    private final Map<String, String> headerMap = new HashMap<String, String>();
    private final String devSn;

    public AgentRestAction(NeMgrProtocolExtend extend, String devSn) {
        this.extend = extend;
        this.devSn = devSn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void releaseRestClient(String devSn) {
        if (VerifyUtil.isEmpty((String)devSn)) {
            LOGGER.warn((Object)"ReleaseRestClient failed, devSn is empty.");
            return;
        }
        Map<String, RestClient> map = clientMap;
        synchronized (map) {
            RestClient restClient = clientMap.remove(devSn);
            if (null != restClient) {
                restClient.closeHttpClient();
                LOGGER.info((Object)"ReleaseRestClient successful, devSn: %s, ip: %s", new Object[]{devSn, restClient.getIp()});
            }
        }
    }

    public String getDevSn() {
        int index = this.devSn.indexOf("_info");
        if (index > 0) {
            return this.devSn.substring(0, index);
        }
        return this.devSn;
    }

    public NeMgrProtocolExtend getExtend() {
        return this.extend;
    }

    protected String get(String url, Map<String, String> uriVariables) {
        return this.get(url, uriVariables, 1800000);
    }

    protected String get(String url, Map<String, String> uriVariables, int timeout) {
        String string;
        RestClient restClient = null;
        try {
            LOGGER.debug((Object)"Init restClient, get url: %s", new Object[]{url});
            restClient = this.buildRestClient(timeout);
            LOGGER.debug((Object)"Begin to get command, ip is: %s, url is: %s, uriVariables: %s", new Object[]{restClient.getIp(), url, uriVariables});
            this.encodeURIParams(uriVariables);
            String result = restClient.get(url, uriVariables, this.getHeaders());
            LOGGER.debug((Object)"Get command success, ip is: %s, url is: %s", new Object[]{restClient.getIp(), url});
            string = result;
        }
        catch (LegoCheckedException e) {
            try {
                this.processException(e);
                LOGGER.error((Object)"Get command error, get url: %s, uriVariables: %s", new Object[]{url, uriVariables, e});
                throw e;
            }
            catch (Throwable throwable) {
                LOGGER.debug((Object)"End get command, the devSn is: %s, url is: %s", new Object[]{this.devSn, url});
                this.releaseRestClient(restClient);
                throw throwable;
            }
        }
        LOGGER.debug((Object)"End get command, the devSn is: %s, url is: %s", new Object[]{this.devSn, url});
        this.releaseRestClient(restClient);
        return string;
    }

    protected String put(String url, String bodyParams, Map<String, String> uriVariables) {
        return this.put(url, bodyParams, uriVariables, 1800000);
    }

    protected String put(String url, String bodyParams, Map<String, String> uriVariables, int timeout) {
        String string;
        RestClient restClient = null;
        try {
            LOGGER.debug((Object)"Init rest client, get: %s", new Object[]{url});
            restClient = this.buildRestClient(timeout);
            LOGGER.info((Object)"Begin put command, ip: %s, put: %s, bodyParams: %s", new Object[]{restClient.getIp(), url, bodyParams});
            this.encodeURIParams(uriVariables);
            String result = restClient.put(url, bodyParams, uriVariables, this.getHeaders());
            LOGGER.debug((Object)"End put command, ip: %s, put: %s, result: %s", new Object[]{restClient.getIp(), url, result});
            string = result;
        }
        catch (LegoCheckedException e) {
            try {
                this.processException(e);
                LOGGER.error((Object)"Put command got error, put: %s, bodyParams: %s, erorrMsg: %s", new Object[]{url, bodyParams, ExceptionUtil.getErrorMessage((Throwable)e)});
                throw e;
            }
            catch (Throwable throwable) {
                LOGGER.info((Object)"End put command, devSn: %s, put: %s", new Object[]{this.devSn, url});
                this.releaseRestClient(restClient);
                throw throwable;
            }
        }
        LOGGER.info((Object)"End put command, devSn: %s, put: %s", new Object[]{this.devSn, url});
        this.releaseRestClient(restClient);
        return string;
    }

    protected String post(String url, Map<String, Object> params, Map<String, String> uriVariables) {
        JSONObject object = new JSONObject();
        if (null != params) {
            object = JSONObject.fromObject(params);
        }
        return this.post(url, object.toString(), uriVariables);
    }

    protected String post(String url, String bodyParams, Map<String, String> uriVariables) {
        return this.post(url, bodyParams, uriVariables, 1800000);
    }

    protected String post(String url, String bodyParams, Map<String, String> uriVariables, int timeout) {
        String string;
        RestClient restClient = null;
        try {
            LOGGER.debug((Object)"Init rest client, get: %s", new Object[]{url});
            restClient = this.buildRestClient(timeout);
            LOGGER.info((Object)"Begin post command, ip: %s, post: %s, bodyParams: %s", new Object[]{restClient.getIp(), url, bodyParams});
            this.encodeURIParams(uriVariables);
            String result = restClient.post(url, bodyParams, uriVariables, this.getHeaders());
            LOGGER.debug((Object)"End post command, ip: %s, post: %s, result: %s", new Object[]{restClient.getIp(), url, result});
            string = result;
        }
        catch (LegoCheckedException e) {
            try {
                this.processException(e);
                LOGGER.error((Object)"post command got error, put: %s, bodyParams: %s, errorMsg: %s", new Object[]{url, bodyParams, ExceptionUtil.getErrorMessage((Throwable)e)});
                throw e;
            }
            catch (Throwable throwable) {
                LOGGER.info((Object)"End post command, devSn: %s, post: %s", new Object[]{this.devSn, url});
                this.releaseRestClient(restClient);
                throw throwable;
            }
        }
        LOGGER.info((Object)"End post command, devSn: %s, post: %s", new Object[]{this.devSn, url});
        this.releaseRestClient(restClient);
        return string;
    }

    protected boolean downLoad(String url, String logFileName, Map<String, String> uriVariables, int timeout, String sn) {
        boolean bl;
        RestClient restClient = null;
        try {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put((Object)"sysInfoFile", (Object)logFileName);
            LOGGER.debug((Object)"init restclient, get: %s", new Object[]{url});
            restClient = this.buildRestClient(timeout);
            LOGGER.info((Object)"Begin post command, ip: %s , post bodyParams: %s", new Object[]{restClient.getIp(), jsonObject});
            this.encodeURIParams(uriVariables);
            String suffix = this.getSuffix(logFileName);
            String fileName = HostDataCollectUtil.getHostDataCollectLogFilePath() + sn + suffix;
            URLContext context = restClient.getURLContext(url, uriVariables);
            bl = restClient.downloadFile(context, jsonObject.toString(), this.getHeaders(), fileName, sn);
        }
        catch (LegoCheckedException e) {
            try {
                this.processException(e);
                LOGGER.error((Object)"Post command got error, put: %s, logFileName: %s, errorMsg: %s", new Object[]{url, logFileName, ExceptionUtil.getErrorMessage((Throwable)e)});
                throw e;
            }
            catch (Throwable throwable) {
                LOGGER.info((Object)"End post command downLoad: %s", new Object[]{url});
                this.releaseRestClient(restClient);
                throw throwable;
            }
        }
        LOGGER.info((Object)"End post command downLoad: %s", new Object[]{url});
        this.releaseRestClient(restClient);
        return bl;
    }

    private String getSuffix(String logFileName) {
        int dotIndex = logFileName.indexOf(".");
        if (dotIndex < 0) {
            LOGGER.error((Object)"Can't get logFileName suffix");
            throw new LegoCheckedException(1073947393L);
        }
        return logFileName.substring(dotIndex);
    }

    protected void delete(String url, String bodyParams, Map<String, String> uriVariables) {
        this.delete(url, bodyParams, uriVariables, 1800000);
    }

    protected void delete(String url, String bodyParams, Map<String, String> uriVariables, int timeout) {
        RestClient restClient = null;
        try {
            LOGGER.debug((Object)"Init restclient, get: %s", new Object[]{url});
            restClient = this.buildRestClient(timeout);
            LOGGER.info((Object)"Begin delete command, ip: %s, delete: %s, bodyParams: %s", new Object[]{restClient.getIp(), url, bodyParams});
            this.encodeURIParams(uriVariables);
            String result = restClient.delete(url, bodyParams, uriVariables, this.getHeaders());
            LOGGER.info((Object)"Delete command got success, ip: %s, delete: %s, result: %s", new Object[]{restClient.getIp(), url, result});
        }
        catch (LegoCheckedException e) {
            try {
                this.processException(e);
                LOGGER.error((Object)"Delete command got error, delete: %s, bodyParams: %s, errorMsg: %s", new Object[]{url, bodyParams, ExceptionUtil.getErrorMessage((Throwable)e)});
                throw e;
            }
            catch (Throwable throwable) {
                LOGGER.info((Object)"End delete command, devSn: %s, delete: %s", new Object[]{this.devSn, url});
                this.releaseRestClient(restClient);
                throw throwable;
            }
        }
        LOGGER.info((Object)"End delete command, devSn: %s, delete: %s", new Object[]{this.devSn, url});
        this.releaseRestClient(restClient);
    }

    private void processException(LegoCheckedException e) {
        if (e.getErrorCode() == 1073947398L || e.getErrorCode() == 1073947401L) {
            AgentRestAction.releaseRestClient(this.devSn);
        }
    }

    protected void buildHeaders(Map<String, String> params) {
        String dbUserName = params.get("USERNAME");
        String pwd = params.get("PASSWD");
        String asmUserName = params.get("ASM_USERNAME");
        String asmPwd = params.get("ASM_PASSWD");
        this.putHeaderMap(HEADER_DB_USER_NAME, dbUserName);
        this.putHeaderMap(HEADER_ASM_USER_NAME, asmUserName);
        if (null != pwd) {
            this.headerMap.put(HEADER_DB_USER_PWD, WccEncryptor.decrypt((String)pwd));
        }
        if (null != asmPwd) {
            this.headerMap.put(HEADER_ASM_USER_PWD, WccEncryptor.decrypt((String)asmPwd));
        }
    }

    protected void buildSnmpHeaders(SnmpAuthInfo snmpAuthInfo) {
        this.putHeaderMap(HEADER_SNMP_USER_NAME, snmpAuthInfo.getSecurityName());
        this.putHeaderMap(HEADER_SNMP_AUTH_PWD, snmpAuthInfo.getAuthPwd());
        this.putHeaderMap(HEADER_SNMP_ENCRYPT_PWD, snmpAuthInfo.getEncryptPwd());
    }

    private void putHeaderMap(String key, String value) {
        if (null == value) {
            LOGGER.debug((Object)"Key or value is null.");
            return;
        }
        this.headerMap.put(key, value);
    }

    private List<Header> getHeaders() {
        ArrayList<Header> headers = new ArrayList<Header>();
        headers.add((Header)new BasicHeader(X_AUTH_USER_KEY, (Object)this.extend.getNetworkUserName()));
        headers.add((Header)new BasicHeader(X_AUTH_PWD_KEY, (Object)this.extend.getNetworkPassword()));
        headers.add((Header)new BasicHeader("User-Agent", (Object)LegoBaseConfig.getDeployConfig().getKeyValue("version")));
        for (Map.Entry<String, String> entry : this.headerMap.entrySet()) {
            headers.add((Header)new BasicHeader(entry.getKey(), (Object)entry.getValue()));
        }
        return headers;
    }

    protected boolean isResultEmpty(String result) {
        return VerifyUtil.isEmpty((String)result) || "null".equals(result.trim());
    }

    private void encodeURIParams(Map<String, String> uriMap) {
        if (VerifyUtil.isEmpty(uriMap)) {
            LOGGER.debug((Object)"Uri map is null,not encode URIParams.");
            return;
        }
        HashMap<String, String> uriMapReplica = new HashMap<String, String>(uriMap);
        for (Map.Entry entry : uriMapReplica.entrySet()) {
            String key = (String)entry.getKey();
            String value = this.encodeURLParam((String)entry.getValue());
            uriMap.put(key, value);
        }
    }

    private String encodeURLParam(String param) {
        String encodedParam = "";
        if (VerifyUtil.isEmpty((String)param)) {
            return encodedParam;
        }
        try {
            encodedParam = URLEncoder.encode(param, "utf-8");
        }
        catch (Exception e) {
            LOGGER.error((Object)"Encode url exception, errorMsg: %s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
            encodedParam = param;
        }
        return encodedParam;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RestClient buildRestClient(int timeout) {
        RestClient restClient;
        String port = (String)this.extend.getExtendParams().get("port");
        int iPort = NumberUtil.parseInteger((Object)port);
        if (VerifyUtil.isEmpty((String)this.devSn)) {
            LOGGER.info((Object)"BuildRestClient, ip: %s", new Object[]{this.extend.getNetworkIpAddress()});
            restClient = new RestClient(this.extend.getNetworkIpAddress(), iPort, this.extend.getNetworkUserName(), this.extend.getNetworkPassword());
        } else {
            Map<String, RestClient> map = clientMap;
            synchronized (map) {
                restClient = clientMap.get(this.devSn);
                if (null == restClient) {
                    LOGGER.info((Object)"BuildRestClient, devSn: %s, ip: %s", new Object[]{this.devSn, this.extend.getNetworkIpAddress()});
                    restClient = new RestClient(this.extend.getNetworkIpAddress(), iPort, this.extend.getNetworkUserName(), this.extend.getNetworkPassword());
                    clientMap.put(this.devSn, restClient);
                }
            }
        }
        restClient.setTimeout(timeout);
        return restClient;
    }

    private void releaseRestClient(RestClient restClient) {
        if (VerifyUtil.isEmpty((String)this.devSn) && null != restClient) {
            LOGGER.info((Object)"ReleaseRestClient,ip: %s", new Object[]{restClient.getIp()});
            restClient.closeHttpClient();
        }
    }

    protected void setStorageType(ProtectObjectStorageInfo resource, String resourceId, String resourceProviderSN, String storageType) {
        if (VerifyUtil.isEmpty((String)resourceId) && VerifyUtil.isEmpty((String)resourceProviderSN)) {
            resource.setStorageType(Integer.valueOf(DrmEnumDefine.StorageTypeE.UNKNOWN.getValue()));
        } else if (VerifyUtil.isEmpty((String)storageType)) {
            resource.setStorageType(Integer.valueOf(DrmEnumDefine.StorageTypeE.NORMAL.getValue()));
        } else {
            resource.setStorageType(NumberUtil.convertToInteger((Object)storageType));
        }
    }
}

