/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.host.device.process;

import com.huawei.ism.base.sdk.model.Disk;
import com.huawei.ism.base.sdk.model.NeMgrProtocolExtend;
import com.huawei.ism.drm.app.sdk.model.HostDeviceStorageInfo;
import com.huawei.ism.drm.host.agent.action.HostAction;
import com.huawei.ism.drm.host.device.process.IDeviceProcessor;
import com.huawei.ism.drm.host.sdk.model.DrHost;
import com.huawei.ism.drm.host.util.DrHostDeviceUtil;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public abstract class AbstractDiskProcessor
implements IDeviceProcessor {
    private static final Log LOGGER = LogFactory.getInstance(AbstractDiskProcessor.class);
    private static final int RETRY_TIMES = 3;
    private static final long SLEEP_TIME_AFTER_SCANDISK = 10000L;
    private static final int PROCESS_ORDER = 120;
    private static final int CLEAN_ORDER = 110;

    @Override
    public String getName() {
        return this.getClass().getName();
    }

    @Override
    public boolean process(RecoveryProcessorContext context) {
        NeMgrProtocolExtend neMgrExtend = (NeMgrProtocolExtend)context.getAttribute("HOST_AUTH_INFO");
        List hostDeviceStorageInfos = (List)context.getAttribute("HOST_DEVICE_INFO");
        DrHost drHost = (DrHost)context.getAttribute("HOST_INFO");
        boolean isAllMatched = false;
        HostAction hostAction = new HostAction(neMgrExtend, drHost.getDeviceSn());
        for (int i = 0; i < 3; ++i) {
            LOGGER.info((Object)("refresh host device at " + (i + 1) + "th time."), 90160758786988L);
            try {
                hostAction.scanDisk();
            }
            catch (Exception e) {
                LOGGER.warn((Object)(drHost.getDeviceSn() + "not supported scan disk"), 90160758786989L);
            }
            try {
                if (this.matchStroageInfo(hostAction, hostDeviceStorageInfos)) {
                    isAllMatched = true;
                    List<Disk> disks = hostAction.queryDisks();
                    Map<String, List<Disk>> diskMap = DrHostDeviceUtil.buildDiskInfoMap(disks);
                    context.setAttribute("HOST_DISKS_INFO", disks);
                    this.updateDeviceName(context, drHost, hostDeviceStorageInfos, diskMap, hostAction, false);
                    break;
                }
                Thread.sleep(10000L);
                continue;
            }
            catch (Exception e) {
                ExceptionUtil.rethrowException((Throwable)e, (String)"query volume info error.", (long)1073948173L, null, (Log)LOGGER);
            }
        }
        if (!isAllMatched) {
            throw new LegoCheckedException(1073948760L, new String[]{drHost.getName()});
        }
        return isAllMatched;
    }

    private boolean matchStroageInfo(HostAction hostAction, List<HostDeviceStorageInfo> hostDeviceStorageInfos) {
        List<Disk> disks = hostAction.queryDisks();
        Map<String, List<Disk>> diskMap = DrHostDeviceUtil.buildDiskInfoMap(disks);
        if (this.isAllDisksMatched(diskMap, hostDeviceStorageInfos)) {
            return true;
        }
        hostAction.scanDisk();
        disks = hostAction.queryDisks();
        diskMap = DrHostDeviceUtil.buildDiskInfoMap(disks);
        return this.isAllDisksMatched(diskMap, hostDeviceStorageInfos);
    }

    @Override
    public boolean clean(RecoveryProcessorContext context) {
        NeMgrProtocolExtend neMgrExtend = (NeMgrProtocolExtend)context.getAttribute("HOST_AUTH_INFO");
        List hostDeviceStorageInfos = (List)context.getAttribute("HOST_DEVICE_INFO");
        DrHost drHost = (DrHost)context.getAttribute("HOST_INFO");
        HostAction hostAction = new HostAction(neMgrExtend, drHost.getDeviceSn());
        List<Disk> disks = hostAction.queryDisks();
        Map<String, List<Disk>> diskMap = DrHostDeviceUtil.buildDiskInfoMap(disks);
        List<HostDeviceStorageInfo> filteredStorageInfos = this.filterHostDeviceStorageInfos(diskMap, hostDeviceStorageInfos);
        this.updateDeviceName(context, drHost, filteredStorageInfos, diskMap, hostAction, true);
        context.setAttribute("HOST_DISKS_INFO", disks);
        context.setAttribute("HOST_DEVICE_INFO", filteredStorageInfos);
        return true;
    }

    @Override
    public int getProcessOrder() {
        return 120;
    }

    @Override
    public int getCleanOrder() {
        return 110;
    }

    protected abstract void updateDeviceName(RecoveryProcessorContext var1, DrHost var2, List<HostDeviceStorageInfo> var3, Map<String, List<Disk>> var4, HostAction var5, boolean var6);

    private boolean isAllDisksMatched(Map<String, List<Disk>> diskMap, List<HostDeviceStorageInfo> hostDeviceStorageInfos) {
        boolean isMatched = true;
        List<HostDeviceStorageInfo> filteredStorageInfos = this.filterHostDeviceStorageInfos(diskMap, hostDeviceStorageInfos);
        if (filteredStorageInfos.size() != hostDeviceStorageInfos.size()) {
            isMatched = false;
        }
        return isMatched;
    }

    private List<HostDeviceStorageInfo> filterHostDeviceStorageInfos(Map<String, List<Disk>> diskMap, List<HostDeviceStorageInfo> hostDeviceStorageInfos) {
        ArrayList<HostDeviceStorageInfo> filteredStorageInfos = new ArrayList<HostDeviceStorageInfo>();
        for (HostDeviceStorageInfo hostDeviceStorageInfo : hostDeviceStorageInfos) {
            String key = hostDeviceStorageInfo.getDeviceId() + "_" + hostDeviceStorageInfo.getLunId();
            if (!diskMap.containsKey(key) && !diskMap.containsKey(hostDeviceStorageInfo.getWwn())) {
                LOGGER.error((Object)(key + "(wwn: " + hostDeviceStorageInfo.getWwn() + ") has not matched."), 90160758786989L);
                continue;
            }
            filteredStorageInfos.add(hostDeviceStorageInfo);
        }
        return filteredStorageInfos;
    }
}

