/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.host.device.process;

import com.huawei.ism.base.sdk.model.NeMgrProtocolExtend;
import com.huawei.ism.cbb.util.NumberUtil;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.app.sdk.model.HostDeviceStorageInfo;
import com.huawei.ism.drm.host.agent.action.DeviceAction;
import com.huawei.ism.drm.host.device.process.IDeviceProcessor;
import com.huawei.ism.drm.host.sdk.model.DrHost;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public class ConfigDevicePermissionProcessor
implements IDeviceProcessor {
    private static final Log LOGGER = LogFactory.getInstance(ConfigDevicePermissionProcessor.class);
    private static final int PROCESS_ORDER = 180;
    private static final int CLEAN_ORDER = 999;

    @Override
    public String getName() {
        return this.getClass().getName();
    }

    @Override
    public boolean process(RecoveryProcessorContext context) {
        NeMgrProtocolExtend neMgrExtend = (NeMgrProtocolExtend)context.getAttribute("HOST_AUTH_INFO");
        List hostDeviceStorageInfos = (List)context.getAttribute("HOST_DEVICE_INFO");
        DrHost drHost = (DrHost)context.getAttribute("HOST_INFO");
        List<HostDeviceStorageInfo> setPermissionStorageInfos = this.buildSetPermissionStorageInfos(hostDeviceStorageInfos);
        if (VerifyUtil.isEmpty(setPermissionStorageInfos)) {
            return true;
        }
        DeviceAction deviceAction = new DeviceAction(neMgrExtend, drHost.getDeviceSn());
        deviceAction.setPermission(setPermissionStorageInfos);
        return true;
    }

    @Override
    public boolean clean(RecoveryProcessorContext context) {
        return true;
    }

    private List<HostDeviceStorageInfo> buildSetPermissionStorageInfos(List<HostDeviceStorageInfo> hostDeviceStorageInfos) {
        ArrayList<HostDeviceStorageInfo> setPermissionStorageInfos = new ArrayList<HostDeviceStorageInfo>();
        for (HostDeviceStorageInfo hostDeviceStorageInfo : hostDeviceStorageInfos) {
            int storageType = hostDeviceStorageInfo.getStorageType();
            if (storageType != 3 && storageType != 1 && storageType != 4) continue;
            if (hostDeviceStorageInfo.getErrorCode() != 0L) {
                LOGGER.warn((Object)("The storage info(wwn: " + hostDeviceStorageInfo.getWwn() + ", deviceName" + hostDeviceStorageInfo.getDeviceName() + ") has error, errorCode: " + hostDeviceStorageInfo.getErrorCode()), 90160758786989L);
                continue;
            }
            setPermissionStorageInfos.add(hostDeviceStorageInfo);
            this.setDeviceStorageInfoAppUserName(hostDeviceStorageInfo);
        }
        return setPermissionStorageInfos;
    }

    private void setDeviceStorageInfoAppUserName(HostDeviceStorageInfo hostDeviceStorageInfo) {
        Integer appType = hostDeviceStorageInfo.getAppType();
        Integer storageType = hostDeviceStorageInfo.getStorageType();
        if (null != appType && appType == 1) {
            if (this.isOracleNewVersion(hostDeviceStorageInfo.getAppVersion()) && 3 == storageType) {
                hostDeviceStorageInfo.setAppUserName("grid");
            } else {
                hostDeviceStorageInfo.setAppUserName("oracle");
            }
        }
    }

    private boolean isOracleNewVersion(String appVersion) {
        if (VerifyUtil.isEmpty((String)appVersion)) {
            return false;
        }
        String[] versions = appVersion.split(Pattern.quote("."));
        if (versions.length < 2) {
            return false;
        }
        Integer mainVersion = NumberUtil.parseInteger((Object)versions[0]);
        Integer subVersion = NumberUtil.parseInteger((Object)versions[1]);
        return mainVersion > 11 || mainVersion == 11 && subVersion >= 2;
    }

    @Override
    public boolean needProcess(RecoveryProcessorContext context) {
        List hostDeviceStorageInfos = (List)context.getAttribute("HOST_DEVICE_INFO");
        return !VerifyUtil.isEmpty(this.buildSetPermissionStorageInfos(hostDeviceStorageInfos));
    }

    @Override
    public int getProcessOrder() {
        return 180;
    }

    @Override
    public int getCleanOrder() {
        return 999;
    }
}

