/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.host.device.process;

import com.huawei.ism.base.sdk.model.NeMgrProtocolExtend;
import com.huawei.ism.cbb.util.NumberUtil;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.app.constants.DrmAppEnumDefine;
import com.huawei.ism.drm.app.sdk.model.HostDeviceStorageInfo;
import com.huawei.ism.drm.host.agent.action.DeviceAction;
import com.huawei.ism.drm.host.device.process.IDeviceProcessor;
import com.huawei.ism.drm.host.sdk.model.DrHost;
import com.huawei.ism.drm.host.util.DrHostDeviceUtil;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ConfigureMultipathProcessor
implements IDeviceProcessor {
    private static final Log LOGGER = LogFactory.getInstance(ConfigureMultipathProcessor.class);
    private static final int PROCESS_ORDER = 90;
    private static final int CLEAN_ORDER = 200;

    @Override
    public String getName() {
        return this.getClass().getName();
    }

    @Override
    public boolean process(RecoveryProcessorContext context) {
        NeMgrProtocolExtend neMgrExtend = (NeMgrProtocolExtend)context.getAttribute("HOST_AUTH_INFO");
        List hostDeviceStorageInfos = (List)context.getAttribute("HOST_DEVICE_INFO");
        DrHost drHost = (DrHost)context.getAttribute("HOST_INFO");
        ArrayList<Map<String, String>> multipathList = new ArrayList<Map<String, String>>();
        try {
            DeviceAction deviceAction = new DeviceAction(neMgrExtend, drHost.getDeviceSn());
            for (HostDeviceStorageInfo hostDeviceStorageInfo : hostDeviceStorageInfos) {
                if (VerifyUtil.isEmpty((String)hostDeviceStorageInfo.getAlias())) continue;
                HashMap<String, String> multipathMap = new HashMap<String, String>();
                multipathMap.put("wwn", hostDeviceStorageInfo.getWwn());
                multipathMap.put("alias", hostDeviceStorageInfo.getAlias());
                multipathList.add(multipathMap);
            }
            if (!VerifyUtil.isEmpty(multipathList)) {
                deviceAction.configureMultipath(multipathList);
            }
        }
        catch (LegoCheckedException legoEx) {
            LOGGER.error((Object)legoEx.getMessage(), (Throwable)legoEx, 90160758787071L);
            Map<String, List<HostDeviceStorageInfo>> storageInfoMap = DrHostDeviceUtil.buildStorageInfoMapByWwn(hostDeviceStorageInfos);
            DrHostDeviceUtil.parseAndUpdateStorageErrorCodeInfo(legoEx, "wwn", storageInfoMap);
            return false;
        }
        return true;
    }

    @Override
    public boolean clean(RecoveryProcessorContext context) {
        NeMgrProtocolExtend neMgrExtend = (NeMgrProtocolExtend)context.getAttribute("HOST_AUTH_INFO");
        List hostDeviceStorageInfos = (List)context.getAttribute("HOST_DEVICE_INFO");
        DrHost drHost = (DrHost)context.getAttribute("HOST_INFO");
        ArrayList<Map<String, String>> multipathList = new ArrayList<Map<String, String>>();
        try {
            DeviceAction deviceAction = new DeviceAction(neMgrExtend, drHost.getDeviceSn());
            for (HostDeviceStorageInfo hostDeviceStorageInfo : hostDeviceStorageInfos) {
                HashMap<String, String> multipathMap = new HashMap<String, String>();
                multipathMap.put("wwn", hostDeviceStorageInfo.getWwn());
                multipathMap.put("alias", hostDeviceStorageInfo.getAlias());
                multipathList.add(multipathMap);
            }
            deviceAction.deleteMultipath(multipathList);
        }
        catch (LegoCheckedException legoEx) {
            LOGGER.error((Object)legoEx.getMessage(), (Throwable)legoEx, 90160758787071L);
            Map<String, List<HostDeviceStorageInfo>> storageInfoMap = DrHostDeviceUtil.buildStorageInfoMapByWwn(hostDeviceStorageInfos);
            DrHostDeviceUtil.parseAndUpdateStorageErrorCodeInfo(legoEx, "wwn", storageInfoMap);
            return false;
        }
        return true;
    }

    @Override
    public boolean needProcess(RecoveryProcessorContext context) {
        DrHost drHost = (DrHost)context.getAttribute("HOST_INFO");
        DrmAppEnumDefine.CLUSTER_TYPE_E clusterType = (DrmAppEnumDefine.CLUSTER_TYPE_E)context.getAttribute("CLUSTER_TYPE");
        Integer osType = NumberUtil.parseInteger((Object)drHost.getOsType());
        return DrmAppEnumDefine.OS_TYPE_E.isLinux((int)osType) && DrmAppEnumDefine.CLUSTER_TYPE_E.isMultipath((DrmAppEnumDefine.CLUSTER_TYPE_E)clusterType);
    }

    @Override
    public int getProcessOrder() {
        return 90;
    }

    @Override
    public int getCleanOrder() {
        return 200;
    }
}

