/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.host.device.process;

import com.huawei.ism.base.sdk.model.Disk;
import com.huawei.ism.base.sdk.model.NeMgrProtocolExtend;
import com.huawei.ism.cbb.util.NumberUtil;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.app.constants.DrmAppEnumDefine;
import com.huawei.ism.drm.app.sdk.model.HostDeviceStorageInfo;
import com.huawei.ism.drm.host.agent.action.DeviceAction;
import com.huawei.ism.drm.host.agent.action.HostAction;
import com.huawei.ism.drm.host.device.process.AbstractDiskProcessor;
import com.huawei.ism.drm.host.sdk.model.DrHost;
import com.huawei.ism.drm.host.util.DrHostDeviceUtil;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class SolarisDiskProcessor
extends AbstractDiskProcessor {
    private static final Log LOGGER = LogFactory.getInstance(SolarisDiskProcessor.class);

    @Override
    public boolean process(RecoveryProcessorContext context) {
        boolean result = super.process(context);
        if (!result) {
            LOGGER.info((Object)"scan disk fail.", 90160758786988L);
            return result;
        }
        if (!this.isVxvm(context)) {
            LOGGER.info((Object)"check vxvm is false.", 90160758786988L);
            return true;
        }
        NeMgrProtocolExtend extend = (NeMgrProtocolExtend)context.getAttribute("HOST_AUTH_INFO");
        DrHost drHost = (DrHost)context.getAttribute("HOST_INFO");
        DeviceAction deviceAction = new DeviceAction(extend, drHost.getDeviceSn());
        LOGGER.info((Object)"scan vxvm disk.", 90160758786988L);
        try {
            deviceAction.scanVxvmDisk();
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)"scan vxvm disk error.", (long)1073948173L, null, (Log)LOGGER);
            return false;
        }
        return true;
    }

    private boolean isVxvm(RecoveryProcessorContext context) {
        List hostDeviceStorageInfos = (List)context.getAttribute("HOST_DEVICE_INFO");
        if (VerifyUtil.isEmpty((Collection)hostDeviceStorageInfos)) {
            LOGGER.info((Object)"check vxvm,hostDeviceStorageInfos is null.", 90160758786988L);
            return false;
        }
        for (HostDeviceStorageInfo hostDeviceStorageInfo : hostDeviceStorageInfos) {
            if (2 != hostDeviceStorageInfo.getStorageSubType()) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void updateDeviceName(RecoveryProcessorContext context, DrHost drHost, List<HostDeviceStorageInfo> hostDeviceStorageInfos, Map<String, List<Disk>> diskMap, HostAction hostAction, boolean isClean) {
        for (HostDeviceStorageInfo hostDeviceStorageInfo : hostDeviceStorageInfos) {
            if (!DrHostDeviceUtil.isNeedUpdateDeviceName(hostDeviceStorageInfo.getDeviceName(), hostDeviceStorageInfo.getStorageSubType(), hostDeviceStorageInfo.getUdevRules())) continue;
            List<Disk> disks = DrHostDeviceUtil.getDiskByStorageInfo(hostDeviceStorageInfo, diskMap);
            if (null == disks || disks.isEmpty()) {
                String key = hostDeviceStorageInfo.getDeviceId() + "_" + hostDeviceStorageInfo.getLunId() + "_" + hostDeviceStorageInfo.getSnapshotId();
                LOGGER.error((Object)("Cannot find the disk(key:" + key + ", wwn:" + hostDeviceStorageInfo.getWwn() + ")"), 90160758786989L);
                continue;
            }
            this.updateDeviceStorageDeviceName(hostDeviceStorageInfo, disks);
        }
    }

    private void updateDeviceStorageDeviceName(HostDeviceStorageInfo hostDeviceStorageInfo, List<Disk> disks) {
        String deviceName = hostDeviceStorageInfo.getDeviceName();
        if (null == deviceName || deviceName.length() < 2) {
            LOGGER.error((Object)("device name is empty or length less than two." + deviceName));
            return;
        }
        String partition = deviceName.substring(deviceName.length() - 2);
        hostDeviceStorageInfo.setDeviceName(disks.get(0).getDiskName() + partition);
    }

    @Override
    public boolean needProcess(RecoveryProcessorContext context) {
        DrHost drHost = (DrHost)context.getAttribute("HOST_INFO");
        Integer osType = NumberUtil.parseInteger((Object)drHost.getOsType());
        DrmAppEnumDefine.OS_TYPE_E eOsType = DrmAppEnumDefine.OS_TYPE_E.getType((int)osType);
        return DrmAppEnumDefine.OS_TYPE_E.SOLARIS == eOsType;
    }
}

