/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.host.device.process;

import com.huawei.ism.base.sdk.model.NeMgrProtocolExtend;
import com.huawei.ism.cbb.util.NumberUtil;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.app.constants.DrmAppEnumDefine;
import com.huawei.ism.drm.app.sdk.model.HostDeviceStorageInfo;
import com.huawei.ism.drm.host.agent.action.DeviceAction;
import com.huawei.ism.drm.host.device.process.FileSystemProcessor;
import com.huawei.ism.drm.host.sdk.model.DrHost;
import com.huawei.ism.drm.host.util.DrHostDeviceUtil;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.host.sdk.model.HostFileSystem;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class WindowsFileSystemProcessor
extends FileSystemProcessor {
    private static final Log LOGGER = LogFactory.getInstance(WindowsFileSystemProcessor.class);

    @Override
    public boolean process(RecoveryProcessorContext context) {
        NeMgrProtocolExtend neMgrExtend = (NeMgrProtocolExtend)context.getAttribute("HOST_AUTH_INFO");
        List hostDeviceStorageInfos = (List)context.getAttribute("HOST_DEVICE_INFO");
        DrHost drHost = (DrHost)context.getAttribute("HOST_INFO");
        List<HostDeviceStorageInfo> fsStorageInfos = this.buildFileSystemStorageInfos(hostDeviceStorageInfos);
        if (VerifyUtil.isEmpty(fsStorageInfos)) {
            return true;
        }
        try {
            DrmAppEnumDefine.CLUSTER_TYPE_E clustertype = (DrmAppEnumDefine.CLUSTER_TYPE_E)context.getAttribute("CLUSTER_TYPE");
            if (DrmAppEnumDefine.CLUSTER_TYPE_E.SQL_SERVER_MSFC != clustertype) {
                DeviceAction deviceAction = new DeviceAction(neMgrExtend, drHost.getDeviceSn());
                this.umountIncorrectMountpoint(hostDeviceStorageInfos, deviceAction);
                deviceAction.mountFileSystems(fsStorageInfos);
            }
        }
        catch (LegoCheckedException legoEx) {
            LOGGER.error((Object)legoEx.getMessage(), (Throwable)legoEx, 90160758787071L);
            Map<String, List<HostDeviceStorageInfo>> storageInfoMap = DrHostDeviceUtil.buildStorageInfoMapByDeviceName(fsStorageInfos);
            DrHostDeviceUtil.parseAndUpdateStorageErrorCodeInfo(legoEx, "deviceName", storageInfoMap);
            return false;
        }
        return true;
    }

    private void umountIncorrectMountpoint(List<HostDeviceStorageInfo> fsStorageInfos, DeviceAction deviceAction) {
        List<HostFileSystem> fsSystems = deviceAction.queryFileSystems();
        HashMap<String, String> deviceNameMap = new HashMap<String, String>();
        for (HostFileSystem fsSystem : fsSystems) {
            if (VerifyUtil.isEmpty((String)fsSystem.getAttachVol()) || VerifyUtil.isEmpty((String)fsSystem.getMount())) continue;
            deviceNameMap.put(fsSystem.getAttachVol(), fsSystem.getMount());
        }
        ArrayList<HostDeviceStorageInfo> umountFsStorageInfos = new ArrayList<HostDeviceStorageInfo>();
        for (HostDeviceStorageInfo fsStorageInfo : fsStorageInfos) {
            String mountPoint = (String)deviceNameMap.get(fsStorageInfo.getDeviceName());
            if (null == mountPoint || mountPoint.equals(fsStorageInfo.getMountPoint())) continue;
            LOGGER.warn((Object)("Current mount point is not equals produce host mount point, current mountpoint: " + mountPoint + ", produce mountpoint: " + fsStorageInfo.getMountPoint() + ", lun wwn: " + fsStorageInfo.getWwn()), 90160758786988L);
            HostDeviceStorageInfo umountFsStorageInfo = new HostDeviceStorageInfo();
            umountFsStorageInfo.setDeviceName(fsStorageInfo.getDeviceName());
            umountFsStorageInfo.setMountPoint(mountPoint);
            umountFsStorageInfo.setStorageSubType(fsStorageInfo.getStorageSubType());
            umountFsStorageInfos.add(umountFsStorageInfo);
        }
        if (!VerifyUtil.isEmpty(umountFsStorageInfos)) {
            LOGGER.warn((Object)"Send umount filesystem command.", 90160758786988L);
            deviceAction.deleteDriveLetter(umountFsStorageInfos);
        }
    }

    @Override
    public boolean needProcess(RecoveryProcessorContext context) {
        List hostDeviceStorageInfos = (List)context.getAttribute("HOST_DEVICE_INFO");
        DrHost drHost = (DrHost)context.getAttribute("HOST_INFO");
        Integer iOsType = NumberUtil.parseInteger((Object)drHost.getOsType());
        DrmAppEnumDefine.OS_TYPE_E osType = DrmAppEnumDefine.OS_TYPE_E.getType((int)iOsType);
        if (DrmAppEnumDefine.OS_TYPE_E.WINDOWS != osType) {
            return false;
        }
        return !VerifyUtil.isEmpty(this.buildFileSystemStorageInfos(hostDeviceStorageInfos));
    }
}

