/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.host.discovery.msg;

import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.util.NumberUtil;
import com.huawei.ism.drm.base.util.AlarmReporter;
import com.huawei.ism.drm.host.agent.action.AgentRestAction;
import com.huawei.ism.drm.host.util.HostDataCollectUtil;
import com.huawei.ism.drm.license.sdk.ILicenseControl;
import com.huawei.ism.drm.site.resource.sdk.service.IResourceService;
import com.huawei.ism.drm.site.sdk.model.DrResource;
import com.huawei.ism.host.sdk.model.Host;
import com.huawei.lego.comm.internal.jms.IMessageCenter;
import com.huawei.lego.comm.internal.jms.MessageRegister;
import com.huawei.lego.comm.internal.jms.MessageTaskManager;
import com.huawei.lego.comm.internal.jms.MessageTopic;
import com.huawei.lego.comm.internal.jms.MessageUnit;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.io.File;
import java.util.Map;

public class HostMessageSubscriber
extends MessageTaskManager {
    private static final Log LOGGER = LogFactory.getInstance(HostMessageSubscriber.class);

    public HostMessageSubscriber(IMessageCenter msgCenter) {
        msgCenter.addSubscriberTo((MessageTaskManager)this);
    }

    public MessageRegister[] getTypes() {
        MessageRegister[] mrs = MessageRegister.getMessageRegisters((int)1);
        mrs[0].setMessageTopic(MessageTopic.DATA);
        mrs[0].addMessageCode(105L);
        return mrs;
    }

    public void onMessage(MessageUnit mu) {
        long msgType = mu.getCmdcode();
        if (105L != msgType) {
            LOGGER.error((Object)("Message was not subscribed, msgType: " + msgType), 90160758786876L);
            return;
        }
        Object msg = mu.getObj();
        if (!(msg instanceof Map)) {
            return;
        }
        Map objs = (Map)msg;
        for (Object obj : objs.values()) {
            if (!(obj instanceof Host)) continue;
            Host host = (Host)obj;
            this.deleteDrHostAndHostGroup(host);
            this.restoreHostAlarm(host);
            this.deleteHostLogFile(host);
            this.restoreLicenseAlarm();
        }
    }

    private void deleteDrHostAndHostGroup(Host host) {
        IResourceService resourceService = (IResourceService)ServiceLocator.getInstance().getService(IResourceService.class);
        try {
            DrResource drResource = resourceService.getDrResourceBySnInLocalSite(host.getSn(), "ism.drm.deviceType.drhost.mainType");
            if (null == drResource) {
                LOGGER.error((Object)("DrResource is null,hostName=" + host.getName() + ",hostSn=" + host.getSn()), 90160758786876L);
                return;
            }
            CommonDAOLocator.getBaseDao().getHibernateTemplate().delete((Object)drResource);
        }
        catch (Exception ex) {
            LOGGER.error((Object)("delete resource failed, Name: " + host.getName() + ExceptionUtil.getErrorMessage((Throwable)ex)), 90160758786876L);
        }
        AgentRestAction.releaseRestClient(host.getSn());
    }

    private void restoreHostAlarm(Host host) {
        try {
            AlarmReporter.restoreAlarm((long)52625429L, (String[])new String[]{host.getUuid()});
            AlarmReporter.restoreAlarm((long)60149202961L, (String[])new String[]{host.getUuid()});
            AlarmReporter.restoreAlarm((long)52625439L, (String[])new String[]{host.getUuid()});
        }
        catch (Exception ex) {
            LOGGER.error((Object)("restoreHostAlarm failed, Name: " + host.getName() + ExceptionUtil.getErrorMessage((Throwable)ex)), 90160758786876L);
        }
    }

    private void deleteHostLogFile(Host host) {
        try {
            int osType = NumberUtil.parseInteger((Object)host.getOs());
            String suffix = 1 == osType ? ".zip" : ".tar.gz";
            File logFile = new File(HostDataCollectUtil.getHostDataCollectLogFilePath() + host.getSn() + suffix);
            if (logFile.exists()) {
                boolean result = logFile.delete();
                LOGGER.debug((Object)("delete host log file,result=" + result + ",hostName=" + host.getName() + ",hostSn=" + host.getSn()), 90160758786876L);
            }
        }
        catch (Exception ex) {
            LOGGER.error((Object)("delete host log file failed, Name: " + host.getName() + ExceptionUtil.getErrorMessage((Throwable)ex)), 90160758786876L);
        }
    }

    private void restoreLicenseAlarm() {
        try {
            ILicenseControl licenseControl = (ILicenseControl)ServiceLocator.getInstance().getService(ILicenseControl.class);
            licenseControl.checkLicenseRestoreAlarm();
        }
        catch (Exception ex) {
            LOGGER.error((Object)("restore license alarm failed" + ExceptionUtil.getErrorMessage((Throwable)ex)), 90160758786876L);
        }
    }
}

