/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.host.discovery.processer;

import com.huawei.ism.base.sdk.model.NeMgrProtocolExtend;
import com.huawei.ism.base.sdk.model.NetworkEntity;
import com.huawei.ism.cbb.discover.framework.AbstractContext;
import com.huawei.ism.cbb.discover.framework.IProcessor;
import com.huawei.ism.cbb.util.NumberUtil;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.host.sdk.service.IHostRetrieveProxy;
import com.huawei.ism.drm.host.util.DrHostUtil;
import com.huawei.ism.drm.site.util.SiteResourceManagerUtil;
import com.huawei.ism.host.sdk.model.Host;
import com.huawei.lego.cbb.resource.sdk.model.Node;
import com.huawei.lego.com.south.sdk.model.SnmpPara;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.WccEncryptor;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class HostBaseProcessor
implements IProcessor {
    private static final Log LOGGER = LogFactory.getInstance(HostBaseProcessor.class);

    public void clean(AbstractContext arg0) {
    }

    public String getName() {
        return this.getClass().getSimpleName();
    }

    public void postProcess(AbstractContext arg0) {
    }

    public boolean process(AbstractContext context) {
        Object neMgrProtocalExtendObj = context.getAttribute("NeMgrProtocolExtend");
        NeMgrProtocolExtend extend = (NeMgrProtocolExtend)neMgrProtocalExtendObj;
        if (VerifyUtil.isEmpty((String)extend.getNetworkIpAddress()) || null == extend.getExtendParams() || null == extend.getExtendParams().get("port")) {
            LOGGER.error((Object)"IP or port is null,and discovering host is failed.", 90160758786989L);
            throw new LegoCheckedException(1073947393L);
        }
        LOGGER.info((Object)("start to discover host(" + extend.getNetworkIpAddress() + ")."), 90160777660693L);
        String action = (String)context.getAttribute("DiscoveryType");
        Host existHost = DrHostUtil.getExistHost(extend);
        String location = (String)context.getAttribute("Location");
        Host host = this.getHostBasicInfo(context, existHost, extend, location, action);
        if (null != existHost) {
            this.setManagementProtocolMap(host, extend);
        } else {
            NetworkEntity array = (NetworkEntity)context.getAttribute("StorageDevice");
            if (null != array) {
                host.setManagementProtocolMap(array.getManagementProtocolMap());
            }
        }
        this.setHostInitiators(context, extend);
        DrHostUtil.setHostDisks(host, extend);
        context.setAttribute("DRMHOST", (Object)host);
        return true;
    }

    private void setManagementProtocolMap(Host host, NeMgrProtocolExtend extend) {
        Map paramMap = extend.getExtendParams();
        if (null == paramMap || null == paramMap.get("snmpVersion")) {
            return;
        }
        try {
            SnmpPara snmpPara = new SnmpPara();
            snmpPara.setAuthProtocol((String)paramMap.get("snmpAuthProtocol"));
            snmpPara.setAuthPwd(WccEncryptor.decrypt((String)((String)paramMap.get("snmpAuthPwd"))));
            snmpPara.setContextEngineId((String)paramMap.get("snmpContextEngineId"));
            snmpPara.setContextName((String)paramMap.get("snmpContextName"));
            snmpPara.setEncryptProtocol((String)paramMap.get("snmpEncryptProtocol"));
            snmpPara.setEncryptPwd(WccEncryptor.decrypt((String)((String)paramMap.get("snmpEncryptPwd"))));
            snmpPara.setRetries(NumberUtil.convertToInteger(paramMap.get("snmpRetries")).intValue());
            snmpPara.setSecurityName((String)paramMap.get("snmpSecurityName"));
            snmpPara.setTimeout(NumberUtil.convertToInteger(paramMap.get("snmpTimeout")).intValue());
            if (!"SNMPv3".equalsIgnoreCase((String)paramMap.get("snmpVersion"))) {
                return;
            }
            snmpPara.setVersion(3);
            snmpPara.setPort(NumberUtil.convertToInteger(paramMap.get("snmpPort")).intValue());
            snmpPara.setNode((Node)host);
            HashMap<String, SnmpPara> protocolMap = new HashMap<String, SnmpPara>();
            protocolMap.put(SnmpPara.class.getName(), snmpPara);
            host.setManagementProtocolMap(protocolMap);
        }
        catch (Exception e) {
            LOGGER.error((Object)("set snmp param exception." + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758786880L);
        }
    }

    private Host getHostBasicInfo(AbstractContext context, Host existHost, NeMgrProtocolExtend extend, String location, String action) {
        Host host;
        try {
            IHostRetrieveProxy hostRetrieveProxy = (IHostRetrieveProxy)ServiceLocator.getInstance().getService(IHostRetrieveProxy.class);
            host = hostRetrieveProxy.queryHostDetail(extend);
            LOGGER.info((Object)"get host basic info get return info.", 90160758786989L);
        }
        catch (LegoCheckedException e) {
            LOGGER.error((Object)("get host(" + extend.getNetworkIpAddress() + ")'basic info failed."), (Throwable)e, 90160758786989L);
            if (null == existHost) {
                LOGGER.info((Object)("the host(" + extend.getNetworkIpAddress() + ")'is register at first time."), 90160758786989L);
                throw e;
            }
            if ("register".equals(action)) {
                LOGGER.info((Object)("the host(" + extend.getNetworkIpAddress() + ")'is registered,and this time failed."), 90160758786988L);
                throw e;
            }
            LOGGER.info((Object)("the host(" + extend.getNetworkIpAddress() + ")'is offline,and change its status."), 90160758786988L);
            context.setAttribute("DiscoveryError_" + existHost.getHostSN(), (Object)e);
            existHost.setHostStatus(Integer.valueOf(2));
            existHost.setStatus(Integer.valueOf(2));
            return existHost;
        }
        this.validateHostInfo(existHost, extend, action, host);
        context.setAttribute("DiscoveryError_" + host.getHostSN(), null);
        extend.getExtendParams().put("mac_address", host.getUuid());
        String ip = (String)extend.getExtendParams().get("fsb_block_client_ip");
        if (null != ip) {
            context.setAttribute("fsb_block_client_ip", (Object)ip);
        }
        if ("register".equals(action) || "refresh".equals(action)) {
            host.setLocation(location);
            LOGGER.info((Object)("set host's location : " + location), 90160758786988L);
        }
        return host;
    }

    private void validateHostInfo(Host existHost, NeMgrProtocolExtend extend, String action, Host host) {
        if (null == host || VerifyUtil.isEmpty((String)host.getHostName()) || VerifyUtil.isEmpty((String)host.getOs())) {
            LOGGER.error((Object)("the host(" + extend.getNetworkIpAddress() + ")'info is not valid."), 90160758786989L);
            throw new LegoCheckedException(1073947394L);
        }
        if (!"register".equals(action) && null != existHost && !existHost.getUuid().equals(host.getUuid())) {
            LOGGER.error((Object)("The uuid in db: " + existHost.getUuid() + ", new uuid: " + host.getUuid()), 90160758786989L);
            throw new LegoCheckedException(1073947432L);
        }
        if ("register".equals(action) && SiteResourceManagerUtil.isResourceExists((String)host.getHostSN())) {
            LOGGER.error((Object)("The hostSN is: " + host.getHostSN()));
            throw new LegoCheckedException(127406L);
        }
    }

    private void setHostInitiators(AbstractContext context, NeMgrProtocolExtend extend) {
        try {
            IHostRetrieveProxy hostRetrieveProxy = (IHostRetrieveProxy)ServiceLocator.getInstance().getService(IHostRetrieveProxy.class);
            List initiators = hostRetrieveProxy.queryHostInitiators(extend);
            context.setAttribute("HOST_INITIATOR_KEY", (Object)initiators);
        }
        catch (Exception e) {
            LOGGER.error((Object)("Get host(" + extend.getNetworkIpAddress() + ") initiators info failed." + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758786989L);
        }
    }
}

