/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.host.discovery.processer;

import com.huawei.ism.base.sdk.model.NeMgrProtocolExtend;
import com.huawei.ism.cbb.base.dao.IMoDao;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.discover.framework.AbstractContext;
import com.huawei.ism.cbb.discover.framework.IProcessor;
import com.huawei.ism.cbb.util.NumberUtil;
import com.huawei.ism.drm.host.sdk.model.DrHost;
import com.huawei.ism.drm.host.sdk.service.IHostRetrieveProxy;
import com.huawei.ism.drm.host.util.DrHostUtil;
import com.huawei.ism.drm.topo.utils.TopoServiceUtil;
import com.huawei.ism.host.sdk.model.Host;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;

public class HostPingProcessor
implements IProcessor {
    private static final Log LOGGER = LogFactory.getInstance(HostPingProcessor.class);

    public boolean process(AbstractContext context) {
        Host host = (Host)context.getAttribute("StorageDevice");
        NeMgrProtocolExtend extend = (NeMgrProtocolExtend)context.getAttribute("NeMgrProtocolExtend");
        if (null == host || null == extend) {
            return false;
        }
        int hostStatus = 1;
        try {
            Host hostInfo = ((IHostRetrieveProxy)ServiceLocator.getInstance().getService(IHostRetrieveProxy.class)).queryHostBaseInfo(extend);
            if (hostInfo == null || !host.getUuid().equals(hostInfo.getUuid())) {
                LOGGER.error((Object)("The hostInfo is empty or host uuid is not equals. hostsn: " + host.getHostSN()), 90160758786989L);
                hostStatus = 2;
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)("get host(" + extend.getNetworkIpAddress() + ")'basic info failed." + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758786989L);
            hostStatus = 2;
        }
        if (hostStatus != host.getStatus()) {
            IMoDao moDao = CommonDAOLocator.getMoDao();
            host.setStatus(Integer.valueOf(hostStatus));
            moDao.onlyUpdateWithoutMsg((ManagedObject)host);
            this.updateResourceStatus(host.getHostSN(), hostStatus);
            this.sendAlarm(host, hostStatus);
        }
        return true;
    }

    private void updateResourceStatus(String devSn, int status) {
        DrHost drResource = (DrHost)TopoServiceUtil.getDrResource((String)devSn);
        if (drResource == null) {
            LOGGER.error((Object)("updateResourceStatus, drResource==null, devSn:" + devSn), 90160758786988L);
            return;
        }
        int hostStatusInDb = NumberUtil.convertToInteger((Object)drResource.getStatus());
        if (status != hostStatusInDb) {
            drResource.setStatus(String.valueOf(status));
            IMoDao moDao = CommonDAOLocator.getMoDao();
            moDao.getHibernateTemplate().update((Object)drResource);
        }
    }

    private void sendAlarm(Host host, int hostStatus) {
        if (hostStatus != 1) {
            DrHostUtil.generateOfflineAlarm(host);
        } else {
            DrHostUtil.generateOfflineRestoreAlarm(host);
        }
    }

    public void postProcess(AbstractContext paramAbstractContext) {
    }

    public void clean(AbstractContext paramAbstractContext) {
    }

    public String getName() {
        return this.getClass().getSimpleName();
    }
}

