/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.host.discovery.processer;

import com.huawei.ism.base.sdk.model.Initiator;
import com.huawei.ism.base.sdk.model.NeMgrProtocolExtend;
import com.huawei.ism.base.sdk.model.NetworkEntity;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.discover.framework.AbstractContext;
import com.huawei.ism.cbb.discover.framework.IProcessor;
import com.huawei.ism.cbb.discover.sdk.service.INeMgrProtocolExtendService;
import com.huawei.ism.cbb.discover.util.DiscoverUtil;
import com.huawei.ism.cbb.util.NumberUtil;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.application.sdk.model.SAPHANADatabaseInstance;
import com.huawei.ism.drm.host.sdk.model.DrHost;
import com.huawei.ism.drm.host.util.DrHostUtil;
import com.huawei.ism.drm.license.sdk.ILicenseControl;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.site.sdk.service.ISiteService;
import com.huawei.ism.drm.util.CommUtil;
import com.huawei.ism.host.sdk.model.Host;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.com.south.sdk.model.SnmpPara;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.WccEncryptor;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.orm.hibernate5.HibernateTemplate;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;

public class HostSaveProcessor
implements IProcessor {
    private static final Log LOGGER = LogFactory.getInstance(HostSaveProcessor.class);
    private static final String KMC_PRE = "AAAAAg";
    private static final Object THREAD_LOCK = new Object();

    public void clean(AbstractContext arg0) {
    }

    public String getName() {
        return this.getClass().getSimpleName();
    }

    public void postProcess(AbstractContext arg0) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean process(AbstractContext context) {
        Host host = (Host)context.getAttribute("DRMHOST");
        Object extendObj = context.getAttribute("NeMgrProtocolExtend");
        NeMgrProtocolExtend extend = (NeMgrProtocolExtend)extendObj;
        if (null == host || null == extend) {
            return false;
        }
        this.setEngineId(host, extend);
        host.setMainType("ism.drm.deviceType.drhost.mainType");
        host.setSubType("ism.drm.deviceType.drhost.subType");
        host.setProductModel("Dr_Host");
        Host existHost = DrHostUtil.getExistHost(extend);
        if (null == existHost) {
            Object object = THREAD_LOCK;
            synchronized (object) {
                ILicenseControl licenseControl = (ILicenseControl)ServiceLocator.getInstance().getService(ILicenseControl.class);
                licenseControl.checkLicenseEnable("LSTQDPMN", 1);
                this.saveHost(context, host, extend);
            }
        } else {
            this.saveHost(context, host, extend);
        }
        Long operatorId = (Long)context.getAttribute("OPERATORID");
        DiscoverUtil.grantUserNeAuthority((NetworkEntity)host, (Long)operatorId);
        LOGGER.info((Object)("save host ok:" + host.getIpAddress()), 90160758786879L);
        String action = (String)context.getAttribute("DiscoveryType");
        if (!"register".equals(action) && 1 != host.getHostStatus()) {
            Object obj = context.getAttribute("DiscoveryError_" + host.getHostSN());
            LegoCheckedException agentError = (LegoCheckedException)((Object)obj);
            if (!VerifyUtil.isEmpty((Object)((Object)agentError))) {
                throw agentError;
            }
            throw new LegoCheckedException(1073947398L, new String[]{host.getIpAddress()});
        }
        return true;
    }

    private void saveHost(AbstractContext context, Host host, NeMgrProtocolExtend extend) {
        CommonDAOLocator.getMoDao().getTransactionTemplate().execute((TransactionCallback)new SaveHostTransactionCallback(context, host));
        this.saveNeMgrProtocolExtend(host, extend);
    }

    private void setEngineId(Host host, NeMgrProtocolExtend extend) {
        try {
            Map protocolMap;
            Object obj = extend.getExtendParams().get("snmpVersion");
            if (null == obj) {
                return;
            }
            String macAddress = (String)extend.getExtendParams().get("mac_address");
            if (VerifyUtil.isEmpty((String)((String)extend.getExtendParams().get("snmpContextEngineId")))) {
                extend.getExtendParams().put("snmpContextEngineId", macAddress);
            }
            if (VerifyUtil.isEmpty((Map)(protocolMap = host.getManagementProtocolMap()))) {
                return;
            }
            SnmpPara snmpPara = (SnmpPara)protocolMap.get(SnmpPara.class.getName());
            if (null == snmpPara) {
                return;
            }
            if (VerifyUtil.isEmpty((String)snmpPara.getContextEngineId())) {
                snmpPara.setContextEngineId(macAddress);
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)("set EngineId exception." + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758786879L);
        }
    }

    private void saveNeMgrProtocolExtend(Host host, NeMgrProtocolExtend extendNow) {
        INeMgrProtocolExtendService neMgr = (INeMgrProtocolExtendService)ServiceLocator.getInstance().getService(INeMgrProtocolExtendService.class);
        NeMgrProtocolExtend extendExist = neMgr.findByMoId(host.getMoId());
        HashMap<String, String> ipToMacSave = new HashMap<String, String>();
        ipToMacSave.put(host.getIpAddress(), host.getUuid());
        if (!VerifyUtil.isEmpty((Object)extendExist)) {
            Map paramsExist = extendExist.getExtendParams();
            this.dealIPMacExist(paramsExist, host.getUuid(), ipToMacSave);
        }
        extendNow.setMoId(host.getMoId());
        Set entryseSet = ipToMacSave.entrySet();
        for (Map.Entry entry : entryseSet) {
            extendNow.getExtendParams().put(entry.getKey(), entry.getValue());
        }
        this.handlePwd(extendNow, "snmpAuthPwd");
        this.handlePwd(extendNow, "snmpEncryptPwd");
        extendNow.getExtendParams().computeIfPresent("hostKey", (key, value) -> value.startsWith(KMC_PRE) ? value : WccEncryptor.encrypt((String)value));
        this.removeInvalidInfo(extendNow);
        neMgr.save(extendNow);
    }

    private void handlePwd(NeMgrProtocolExtend extendNow, String key) {
        String pwd = (String)extendNow.getExtendParams().get(key);
        if (VerifyUtil.isEmpty((String)pwd)) {
            return;
        }
        try {
            String pass = WccEncryptor.decrypt((String)pwd);
            if (VerifyUtil.isEmpty((String)pass)) {
                extendNow.getExtendParams().put(key, WccEncryptor.encrypt((String)pwd));
            }
        }
        catch (Exception e) {
            extendNow.getExtendParams().put(key, WccEncryptor.encrypt((String)pwd));
        }
    }

    private void removeInvalidInfo(NeMgrProtocolExtend extendNow) {
        HashMap extendMap = new HashMap();
        Set entrySet = extendNow.getExtendParams().entrySet();
        for (Map.Entry entry : entrySet) {
            if (VerifyUtil.isEmpty((String)((String)entry.getValue()))) continue;
            extendMap.put(entry.getKey(), entry.getValue());
        }
        extendNow.setExtendParams(extendMap);
    }

    private void dealIPMacExist(Map<String, String> paramsExist, String mac, Map<String, String> ipToMacSave) {
        Set<String> keySet = ipToMacSave.keySet();
        for (Map.Entry<String, String> entry : paramsExist.entrySet()) {
            if (keySet.contains(entry.getKey()) || !CommUtil.checkDrmIpParam((String)entry.getKey())) continue;
            ipToMacSave.put(entry.getKey(), mac);
        }
    }

    private void updateDrHostInfo(AbstractContext context, Host host) {
        String location = (String)context.getAttribute("Location");
        LOGGER.info((Object)"Update drhost info location = %s", new Object[]{location});
        HibernateTemplate hibernateTemplate = CommonDAOLocator.getMoDao().getHibernateTemplate();
        String hql = "from DrHost where deviceSn = ? and siteId in (select siteId from Site where siteType = 0)";
        List hosts = hibernateTemplate.find(hql, (Object[])new String[]{host.getHostSN()});
        DrHost drHost = this.getDrHost(context, host, location, hosts);
        if (drHost == null) {
            LOGGER.error((Object)"DrHost is null");
            return;
        }
        List initiators = (List)context.getAttribute("HOST_INITIATOR_KEY");
        this.buildInitiatorInfo(drHost, initiators);
        Site site = ((ISiteService)ServiceLocator.getInstance().getService(ISiteService.class)).getSiteById(drHost.getSiteId());
        if (site == null) {
            LOGGER.error((Object)"Site is null,SiteId=%s, drHost=%s", new Object[]{drHost.getSiteId(), drHost.getIpAddress()});
            throw new LegoCheckedException(1073947393L);
        }
        this.addFSBClientIp(context, drHost);
        hibernateTemplate.saveOrUpdate((Object)drHost);
    }

    private DrHost getDrHost(AbstractContext context, Host host, String location, List<DrHost> hosts) {
        DrHost drHost = null;
        if (!VerifyUtil.isEmpty(hosts)) {
            drHost = hosts.get(0);
            drHost.setName(host.getHostName());
            drHost.setIpAddress(host.getIpAddress());
            drHost.setStatus(String.valueOf(host.getHostStatus()));
            drHost.setOsType(host.getOs());
            drHost.setVersion(host.getVersion());
            JSONObject instanceHostAlisaJsonObject = new JSONObject();
            for (ManagedObject object : host.getChildMos()) {
                if (!(object instanceof SAPHANADatabaseInstance)) continue;
                String hostAlias = ((SAPHANADatabaseInstance)object).getHostAlias();
                instanceHostAlisaJsonObject.put((Object)((SAPHANADatabaseInstance)object).getInstanceName(), (Object)hostAlias);
            }
            drHost.setHostAlias(instanceHostAlisaJsonObject.toString());
            DrHostUtil.parseAndSetAgentVersionInfo(drHost, host.getAgentVersion());
        } else if (!VerifyUtil.isEmpty((String)location)) {
            NeMgrProtocolExtend extend = (NeMgrProtocolExtend)context.getAttribute("NeMgrProtocolExtend");
            Integer port = NumberUtil.parseInteger(extend.getExtendParams().get("port"));
            drHost = DrHostUtil.buildDrHostByMo(host, port);
            drHost.setSiteId(location);
            if (extend.getExtendParams().containsKey("isAgentless")) {
                Boolean isAgentLess = Boolean.valueOf((String)extend.getExtendParams().get("isAgentless"));
                drHost.setIsAgentLess(isAgentLess);
            }
        }
        return drHost;
    }

    private void buildInitiatorInfo(DrHost drHost, List<Initiator> initiators) {
        if (!VerifyUtil.isEmpty(initiators)) {
            JSONArray jsonArray = new JSONArray();
            for (Initiator initiator : initiators) {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put((Object)"TYPE", (Object)initiator.getHbaType());
                jsonObject.put((Object)"IDENTITY", (Object)initiator.getIdentity());
                jsonArray.add((Object)jsonObject);
            }
            JSONObject jsonObject = new JSONObject();
            jsonObject.put((Object)"HBA", (Object)jsonArray);
            drHost.setExtProperty(jsonObject.toString());
        }
    }

    private void addFSBClientIp(AbstractContext context, DrHost drHost) {
        Object ip = context.getAttribute("fsb_block_client_ip");
        if (null == ip) {
            return;
        }
        JSONObject hostExtInfo = null != drHost.getExtProperty() ? JSONObject.fromObject((Object)drHost.getExtProperty()) : new JSONObject();
        hostExtInfo.put((Object)"fsb_block_client_ip", (Object)ip.toString());
        drHost.setExtProperty(hostExtInfo.toString());
    }

    class SaveHostTransactionCallback
    implements TransactionCallback {
        private final Host host;
        private final AbstractContext context;

        public SaveHostTransactionCallback(AbstractContext context, Host host) {
            this.host = host;
            this.context = context;
        }

        public Object doInTransaction(TransactionStatus ts) {
            try {
                CommonDAOLocator.getMoDao().addMoAndSubMo((ManagedObject)this.host);
                HostSaveProcessor.this.updateDrHostInfo(this.context, this.host);
            }
            catch (Exception ex) {
                ts.setRollbackOnly();
                ExceptionUtil.rethrowException((Throwable)ex, (String)"update host info.", (long)132416L, null, (Log)LOGGER);
            }
            return new HashMap();
        }
    }
}

