/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.host.discovery.service.impl;

import com.huawei.ism.base.sdk.model.NeMgrProtocolExtend;
import com.huawei.ism.cbb.base.dao.IMoDao;
import com.huawei.ism.cbb.base.task.AbstractBackTask;
import com.huawei.ism.cbb.base.task.BackTaskHandler;
import com.huawei.ism.cbb.base.task.BackTaskUtil;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.discover.commons.RefreshContext;
import com.huawei.ism.cbb.discover.framework.AbstractContext;
import com.huawei.ism.cbb.discover.framework.CommonTemplate;
import com.huawei.ism.cbb.discover.framework.CommonTemplateManager;
import com.huawei.ism.cbb.discover.sdk.service.INeMgrProtocolExtendService;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.app.sdk.model.SnmpAuthInfo;
import com.huawei.ism.drm.host.sdk.model.DrHost;
import com.huawei.ism.drm.host.sdk.service.IHostDiscoveryService;
import com.huawei.ism.drm.host.sdk.service.IHostRetrieveProxy;
import com.huawei.ism.drm.host.util.DrHostUtil;
import com.huawei.ism.drm.host.util.HostTrapUtil;
import com.huawei.ism.drm.site.resource.sdk.service.IResourceService;
import com.huawei.ism.host.sdk.model.Host;
import com.huawei.lego.cbb.backtask.sdk.model.BackTask;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.core.sdk.base.BaseService;
import com.huawei.lego.core.sdk.base.annotation.Service;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.WccEncryptor;
import java.util.Map;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.springframework.dao.DataAccessException;
import org.springframework.orm.hibernate5.HibernateCallback;

@Service(name="com.huawei.ism.drm.host.sdk.service.IHostDiscoveryService", desc="", interfaceClass=IHostDiscoveryService.class)
public class HostDiscoveryServiceImpl
extends BaseService
implements IHostDiscoveryService {
    private static final Log LOGGER = LogFactory.getInstance(HostDiscoveryServiceImpl.class);
    private IMoDao moDao;
    private INeMgrProtocolExtendService neMgr;

    public void setMoDao(IMoDao moDao) {
        this.moDao = moDao;
    }

    public void setNeMgr(INeMgrProtocolExtendService neMgr) {
        this.neMgr = neMgr;
    }

    public void refreshHost(String hostSN, String userName) {
        LOGGER.debug((Object)("refresh host:" + hostSN + ",userName:" + userName), 90160777660713L);
        if (VerifyUtil.isEmpty((String)hostSN)) {
            LOGGER.error((Object)"hostSN is empty, and refreshing Host failed", 90160777660713L);
            throw new LegoCheckedException(1073947393L);
        }
        Host host = (Host)this.moDao.getMo(Host.class, "hostSN", (Object)hostSN);
        if (null == host) {
            LOGGER.error((Object)("Host(" + hostSN + ") dosen't exist.Failed to refresh."), 90160777660713L);
            throw new LegoCheckedException(1073947394L);
        }
        long moId = host.getMoId();
        NeMgrProtocolExtend extend = this.neMgr.findByMoId(Long.valueOf(moId));
        if (null == extend) {
            LOGGER.error((Object)("Host(" + hostSN + ")'NeMgrProtocolExtend dosen't exist.Failed to refresh."), 90160777660713L);
            throw new LegoCheckedException(1073947393L);
        }
        BackTask bt = BackTaskUtil.buildBackTask((String)host.getName(), (String)"ism.drm.app.host.refresh.operationName", (String)userName, (String)"", null);
        AbstractBackTask task = new AbstractBackTask(host.getUuid(), bt, true){

            protected void doWork() {
                Host temphost = (Host)CommonDAOLocator.getMoDao().getMo(Host.class, "hostSN", (Object)this.getTaskId());
                RefreshContext context = new RefreshContext((ManagedObject)temphost);
                context.setAttribute("refreshTask", (Object)this);
                CommonTemplate refreshTemplate = CommonTemplateManager.getInstance().getRefreshTemplateByDeviceType("Dr_Host");
                if (refreshTemplate == null) {
                    throw new LegoCheckedException(127402L);
                }
                refreshTemplate.process((AbstractContext)context);
            }
        };
        BackTaskHandler.getInstance().submitTask(task);
    }

    public void updateHost(Host host, NeMgrProtocolExtend neMgrProtocol, boolean editAuthentication) {
        if (null == host) {
            LOGGER.error((Object)"hostSN is empty or port is empty, and update Host failed", 90160777660713L);
            throw new LegoCheckedException(1073947393L);
        }
        NeMgrProtocolExtend extend = this.neMgr.findByMoId(host.getMoId());
        if (null == extend) {
            LOGGER.error((Object)("Host(" + host.getSn() + ")'NeMgrProtocolExtend dosen't exist.Failed to update."), 90160777660713L);
            throw new LegoCheckedException(1073947393L);
        }
        String oldHostIp = extend.getNetworkIpAddress();
        this.setProtocolProp(extend, neMgrProtocol);
        String snmpVersion = (String)neMgrProtocol.getExtendParams().get("snmpVersion");
        if (!VerifyUtil.isEmpty((String)snmpVersion)) {
            this.checkSnmpParam(extend, neMgrProtocol);
            this.setSnmpParam(extend, neMgrProtocol.getExtendParams());
        }
        LOGGER.info((Object)"test host agent ok,and save it", 90160777660713L);
        UpdateHostTransaction callback = new UpdateHostTransaction(host.getSn(), extend);
        this.moDao.getHibernateTemplate().execute((HibernateCallback)callback);
        String pwd = extend.getNetworkPassword();
        if (!VerifyUtil.isEmpty((String)pwd)) {
            extend.setNetworkPassword(WccEncryptor.decrypt((String)pwd));
        }
        extend.getExtendParams().computeIfPresent("hostKey", (key, value) -> WccEncryptor.encrypt((String)value));
        if (this.isRegisterTrap(extend, snmpVersion, neMgrProtocol, oldHostIp)) {
            HostTrapUtil.registerTrap(host, extend, true, false);
        }
        if (!VerifyUtil.isEmpty((String)snmpVersion)) {
            DrHostUtil.sendMsg((ManagedObject)host, 107L, ((Object)((Object)this)).getClass().getName());
        }
    }

    private boolean isRegisterTrap(NeMgrProtocolExtend extend, String snmpVersion, NeMgrProtocolExtend neMgrProtocol, String oldHostIp) {
        if (!VerifyUtil.isEmpty((String)snmpVersion) && !this.isHasRegisterTrap(extend)) {
            return true;
        }
        return neMgrProtocol.isModifyAuthInfo() && !VerifyUtil.isEmpty((String)neMgrProtocol.getNetworkIpAddress()) && !oldHostIp.equals(neMgrProtocol.getNetworkIpAddress()) && this.isHasRegisterTrap(extend);
    }

    private boolean isHasRegisterTrap(NeMgrProtocolExtend extend) {
        String trapIp = (String)extend.getExtendParams().get("host_trapip");
        String trapPort = (String)extend.getExtendParams().get("host_trapport");
        return !VerifyUtil.isEmpty((String)trapIp) && !VerifyUtil.isEmpty((String)trapPort);
    }

    private void setProtocolProp(NeMgrProtocolExtend extend, NeMgrProtocolExtend neMgrProtocol) {
        if (neMgrProtocol.isModifyAuthInfo()) {
            String port;
            String pwd;
            if (!VerifyUtil.isEmpty((String)neMgrProtocol.getNetworkUserName())) {
                extend.setNetworkUserName(neMgrProtocol.getNetworkUserName());
            }
            if (!VerifyUtil.isEmpty((String)neMgrProtocol.getNetworkIpAddress())) {
                extend.setNetworkIpAddress(neMgrProtocol.getNetworkIpAddress());
            }
            if (!VerifyUtil.isEmpty((String)(pwd = neMgrProtocol.getNetworkPassword())) && !"********".equals(pwd)) {
                extend.setNetworkPassword(neMgrProtocol.getNetworkPassword());
            }
            if (!VerifyUtil.isEmpty((String)(port = (String)neMgrProtocol.getExtendParams().get("port")))) {
                extend.getExtendParams().put("port", port);
            }
        }
    }

    private void setSnmpParam(NeMgrProtocolExtend extend, Map<String, String> snmpParam) {
        try {
            this.setSnmpParam(extend, snmpParam, "snmpAuthProtocol");
            String authPwd = snmpParam.get("snmpAuthPwd");
            if (!VerifyUtil.isEmpty((String)authPwd) && !"******".equals(authPwd)) {
                extend.getExtendParams().put("snmpAuthPwd", WccEncryptor.encrypt((String)snmpParam.get("snmpAuthPwd")));
            }
            this.setSnmpParam(extend, snmpParam, "snmpContextName");
            this.setSnmpParam(extend, snmpParam, "snmpEncryptProtocol");
            String encryptPwd = snmpParam.get("snmpEncryptPwd");
            if (!VerifyUtil.isEmpty((String)encryptPwd) && !"******".equals(encryptPwd)) {
                extend.getExtendParams().put("snmpEncryptPwd", WccEncryptor.encrypt((String)snmpParam.get("snmpEncryptPwd")));
            }
            this.setSnmpParam(extend, snmpParam, "snmpContextEngineId");
            this.setSnmpParam(extend, snmpParam, "snmpPort");
            this.setSnmpParam(extend, snmpParam, "snmpRetries");
            this.setSnmpParam(extend, snmpParam, "snmpSecurityName");
            this.setSnmpParam(extend, snmpParam, "snmpTimeout");
            this.setSnmpParam(extend, snmpParam, "snmpVersion");
        }
        catch (Exception e) {
            LOGGER.error((Object)("set snmp param exception." + ExceptionUtil.getErrorMessage((Throwable)e)), 90160777660713L);
        }
    }

    private void setSnmpParam(NeMgrProtocolExtend extend, Map<String, String> snmpParam, String key) {
        String object = snmpParam.get(key);
        if (VerifyUtil.isEmpty((String)object)) {
            object = " ";
        }
        extend.getExtendParams().put(key, object);
    }

    private void checkSnmpParam(NeMgrProtocolExtend extendDb, NeMgrProtocolExtend extend) {
        try {
            this.checkExtendParam(extendDb, extend);
        }
        catch (LegoCheckedException ex) {
            LOGGER.error((Object)"check snmp param exception.", (Throwable)ex, 90160777660713L);
            throw ex;
        }
        catch (Exception e) {
            String errorMsg = "check snmp param exception.";
            ExceptionUtil.rethrowException((Throwable)e, (String)errorMsg, (long)1073947393L, null, (Log)LOGGER);
        }
    }

    private void checkExtendParam(NeMgrProtocolExtend extendDb, NeMgrProtocolExtend extend) {
        if (!extend.isModifyAuthInfo()) {
            extend.setNetworkIpAddress(extendDb.getNetworkIpAddress());
            extend.setNetworkPassword(extendDb.getNetworkPassword());
            extend.setNetworkUserName(extendDb.getNetworkUserName());
            extend.getExtendParams().put("port", extendDb.getExtendParams().get("port"));
        } else {
            String pwd = extend.getNetworkPassword();
            if (VerifyUtil.isEmpty((String)pwd)) {
                LOGGER.error((Object)"Not find input passwd.");
                throw new LegoCheckedException(1073947393L);
            }
        }
        String authPwd = (String)extend.getExtendParams().get("snmpAuthPwd");
        if (VerifyUtil.isEmpty((String)authPwd)) {
            LOGGER.error((Object)"Not find param of snmpAuthPwd");
            throw new LegoCheckedException(1073947393L);
        }
        String encryptPwd = (String)extend.getExtendParams().get("snmpEncryptPwd");
        if (VerifyUtil.isEmpty((String)encryptPwd)) {
            LOGGER.error((Object)"Not find param of snmpEncryptPwd");
            throw new LegoCheckedException(1073947393L);
        }
        int authType = HostTrapUtil.getAuthProtocol((String)extend.getExtendParams().get("snmpAuthProtocol"));
        int encryptType = HostTrapUtil.getEncryptProtocol((String)extend.getExtendParams().get("snmpEncryptProtocol"));
        String securityName = (String)extend.getExtendParams().get("snmpSecurityName");
        SnmpAuthInfo snmpAuthInfo = new SnmpAuthInfo(Integer.valueOf(authType), authPwd, Integer.valueOf(encryptType), encryptPwd, securityName);
        ((IHostRetrieveProxy)ServiceLocator.getInstance().getService(IHostRetrieveProxy.class)).checkSnmpParam(extend, snmpAuthInfo);
    }

    class UpdateHostTransaction
    implements HibernateCallback {
        private String hostSn;
        private NeMgrProtocolExtend extend;

        public UpdateHostTransaction(String hostSn, NeMgrProtocolExtend extend) {
            this.hostSn = hostSn;
            this.extend = extend;
        }

        public Object doInHibernate(Session session) {
            try {
                Host host;
                HostDiscoveryServiceImpl.this.neMgr.save(this.extend, false);
                IResourceService resourceService = (IResourceService)ServiceLocator.getInstance().getService(IResourceService.class);
                DrHost drHost = (DrHost)resourceService.getDrResourceBySn(this.hostSn);
                if (null != drHost) {
                    String port = (String)this.extend.getExtendParams().get("port");
                    drHost.setPort(Integer.valueOf(port));
                    drHost.setIpAddress(this.extend.getNetworkIpAddress());
                    HostDiscoveryServiceImpl.this.moDao.getHibernateTemplate().saveOrUpdate((Object)drHost);
                }
                if (null != (host = (Host)HostDiscoveryServiceImpl.this.moDao.getMo(Host.class, "sn", (Object)this.hostSn))) {
                    host.setIpAddress(this.extend.getNetworkIpAddress());
                    host.setLinkIp(this.extend.getNetworkIpAddress());
                    host.setManagedIps(this.extend.getNetworkIpAddress());
                    HostDiscoveryServiceImpl.this.moDao.onlyUpdateWithoutMsg((ManagedObject)host);
                }
                LOGGER.info((Object)("Host(" + this.hostSn + ") has been update."), 90160777660713L);
            }
            catch (DataAccessException e) {
                LOGGER.error((Object)"Save host info error!", 90160758786306L);
                throw new LegoCheckedException(-1L, (Throwable)e);
            }
            catch (HibernateException e) {
                LOGGER.error((Object)"Save host info error!", 90160758786306L);
                throw new LegoCheckedException(-1L, (Throwable)e);
            }
            return null;
        }
    }
}

