/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.host.protection.action;

import com.huawei.ism.drm.host.protection.action.UnmapReplicaTask;
import com.huawei.ism.drm.host.util.DrHostUtil;
import com.huawei.ism.drm.protection.action.model.ActionContext;
import com.huawei.ism.drm.protection.framework.engine.action.AbstractBaseProtectAction;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.replica.sdk.model.CloneConsistentGroup;
import com.huawei.ism.drm.protection.replica.sdk.model.HyperClonePair;
import com.huawei.ism.drm.recovery.sdk.model.ResourceVO;
import com.huawei.ism.drm.storage.sdk.model.Snapshot;
import com.huawei.lego.core.base.thread.ExecutionService;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class UnmapReplicaSubAction
extends AbstractBaseProtectAction {
    private static final Log logger = LogFactory.getInstance(UnmapReplicaSubAction.class);

    public boolean doExecute(ActionContext context) {
        logger.debug((Object)"begin exec UnmapReplicaSubAction");
        String hostSn = (String)this.getParams().get("hostId");
        if (VerifyUtil.isEmpty((String)hostSn)) {
            logger.error((Object)"hostSn or scriptName is empty", 90160758786989L);
            this.setDetail("lego.err.1073947393");
            return false;
        }
        HashSet<String> hostOrGroupIds = new HashSet<String>();
        hostOrGroupIds.add(hostSn);
        Map<String, ResourceVO> resourceVOs = DrHostUtil.getHostInitiators(hostOrGroupIds);
        if (null == resourceVOs || null == resourceVOs.get(hostSn)) {
            logger.error((Object)"hostSn or scriptName is empty", 90160758786989L);
            this.setDetail("lego.err.1073948686");
            return false;
        }
        CloneConsistentGroup cloneCG = (CloneConsistentGroup)context.getObject("CloneCG");
        if (null == cloneCG) {
            logger.error((Object)"clone has no pair.");
            this.setDetail("lego.err.1073947393");
            return false;
        }
        HyperClonePair clonePair = (HyperClonePair)CommonUtil.getFirstElement((Collection)cloneCG.getPairs());
        if (null == clonePair) {
            logger.error((Object)"can not get clone pair in CloneCG.");
            this.setDetail("lego.err.1073947393");
            return false;
        }
        String deviceSn = clonePair.getDeviceSn();
        ResourceVO vo = resourceVOs.get(hostSn);
        ProtectGroup protectGroup = (ProtectGroup)context.getObject("PG_ENTITY");
        if (!this.deleteSnapshotMapping(protectGroup, vo)) {
            logger.error((Object)"deleteSnapshotMapping error.");
            this.setDetail("lego.err.1073948678");
            return false;
        }
        if (!this.deleteCloneTgtLunMapping(cloneCG, deviceSn, vo)) {
            logger.error((Object)"deleteSnapshotMapping error.");
            this.setDetail("lego.err.1073948697");
            return false;
        }
        return true;
    }

    private boolean deleteCloneTgtLunMapping(CloneConsistentGroup cloneCG, String deviceSn, ResourceVO vo) {
        ArrayList<UnmapReplicaTask> tasks = new ArrayList<UnmapReplicaTask>();
        for (HyperClonePair pair : cloneCG.getPairs()) {
            UnmapReplicaTask task = new UnmapReplicaTask(deviceSn, pair.getTgtLunId(), null, vo);
            tasks.add(task);
        }
        if (tasks.isEmpty()) {
            logger.debug((Object)"there is no target lun need to delete.");
            return true;
        }
        List resultList = ExecutionService.batchSubmit(tasks, (ExecutionService.ExecuteType)ExecutionService.ExecuteType.FAILED_ABORT, (int)0, (int)20);
        if (null == resultList || resultList.size() != tasks.size()) {
            logger.error((Object)"delete target lun has error.");
            return false;
        }
        if (resultList.contains(Boolean.FALSE)) {
            logger.error((Object)"delete target lun has not success.");
            return false;
        }
        return true;
    }

    private boolean deleteSnapshotMapping(ProtectGroup protectGroup, ResourceVO vo) {
        String cloneSnapStr = (String)protectGroup.getProps().get("CLONE_SNAPSHOT");
        if (null == cloneSnapStr || cloneSnapStr.isEmpty()) {
            logger.debug((Object)"CLONE_SNAPSHOT is null.");
            return true;
        }
        JSONArray snaps = JSONArray.fromObject((Object)cloneSnapStr);
        ArrayList<UnmapReplicaTask> tasks = new ArrayList<UnmapReplicaTask>();
        for (int i = 0; i < snaps.size(); ++i) {
            JSONObject snap = snaps.getJSONObject(i);
            Snapshot snapshot = new Snapshot();
            snapshot.setSnapshotId(snap.getString("snapshotId"));
            snapshot.setSnapshotName(snap.getString("snapshotName"));
            UnmapReplicaTask task = new UnmapReplicaTask(snap.getString("devSn"), null, snapshot, vo);
            tasks.add(task);
        }
        if (tasks.isEmpty()) {
            logger.debug((Object)"there is no snap need to delete.");
            return true;
        }
        List resultList = ExecutionService.batchSubmit(tasks, (ExecutionService.ExecuteType)ExecutionService.ExecuteType.FAILED_ABORT, (int)0, (int)20);
        if (null == resultList || resultList.size() != tasks.size()) {
            logger.error((Object)"delete snapshot has error.");
            return false;
        }
        if (resultList.contains(Boolean.FALSE)) {
            logger.error((Object)"delete snapshot has not success.");
            return false;
        }
        return true;
    }
}

