/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.host.recovery.process;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryProcessService;
import com.huawei.ism.drm.host.recovery.process.DeleteLunMappingSubProcessor;
import com.huawei.ism.drm.host.recovery.process.MappingLunSubProcessor;
import com.huawei.ism.drm.host.util.DrHostDeviceUtil;
import com.huawei.ism.drm.host.util.DrHostUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.recovery.sdk.model.ResourceVO;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DeleteNativeReplicaMappingProcessor
extends BaseRecoveryProcessor {
    private static final long serialVersionUID = -5597503114077131259L;
    private static final Log logger = LogFactory.getInstance(DeleteNativeReplicaMappingProcessor.class);

    protected boolean execute(RecoveryProcessorContext context) {
        logger.info((Object)"begin to DeleteNativeReplicaMappingProcessor.");
        if (VerifyUtil.isEmpty((Object)context)) {
            logger.error((Object)"DeleteNativeReplicaMappingProcessor: context is null!", 90160758784001L);
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            return false;
        }
        String hostKey = "PG_DISASTER_HOST";
        String hostOrGroupId = (String)context.getRecoveryPlan().getGlobalSettings().get(hostKey);
        HashSet<String> hostOrGroupIds = new HashSet<String>();
        hostOrGroupIds.add(hostOrGroupId);
        Map<String, ResourceVO> resourceVOs = DrHostUtil.getHostInitiators(hostOrGroupIds);
        if (null == resourceVOs || null == resourceVOs.get(hostOrGroupId)) {
            logger.error((Object)"DeleteNativeReplicaMappingProcessor: hostSn or scriptName is empty", 90160758786989L);
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            return false;
        }
        ResourceVO vo = resourceVOs.get(hostOrGroupId);
        Set<RecoveryProcessor> subProcessors = this.buildMapSubProcessor(context, vo);
        if (null == subProcessors || subProcessors.isEmpty()) {
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
            return true;
        }
        if (this.getChildProc() == null || this.getChildProc().size() == 0) {
            this.setChildProc(subProcessors);
        } else {
            this.updateSubProcessors(subProcessors);
        }
        if (!((IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class)).updateRecoveryProcessor((RecoveryProcessor)this)) {
            logger.error((Object)"save delete mapping processor failed.");
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            return false;
        }
        this.scanDisk(context);
        return this.executeSubProcessor(context);
    }

    private Set<RecoveryProcessor> buildMapSubProcessor(RecoveryProcessorContext context, ResourceVO vo) {
        HashSet<RecoveryProcessor> subProcessors = new HashSet<RecoveryProcessor>();
        List recoveryProcesses = this.getRecoveryProcessors(context.getRecoveryPlan(), DrmEnumDefine.RecoveryPlanExecuteTypeE.MOUNT_REPLICA, MappingLunSubProcessor.class);
        if (null == recoveryProcesses || recoveryProcesses.isEmpty()) {
            return subProcessors;
        }
        for (RecoveryProcessor process : recoveryProcesses) {
            MappingLunSubProcessor mappingLunSubProcessor = (MappingLunSubProcessor)process;
            String lunId = mappingLunSubProcessor.getLunId();
            if (null == lunId || lunId.isEmpty()) continue;
            DeleteLunMappingSubProcessor subProcessor = new DeleteLunMappingSubProcessor();
            subProcessor.setProcName(subProcessor.getName());
            subProcessor.setProcType(this.getProcType());
            subProcessor.setPlanId(this.getPlanId());
            subProcessor.setProcessId(this.getProcessId());
            subProcessor.setParentProc((RecoveryProcessor)this);
            subProcessor.setLunId(mappingLunSubProcessor.getLunId());
            subProcessor.setLunName(mappingLunSubProcessor.getLunName());
            subProcessor.setLunWWN(mappingLunSubProcessor.getLunWWN());
            subProcessor.setDeviceId(mappingLunSubProcessor.getDeviceId());
            subProcessor.setHostOrGroupId(mappingLunSubProcessor.getHostOrGroupId());
            subProcessor.setHostOrGroupName(mappingLunSubProcessor.getHostOrGroupName());
            subProcessor.setResourceVO(vo);
            subProcessors.add((RecoveryProcessor)subProcessor);
        }
        return subProcessors;
    }

    private void scanDisk(RecoveryProcessorContext context) {
        ProtectGroup protectGroup = context.getProtectGroup();
        if (null != protectGroup && 11 == protectGroup.getPoType()) {
            logger.debug((Object)"no scan disk for Lun ProtectGroup.", -1L);
            return;
        }
        try {
            String hostOrGroupId = DrHostUtil.getCurrentDisasterHost(context.getRecoveryPlan(), this.getProcType());
            DrHostDeviceUtil.hostDiskScan(hostOrGroupId);
        }
        catch (Exception e) {
            logger.error((Object)("Fail to scanDisk" + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758786989L);
        }
    }
}

