/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.host.recovery.process;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.host.recovery.process.DeleteSnapshotMappingProcessor;
import com.huawei.ism.drm.host.recovery.process.MappingReplicaSubProcessor;
import com.huawei.ism.drm.host.util.DrHostDeviceUtil;
import com.huawei.ism.drm.host.util.DrHostUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.framework.process.MappingReplicaSubProcessorBuilderManager;
import com.huawei.ism.drm.recovery.process.IMappingReplicaSubProcessorBuilder;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.util.List;
import java.util.Set;

public class DeleteReplicaMappingProcessor
extends BaseRecoveryProcessor {
    private static final long serialVersionUID = -6337500585912342116L;
    private static final Log LOGGER = LogFactory.getInstance(DeleteSnapshotMappingProcessor.class);

    protected boolean execute(RecoveryProcessorContext context) {
        ProtectGroupReplica replica = context.getProtectGroupReplica();
        if (null == replica) {
            LOGGER.error((Object)"replica is null!");
            throw new LegoCheckedException(1073947393L);
        }
        MappingReplicaSubProcessorBuilderManager manager = MappingReplicaSubProcessorBuilderManager.getInstance();
        IMappingReplicaSubProcessorBuilder builder = manager.getBuider(replica.getType());
        List<RecoveryProcessor> mappingReplicaProcessors = this.queryMappingReplicaProcessor(context);
        if (null == mappingReplicaProcessors || mappingReplicaProcessors.isEmpty()) {
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
            return true;
        }
        Set processors = builder.buildDeleteMappingProcessor((RecoveryProcessor)this, mappingReplicaProcessors);
        this.setChildProc(processors);
        this.scanDisk(context);
        return this.executeSubProcessor(context);
    }

    protected String generateResultKey() {
        return null;
    }

    private List<RecoveryProcessor> queryMappingReplicaProcessor(RecoveryProcessorContext context) {
        DrmEnumDefine.RecoveryPlanExecuteTypeE lastRunType = DrmEnumDefine.RecoveryPlanExecuteTypeE.MOUNT_REPLICA;
        return this.getRecoveryProcessors(context.getRecoveryPlan(), lastRunType, MappingReplicaSubProcessor.class);
    }

    private void scanDisk(RecoveryProcessorContext context) {
        ProtectGroup protectGroup = context.getProtectGroup();
        if (null != protectGroup && 11 == protectGroup.getPoType()) {
            LOGGER.debug((Object)"no scan disk for Lun ProtectGroup.", -1L);
            return;
        }
        try {
            String hostOrGroupId = DrHostUtil.getCurrentDisasterHost(context.getRecoveryPlan(), this.getProcType());
            DrHostDeviceUtil.hostDiskScan(hostOrGroupId);
        }
        catch (Exception e) {
            LOGGER.error((Object)("Fail to scanDisk" + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758786989L);
        }
    }
}

