/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.host.recovery.process;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryProcessService;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryResourceService;
import com.huawei.ism.drm.host.recovery.process.DrmExecuteScriptSubProcessor;
import com.huawei.ism.drm.host.sdk.model.DrHost;
import com.huawei.ism.drm.host.sdk.model.DrHostGroup;
import com.huawei.ism.drm.host.util.DrHostUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.framework.task.RecoveryProcessSerialExecutor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.site.sdk.model.DrResource;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.exception.LegoUnsupportedOperationException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.JSONObject;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DrmExecuteScriptProcessor
extends BaseRecoveryProcessor {
    private static final long serialVersionUID = -7015772303561778033L;
    private static final Log logger = LogFactory.getInstance(DrmExecuteScriptProcessor.class);
    private static final boolean DO_RE_EXECUTE = true;
    private String processorName;
    private String scriptName;

    public String getProcessorName() {
        return this.processorName;
    }

    public void setProcessorName(String processorName) {
        this.processorName = processorName;
    }

    public String getScriptName() {
        return this.scriptName;
    }

    public void setScriptName(String scriptName) {
        this.scriptName = scriptName;
    }

    public void beforeExecRecoveryProcessor() {
        RecoveryPlan recoveryPlan = this.getContextRef().getRecoveryPlan();
        ProtectGroup protectGroup = recoveryPlan.getProtectGroup();
        if (VerifyUtil.isEmpty((Object)recoveryPlan) || VerifyUtil.isEmpty((Object)protectGroup)) {
            logger.error((Object)"recovery plan or protectGroup is null.");
            throw new LegoCheckedException(1073947393L);
        }
        int poType = protectGroup.getPoType();
        Map globalSettings = recoveryPlan.getGlobalSettings();
        int procType = this.getProcType();
        String disasterHostSn = (String)globalSettings.get("PG_DISASTER_HOST");
        if (DrmEnumDefine.RecoveryPlanExecuteTypeE.DRILLING.getValue() == procType && 11 == poType && !VerifyUtil.isEmpty((String)disasterHostSn)) {
            globalSettings.remove("EXEC_LOCAL_SCRIPT_WHEN_LUN");
            IRecoveryProcessService recoveryProcessService = (IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class);
            recoveryProcessService.deleteRecoveryProcessGlobalSettings(recoveryPlan.getPlanId(), "EXEC_LOCAL_SCRIPT_WHEN_LUN");
        }
        super.beforeExecRecoveryProcessor();
    }

    protected boolean execute(RecoveryProcessorContext context) {
        String executeFlag = (String)context.getRecoveryPlan().getGlobalSettings().get("EXEC_LOCAL_SCRIPT_WHEN_LUN");
        String string = executeFlag = executeFlag == null ? (String)context.getAttribute("EXEC_LOCAL_SCRIPT_WHEN_LUN") : executeFlag;
        if ("true".equals(executeFlag)) {
            this.updateProcessName(this.getProcName());
            JSONObject scriptParams = this.getScriptParams(context);
            if (scriptParams != null) {
                scriptParams = (JSONObject)scriptParams.get("params");
            }
            return super.executeLocalScript(this.getScriptName(), scriptParams, true);
        }
        String isSkip = (String)context.getRecoveryPlan().getGlobalSettings().get("isSkip");
        if ("true".equals(isSkip)) {
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
            this.updateProcessDetail("ism.drm.recovery.no.host.skip.step", new String[0]);
            return true;
        }
        RecoveryPlan recoveryPlan = context.getRecoveryPlan();
        Set<RecoveryProcessor> executeSubProcessors = this.createSubProcessors(recoveryPlan);
        if (VerifyUtil.isEmpty(executeSubProcessors)) {
            this.checkIfHasSubProcessor();
        }
        this.setHasChildProc(true);
        DrmEnumDefine.RecoveryPlanExecuteTypeE type = DrmEnumDefine.RecoveryPlanExecuteTypeE.getType((int)this.getProcType());
        RecoveryProcessSerialExecutor recoveryTemplate = RecoveryProcessSerialExecutor.createRecoveryProcessExecutor(executeSubProcessors, (DrmEnumDefine.RecoveryPlanExecuteTypeE)type);
        if (null == recoveryTemplate) {
            throw new LegoCheckedException(1073947394L);
        }
        recoveryTemplate.process(context);
        DrmEnumDefine.RecoveryPlanExecuteResultE procStatus = this.calcProcStatusBySubProc(executeSubProcessors);
        this.setProcStatus(procStatus.getValue());
        if (DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.equals((Object)procStatus)) {
            return true;
        }
        Boolean isContinueIfFailed = Boolean.parseBoolean((String)this.getProps().get("EXECUTE_POLICY"));
        return isContinueIfFailed != false;
    }

    protected String generateResultKey() {
        throw new LegoUnsupportedOperationException("The operation is not supported.");
    }

    public String getName() {
        return ((Object)((Object)this)).getClass().getName();
    }

    private Set<RecoveryProcessor> createSubProcessors(RecoveryPlan recoveryPlan) {
        String hostOrGroupId = DrHostUtil.getCurrentDisasterHost(recoveryPlan, this.getProcType());
        List<DrHost> disasterHosts = this.getDisasterHosts(hostOrGroupId);
        HashSet<RecoveryProcessor> executeSubProcessors = new HashSet<RecoveryProcessor>();
        Iterator pgIter = recoveryPlan.getProtectGroups().iterator();
        if (!pgIter.hasNext()) {
            throw new LegoCheckedException(1073947393L);
        }
        String uuid = ((ProtectGroup)pgIter.next()).getUuid();
        for (DrHost disasterHost : disasterHosts) {
            DrmExecuteScriptSubProcessor subProcessor = new DrmExecuteScriptSubProcessor();
            subProcessor.setHostId(disasterHost.getDeviceSn());
            subProcessor.setScriptName(this.getScriptName());
            subProcessor.setParentProcId(this.getProcId());
            subProcessor.setPgId(uuid);
            subProcessor.setProcName(subProcessor.getName());
            subProcessor.setProcType(this.getProcType());
            subProcessor.setPlanId(this.getPlanId());
            subProcessor.setProcessId(this.getProcessId());
            subProcessor.getProps().put("isUserDefined", "1");
            subProcessor.setParentProc((RecoveryProcessor)this);
            executeSubProcessors.add((RecoveryProcessor)subProcessor);
        }
        return executeSubProcessors;
    }

    private List<DrHost> getDisasterHosts(String hostOrGroupId) {
        IRecoveryResourceService recoveryService = (IRecoveryResourceService)ServiceLocator.getInstance().getService(IRecoveryResourceService.class);
        DrResource drResource = recoveryService.getDrResourceByID(hostOrGroupId);
        ArrayList<DrHost> drHosts = new ArrayList<DrHost>();
        if (drResource instanceof DrHost) {
            drHosts.add((DrHost)drResource);
        } else if (drResource instanceof DrHostGroup) {
            for (DrResource drHost : drResource.getChildResources()) {
                drHosts.add((DrHost)drHost);
            }
        }
        return drHosts;
    }

    private JSONObject getScriptParams(RecoveryProcessorContext context) {
        RecoveryPlan recoveryPlan = context.getRecoveryPlan();
        DrmExecuteScriptSubProcessor subProcessor = new DrmExecuteScriptSubProcessor();
        subProcessor.setScriptName(this.getScriptName());
        subProcessor.setParentProcId(this.getProcId());
        subProcessor.setPgId(recoveryPlan.getProtectGroup().getUuid());
        subProcessor.setProcName(subProcessor.getName());
        subProcessor.setProcType(this.getProcType());
        subProcessor.setPlanId(this.getPlanId());
        subProcessor.setProcessId(this.getProcessId());
        subProcessor.getProps().put("isUserDefined", "1");
        subProcessor.setParentProc((RecoveryProcessor)this);
        return subProcessor.getScriptParams(context);
    }
}

