/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.host.recovery.process;

import com.huawei.ism.array.sdk.model.HvsUnit;
import com.huawei.ism.array.sdk.model.Lun;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.model.RecoverySetting;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryResourceService;
import com.huawei.ism.drm.host.recovery.process.MappingLunProcessor;
import com.huawei.ism.drm.host.recovery.process.MappingReplicaSubProcessor;
import com.huawei.ism.drm.host.sdk.model.DrHost;
import com.huawei.ism.drm.operation.sdk.model.OperationResult;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.recovery.framework.util.RecoveryProcessUtil;
import com.huawei.ism.drm.recovery.process.RecoveryProcessResult;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.recovery.sdk.model.HostGroupVO;
import com.huawei.ism.drm.recovery.sdk.model.HostVO;
import com.huawei.ism.drm.recovery.sdk.model.ResourceVO;
import com.huawei.ism.drm.site.sdk.model.DrResource;
import com.huawei.ism.drm.storage.manager.proxy.StorageLunManagerProxy;
import com.huawei.ism.drm.storage.manager.sdk.service.IStorageLunBaseManager;
import com.huawei.ism.drm.util.RecoveryUtil;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class MappingLunSubProcessor
extends MappingReplicaSubProcessor {
    private static final long serialVersionUID = 7362124120139370182L;
    private static Log logger = LogFactory.getInstance(MappingLunProcessor.class);
    private String replicationId;
    private String srcDeviceId;
    private Integer relationType = 0;
    private String deviceId;
    private String lunId;
    private String lunWWN;
    private String lunName;
    private String hostOrGroupId;
    private String hostOrGroupName;
    private String poIds;
    private Boolean isCheckReplication = Boolean.TRUE;
    private transient ResourceVO resourceVO;
    private String lunGroupId;

    public String getReplicationId() {
        return this.replicationId;
    }

    public void setReplicationId(String replicationId) {
        this.replicationId = replicationId;
    }

    public String getSrcDeviceId() {
        return this.srcDeviceId;
    }

    public void setSrcDeviceId(String srcDeviceId) {
        this.srcDeviceId = srcDeviceId;
    }

    public Integer getRelationType() {
        return this.relationType;
    }

    public void setRelationType(Integer relationType) {
        this.relationType = relationType;
    }

    public String getPoIds() {
        return this.poIds;
    }

    public void setPoIds(String poIds) {
        this.poIds = poIds;
    }

    @Override
    public String getDeviceId() {
        return this.deviceId;
    }

    @Override
    public void setDeviceId(String deviceId) {
        this.deviceId = deviceId;
    }

    public String getLunId() {
        return this.lunId;
    }

    public void setLunId(String lunId) {
        this.lunId = lunId;
    }

    public String getLunWWN() {
        return this.lunWWN;
    }

    public void setLunWWN(String lunWWN) {
        this.lunWWN = lunWWN;
    }

    public String getLunName() {
        return this.lunName;
    }

    public void setLunName(String lunName) {
        this.lunName = lunName;
    }

    public String getHostOrGroupId() {
        return this.hostOrGroupId;
    }

    public void setHostOrGroupId(String hostOrGroupId) {
        this.hostOrGroupId = hostOrGroupId;
    }

    public String getHostOrGroupName() {
        return this.hostOrGroupName;
    }

    public void setHostOrGroupName(String hostOrGroupName) {
        this.hostOrGroupName = hostOrGroupName;
    }

    public Boolean getIsCheckReplication() {
        return this.isCheckReplication;
    }

    public void setIsCheckReplication(Boolean isCheckReplication) {
        this.isCheckReplication = isCheckReplication;
    }

    @Override
    public String getLunGroupId() {
        return this.lunGroupId;
    }

    @Override
    public void setLunGroupId(String lunGroupId) {
        this.lunGroupId = lunGroupId;
    }

    public String getName() {
        return ((Object)((Object)this)).getClass().getName();
    }

    @Override
    public final boolean execute(RecoveryProcessorContext context) {
        if (DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue() == this.getProcStatus() && !this.isChangedDisasterHost(context)) {
            this.updateProcessNameParams(new String[]{this.getLunName(), this.getHostOrGroupName()});
            this.updateProcessDetail("ism.drm.recovery.lun.already.mapped", new String[]{this.getLunName(), this.getHostOrGroupName()});
            return true;
        }
        this.setHostOrGroupId(this.getCurrentDisasterHost(context));
        OperationResult result = this.mappingLun(context);
        if (null == result) {
            throw new LegoCheckedException(1073947393L);
        }
        if (!result.isSuccess()) {
            this.updateProcessDetail("lego.err." + result.getErrorCode(), result.getArgs());
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
        } else {
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
        }
        return true;
    }

    protected OperationResult mappingLun(RecoveryProcessorContext context) {
        IRecoveryResourceService recoveryService = (IRecoveryResourceService)ServiceLocator.getInstance().getService(IRecoveryResourceService.class);
        Lun lun = recoveryService.getTargetLunById(this.getDeviceId(), this.getLunId());
        DrResource drResource = recoveryService.getDrResourceByID(this.getHostOrGroupId());
        if (null == lun || null == drResource) {
            this.updateProcessName("ism.drm.recovery.lun.mapping.failed");
            OperationResult operationResult = this.checkOperationObject(this.getDeviceId(), lun, drResource);
            return operationResult;
        }
        this.updateProcessNameParams(new String[]{lun.getName(), drResource.getName()});
        this.setLunName(lun.getName());
        this.setLunWWN(lun.getWwn());
        this.setHostOrGroupName(drResource.getName());
        if (DrmEnumDefine.RecoveryPlanExecuteTypeE.SNAPSHOT_ROLLBACK.getValue() != this.getProcType() && (null == this.isCheckReplication || this.isCheckReplication.booleanValue())) {
            String swapResultkey = RecoveryProcessResult.getSwapProcessResultKey((String)this.replicationId, (String)this.srcDeviceId, (String)this.getDeviceId(), (int)this.relationType);
            RecoveryProcessResult processResult = this.getContextRef().getProcessResult();
            boolean swapResult = processResult.getProcessResult(swapResultkey);
            if (!swapResult) {
                String[] errorParams = new String[]{this.replicationId};
                OperationResult operationResult = new OperationResult("Mapping", true, false, String.valueOf(1073948674L), errorParams);
                return operationResult;
            }
        }
        StorageLunManagerProxy storageManagerProxy = StorageLunManagerProxy.getInstance();
        String deviceType = recoveryService.getStorageType(this.getDeviceId());
        IStorageLunBaseManager proxy = storageManagerProxy.getStorageLunMgrByDevType(deviceType);
        if (null == this.resourceVO) {
            logger.info((Object)("resourceVO is null," + this.getHostOrGroupId()));
            OperationResult operationResult = new OperationResult("Mapping", true, false, String.valueOf(1073948717L), new String[]{drResource.getName()});
            return operationResult;
        }
        OperationResult operationResult = HvsUnit.class.getName().equals(deviceType) ? this.mappingLunForHvs(lun, drResource, proxy) : this.mappingLunForNoHvs(lun, drResource, proxy);
        return operationResult;
    }

    private OperationResult mappingLunForHvs(Lun lun, DrResource drResource, IStorageLunBaseManager proxy) {
        if (VerifyUtil.isEmpty((String)this.lunGroupId)) {
            return new OperationResult("Mapping", true, false, String.valueOf(1073948676L), new String[0]);
        }
        ArrayList<HostVO> hostVoList = new ArrayList<HostVO>();
        if (drResource.getClass().getName().equals(DrHost.class.getName())) {
            hostVoList.add((HostVO)this.resourceVO);
        } else {
            hostVoList.addAll(((HostGroupVO)this.resourceVO).getHostVOs());
        }
        return proxy.addLunToLunGroup(this.getDeviceId(), lun.getLunId(), hostVoList, this.lunGroupId, null);
    }

    private OperationResult mappingLunForNoHvs(Lun lun, DrResource drResource, IStorageLunBaseManager proxy) {
        if (drResource.getClass().getName().equals(DrHost.class.getName())) {
            return proxy.mappingLun(this.getDeviceId(), lun.getLunId(), (HostVO)this.resourceVO);
        }
        return proxy.mappingLun(this.getDeviceId(), lun.getLunId(), (HostGroupVO)this.resourceVO);
    }

    @Override
    public String generateResultKey() {
        return RecoveryProcessResult.getMappingLunProcResultKey((String)this.getLunId(), (String)this.getLunWWN(), (String)this.getHostOrGroupId(), (String)this.getDeviceId());
    }

    public Set<AbstractMap.SimpleEntry<String, Boolean>> getPoRecoveryStatus(RecoveryProcessorContext context) {
        HashSet<AbstractMap.SimpleEntry<String, Boolean>> entries = new HashSet<AbstractMap.SimpleEntry<String, Boolean>>();
        if (VerifyUtil.isEmpty((String)this.poIds)) {
            return entries;
        }
        boolean poRecoveryResult = DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue() == this.getProcStatus();
        List poIdList = RecoveryProcessUtil.getPoIds((String)this.poIds);
        for (String poId : poIdList) {
            String key = RecoveryProcessResult.getPoRecoveryStatusKey((int)this.getProcType(), (String)poId, (int)DrmEnumDefine.AppType.LUN.getValue());
            entries.add(new AbstractMap.SimpleEntry<String, Boolean>(key, poRecoveryResult));
        }
        return entries;
    }

    private OperationResult checkOperationObject(String tgtDeviceId, Lun lun, DrResource drResource) {
        String[] errorParams = null;
        String errorCode = null;
        if (null == lun) {
            errorParams = new String[]{this.getLunId(), tgtDeviceId};
            errorCode = String.valueOf(1073948685L);
        } else if (null == drResource) {
            errorParams = new String[]{this.getHostOrGroupId()};
            errorCode = String.valueOf(1073948686L);
        }
        return new OperationResult("Mapping", true, false, errorCode, errorParams);
    }

    private boolean isChangedDisasterHost(RecoveryProcessorContext context) {
        String currentDisasterHost = this.getCurrentDisasterHost(context);
        return !this.getHostOrGroupId().equals(currentDisasterHost);
    }

    private String getCurrentDisasterHost(RecoveryProcessorContext context) {
        RecoveryPlan recoveryPlan = context.getRecoveryPlan();
        if (DrmEnumDefine.RecoveryPlanExecuteTypeE.SNAPSHOT_ROLLBACK.getValue() == this.getProcType()) {
            return this.getHostOrGroupId();
        }
        Iterator pgIter = recoveryPlan.getProtectGroups().iterator();
        if (!pgIter.hasNext()) {
            throw new LegoCheckedException(1073947393L);
        }
        String pgUUID = ((ProtectGroup)pgIter.next()).getUuid();
        RecoverySetting curDisasterHostSetting = RecoveryUtil.getRecoverySetting((String)recoveryPlan.getPlanId(), (String)pgUUID, (String)"PG_DISASTER_HOST", (Set)recoveryPlan.getRecoverySettings());
        if (null == curDisasterHostSetting) {
            throw new LegoCheckedException(-1L, "The setting of disaster host does not exist.planId:" + recoveryPlan.getPlanId());
        }
        return curDisasterHostSetting.getValue();
    }

    public ResourceVO getResourceVO() {
        return this.resourceVO;
    }

    public void setResourceVO(ResourceVO resourceVO) {
        this.resourceVO = resourceVO;
    }
}

