/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.host.recovery.process;

import com.huawei.ism.array.sdk.model.HvsUnit;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryResourceService;
import com.huawei.ism.drm.host.recovery.process.MappingReplicaSubProcessor;
import com.huawei.ism.drm.operation.sdk.model.OperationResult;
import com.huawei.ism.drm.recovery.process.RecoveryProcessResult;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.site.sdk.model.DrResource;
import com.huawei.ism.drm.storage.manager.proxy.StorageSnapshotManagerProxy;
import com.huawei.ism.drm.storage.manager.sdk.service.IStorageSnapshotManager;
import com.huawei.ism.drm.storage.sdk.model.ArraySnapshot;
import com.huawei.ism.drm.storage.sdk.model.Snapshot;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import java.util.Collection;
import java.util.List;

public class MappingSnapshotReplicaSubProcessor
extends MappingReplicaSubProcessor {
    private static final long serialVersionUID = -5945130921057627327L;
    private String snapshotWWN;

    @Override
    protected boolean execute(RecoveryProcessorContext context) {
        OperationResult result = this.mappingSnapshot();
        if (null == result) {
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
        } else if (!result.isSuccess()) {
            this.updateProcessDetail("lego.err." + result.getErrorCode(), result.getArgs());
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
        } else {
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
        }
        return true;
    }

    private OperationResult mappingSnapshot() {
        OperationResult operationResult = null;
        IRecoveryResourceService recoveryService = (IRecoveryResourceService)ServiceLocator.getInstance().getService(IRecoveryResourceService.class);
        DrResource drResource = recoveryService.getDrResourceByID(this.getMountHostOrHostGroupId());
        if (null == drResource) {
            this.updateProcessName("ism.drm.recovery.snapshot.mapping.failed");
            operationResult = this.checkOperationObject();
            return operationResult;
        }
        this.updateProcessNameParams(new String[]{this.getReplicaName(), drResource.getName()});
        StorageSnapshotManagerProxy storageManagerProxy = StorageSnapshotManagerProxy.getInstance();
        String deviceType = recoveryService.getStorageType(this.getDeviceId());
        IStorageSnapshotManager proxy = storageManagerProxy.getStorageSnapshotMgrByDevType(deviceType);
        ArraySnapshot arraySnapshot = new ArraySnapshot();
        arraySnapshot.setId(this.getReplicaId());
        arraySnapshot.setSnapshotName(this.getReplicaName());
        if (HvsUnit.class.getName().equals(deviceType)) {
            operationResult = this.mappingSnapshotnForHvs((Snapshot)arraySnapshot, proxy);
        }
        return operationResult;
    }

    private OperationResult mappingSnapshotnForHvs(Snapshot arraySnapshot, IStorageSnapshotManager proxy) {
        String lunGroupId = this.getLunGroupId();
        if (VerifyUtil.isEmpty((String)lunGroupId)) {
            return new OperationResult("Mapping", true, false, String.valueOf(1073948676L), new String[0]);
        }
        List snapshots = proxy.getSnapshot(this.getDeviceId(), arraySnapshot);
        if (!VerifyUtil.isEmpty((Collection)snapshots)) {
            this.snapshotWWN = ((Snapshot)snapshots.get(0)).getWwn();
        }
        return proxy.addSnapshotToLunGroup(this.getDeviceId(), arraySnapshot, lunGroupId, null);
    }

    @Override
    protected String generateResultKey() {
        return RecoveryProcessResult.getMappingLunProcResultKey((String)this.getReplicaSourceId(), (String)this.getReplicaId(), (String)this.snapshotWWN, (String)this.getMountHostOrHostGroupId(), (String)this.getDeviceId());
    }

    private OperationResult checkOperationObject() {
        String[] errorParams = new String[]{this.getMountHostOrHostGroupId()};
        String errorCode = String.valueOf(1073948686L);
        return new OperationResult("Mapping", true, false, errorCode, errorParams);
    }
}

