/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.host.recovery.process;

import com.huawei.ism.drm.host.recovery.process.UmountHostDeviceSubProcessor;
import com.huawei.ism.drm.host.sdk.model.DrHost;
import com.huawei.ism.drm.host.sdk.service.IHostService;
import com.huawei.ism.drm.host.util.DrHostUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.site.sdk.model.DrResource;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class UmountProHostDeviceSubProcessor
extends UmountHostDeviceSubProcessor {
    private static final long serialVersionUID = -5853425012712581643L;
    private static final Log LOGGER = LogFactory.getInstance(UmountProHostDeviceSubProcessor.class);

    @Override
    protected void umountToHost() {
        List<DrHost> drHosts = DrHostUtil.getDrHostBySNs(new String[]{this.getHostSN()});
        if (VerifyUtil.isEmpty(drHosts) || null == drHosts.get(0)) {
            LOGGER.error((Object)("umount host name(" + this.getHostName() + ") fail,DrHost is null."), 90160758786989L);
            this.setResult(Boolean.FALSE);
            return;
        }
        List<ProtectObject> protectObjects = this.getProtectObjects();
        if (VerifyUtil.isEmpty(protectObjects)) {
            LOGGER.error((Object)("umount host name(" + this.getHostName() + ") fail,protectObjects is null."), 90160758786989L);
            this.setResult(Boolean.FALSE);
            return;
        }
        ArrayList<String> poUuidList = new ArrayList<String>();
        for (ProtectObject po : protectObjects) {
            poUuidList.add(po.getUuid());
        }
        this.executeSubProcessByLocalSite(drHosts, poUuidList);
    }

    protected void executeSubProcessByLocalSite(List<DrHost> hosts, List<String> poUuidList) {
        IHostService hostService = (IHostService)ServiceLocator.getInstance().getService(IHostService.class);
        for (DrResource drResource : hosts) {
            Map resultMap = hostService.umountDevices(drResource.getDeviceSn(), poUuidList);
            for (Map.Entry entry : resultMap.entrySet()) {
                if ((Long)entry.getValue() == 0L) continue;
                this.setResult(Boolean.FALSE);
                this.setErrorCode((Long)entry.getValue());
            }
        }
    }
}

