/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.host.recovery.process.builder;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.host.recovery.process.DeleteLunMappingSubProcessor;
import com.huawei.ism.drm.host.recovery.process.MappingLunSubProcessor;
import com.huawei.ism.drm.host.util.DrHostUtil;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectObjectReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.RelicaStorageInfo;
import com.huawei.ism.drm.recovery.process.IMappingReplicaSubProcessorBuilder;
import com.huawei.ism.drm.recovery.sdk.model.ResourceVO;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class MappingDoradoCloneReplicaProcessorBuilder
implements IMappingReplicaSubProcessorBuilder {
    private static final long serialVersionUID = -6939531521084687604L;
    private static final Log logger = LogFactory.getInstance(MappingDoradoCloneReplicaProcessorBuilder.class);

    public Set<RecoveryProcessor> buildMappingProcessor(RecoveryProcessor parent, ProtectGroupReplica replia) {
        HashSet<RecoveryProcessor> results = new HashSet<RecoveryProcessor>();
        String hostOrHostgroupId = replia.getMountedHost();
        HashSet<String> hostOrGroupIds = new HashSet<String>();
        hostOrGroupIds.add(hostOrHostgroupId);
        Map<String, ResourceVO> resourceVOs = DrHostUtil.getHostInitiators(hostOrGroupIds);
        if (null == resourceVOs || null == resourceVOs.get(hostOrHostgroupId)) {
            logger.error((Object)"hostSn or scriptName is empty", 90160758786989L);
            throw new LegoCheckedException(1073948686L);
        }
        ResourceVO vo = resourceVOs.get(hostOrHostgroupId);
        Set protectObjectReplicaList = replia.getReplicas();
        for (ProtectObjectReplica protectObjectReplica : protectObjectReplicaList) {
            Set storageReplicaList = protectObjectReplica.getStorageInfos();
            for (RelicaStorageInfo storageInfo : storageReplicaList) {
                MappingLunSubProcessor processor = new MappingLunSubProcessor();
                processor.setProcName("com.huawei.ism.drm.host.recovery.process.MappingDoradoCloneReplicaProcessorBuilder");
                processor.setProcType(parent.getProcType());
                processor.setPlanId(parent.getPlanId());
                processor.setProcessId(parent.getProcessId());
                processor.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.OTHER.getValue());
                processor.setParentProc(parent);
                processor.setDeviceId(storageInfo.getSrcStorageProviderSN());
                processor.setSrcDeviceId(storageInfo.getSrcStorageProviderSN());
                processor.setLunId(storageInfo.getStorageId());
                processor.setLunGroupId(replia.getProperty("lunGroupId"));
                processor.setResourceVO(vo);
                processor.setHostOrGroupId(hostOrHostgroupId);
                processor.setIsCheckReplication(false);
                results.add((RecoveryProcessor)processor);
            }
        }
        return results;
    }

    public Set<RecoveryProcessor> buildDeleteMappingProcessor(RecoveryProcessor parent, List<RecoveryProcessor> processors) {
        HashSet<RecoveryProcessor> results = new HashSet<RecoveryProcessor>();
        for (RecoveryProcessor processor : processors) {
            if (!(processor instanceof MappingLunSubProcessor)) continue;
            MappingLunSubProcessor tmpProcessor = (MappingLunSubProcessor)processor;
            DeleteLunMappingSubProcessor deleteMappingProcessor = new DeleteLunMappingSubProcessor();
            deleteMappingProcessor.setProcName(tmpProcessor.getName());
            deleteMappingProcessor.setProcType(parent.getProcType());
            deleteMappingProcessor.setPlanId(parent.getPlanId());
            deleteMappingProcessor.setProcessId(parent.getProcessId());
            deleteMappingProcessor.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.OTHER.getValue());
            deleteMappingProcessor.setParentProc(parent);
            deleteMappingProcessor.setLunId(tmpProcessor.getLunId());
            deleteMappingProcessor.setLunWWN(tmpProcessor.getLunWWN());
            deleteMappingProcessor.setLunName(tmpProcessor.getLunName());
            deleteMappingProcessor.setDeviceId(tmpProcessor.getDeviceId());
            deleteMappingProcessor.setHostOrGroupId(tmpProcessor.getHostOrGroupId());
            deleteMappingProcessor.setHostOrGroupName(tmpProcessor.getHostOrGroupName());
            HashSet<String> hostOrGroupIds = new HashSet<String>();
            hostOrGroupIds.add(tmpProcessor.getHostOrGroupId());
            Map<String, ResourceVO> resourceVOs = DrHostUtil.getHostInitiators(hostOrGroupIds);
            if (null == resourceVOs || null == resourceVOs.get(tmpProcessor.getHostOrGroupId())) {
                logger.error((Object)"hostSn or scriptName is empty", 90160758786989L);
                throw new LegoCheckedException(0x300001L);
            }
            ResourceVO vo = resourceVOs.get(tmpProcessor.getHostOrGroupId());
            deleteMappingProcessor.setResourceVO(vo);
            results.add((RecoveryProcessor)deleteMappingProcessor);
        }
        return results;
    }

    public int getReplicaType() {
        return 5;
    }
}

